/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht.alg.tour;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import paper.libs.org.jgrapht.Graph;
import paper.libs.org.jgrapht.GraphPath;
import paper.libs.org.jgrapht.GraphTests;
import paper.libs.org.jgrapht.alg.cycle.HierholzerEulerianCycle;
import paper.libs.org.jgrapht.alg.interfaces.HamiltonianCycleAlgorithm;
import paper.libs.org.jgrapht.alg.matching.blossom.v5.KolmogorovWeightedPerfectMatching;
import paper.libs.org.jgrapht.alg.spanning.KruskalMinimumSpanningTree;
import paper.libs.org.jgrapht.graph.AsSubgraph;
import paper.libs.org.jgrapht.graph.DefaultEdge;
import paper.libs.org.jgrapht.graph.GraphWalk;
import paper.libs.org.jgrapht.graph.Pseudograph;
import paper.libs.org.jgrapht.util.CollectionUtil;

public class ChristofidesThreeHalvesApproxMetricTSP<V, E>
implements HamiltonianCycleAlgorithm<V, E> {
    @Override
    public GraphPath<V, E> getTour(Graph<V, E> graph) {
        if (!graph.getType().isUndirected()) {
            throw new IllegalArgumentException("Graph must be undirected");
        }
        if (!GraphTests.isComplete(graph)) {
            throw new IllegalArgumentException("Graph must be complete");
        }
        if (graph.vertexSet().isEmpty()) {
            throw new IllegalArgumentException("Graph contains no vertices");
        }
        if (graph.vertexSet().size() == 1) {
            V start = graph.vertexSet().iterator().next();
            return new GraphWalk<V, E>(graph, start, start, Collections.singletonList(start), Collections.emptyList(), 0.0);
        }
        int n = graph.vertexSet().size();
        Pseudograph mstAndMatching = new Pseudograph(DefaultEdge.class);
        graph.vertexSet().forEach(mstAndMatching::addVertex);
        KruskalMinimumSpanningTree<V, E> spanningTreeAlgorithm = new KruskalMinimumSpanningTree<V, E>(graph);
        spanningTreeAlgorithm.getSpanningTree().getEdges().forEach(e -> mstAndMatching.addEdge(graph.getEdgeSource(e), graph.getEdgeTarget(e)));
        Set oddDegreeVertices = mstAndMatching.vertexSet().stream().filter(v -> (mstAndMatching.edgesOf(v).size() & 1) == 1).collect(Collectors.toSet());
        AsSubgraph<V, E> subgraph = new AsSubgraph<V, E>(graph, oddDegreeVertices);
        KolmogorovWeightedPerfectMatching<V, E> matchingAlgorithm = new KolmogorovWeightedPerfectMatching<V, E>(subgraph);
        matchingAlgorithm.getMatching().getEdges().forEach(e -> mstAndMatching.addEdge(graph.getEdgeSource(e), graph.getEdgeTarget(e)));
        HierholzerEulerianCycle eulerianCycleAlgorithm = new HierholzerEulerianCycle();
        GraphPath eulerianCycle = eulerianCycleAlgorithm.getEulerianCycle(mstAndMatching);
        HashSet visited = CollectionUtil.newHashSetWithExpectedSize(n);
        List tourVertices = eulerianCycle.getVertexList().stream().filter(visited::add).collect(Collectors.toList());
        tourVertices.add(tourVertices.get(0));
        ArrayList<E> tourEdges = new ArrayList<E>(n);
        double tourWeight = 0.0;
        Object next = tourVertices.get(0);
        for (int i2 = 1; i2 <= n; ++i2) {
            Object prev = next;
            next = tourVertices.get(i2);
            E edge = graph.getEdge(prev, next);
            tourEdges.add(edge);
            tourWeight += graph.getEdgeWeight(edge);
        }
        return new GraphWalk<V, E>(graph, tourVertices.get(0), tourVertices.get(0), tourVertices, tourEdges, tourWeight);
    }
}

