/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht.alg.scoring;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.ToDoubleFunction;
import paper.libs.org.jgrapht.Graph;
import paper.libs.org.jgrapht.Graphs;
import paper.libs.org.jgrapht.alg.interfaces.VertexScoringAlgorithm;

public final class AlphaCentrality<V, E>
implements VertexScoringAlgorithm<V, Double> {
    public static final int MAX_ITERATIONS_DEFAULT = 100;
    public static final double TOLERANCE_DEFAULT = 1.0E-4;
    public static final double DAMPING_FACTOR_DEFAULT = 0.01;
    public static final double EXOGENOUS_FACTOR_DEFAULT = 1.0;
    private final Graph<V, E> g;
    private Map<V, Double> scores;

    public AlphaCentrality(Graph<V, E> g) {
        this(g, 0.01, 1.0, 100, 1.0E-4);
    }

    public AlphaCentrality(Graph<V, E> g, double dampingFactor) {
        this(g, dampingFactor, 1.0, 100, 1.0E-4);
    }

    public AlphaCentrality(Graph<V, E> g, double dampingFactor, double exogenousFactor) {
        this(g, dampingFactor, exogenousFactor, 100, 1.0E-4);
    }

    public AlphaCentrality(Graph<V, E> g, double dampingFactor, ToDoubleFunction<V> exogenousFactorFunction) {
        this(g, dampingFactor, exogenousFactorFunction, 100, 1.0E-4);
    }

    public AlphaCentrality(Graph<V, E> g, double dampingFactor, double exogenousFactor, int maxIterations) {
        this(g, dampingFactor, exogenousFactor, maxIterations, 1.0E-4);
    }

    public AlphaCentrality(Graph<V, E> g, double dampingFactor, ToDoubleFunction<V> exogenousFactorFunction, int maxIterations) {
        this(g, dampingFactor, exogenousFactorFunction, maxIterations, 1.0E-4);
    }

    public AlphaCentrality(Graph<V, E> g, double dampingFactor, double exogenousFactor, int maxIterations, double tolerance) {
        this.g = g;
        this.scores = new HashMap<V, Double>();
        this.validate(dampingFactor, maxIterations, tolerance);
        ToDoubleFunction<Object> exofactorFunction = v -> exogenousFactor;
        this.run(dampingFactor, exofactorFunction, maxIterations, tolerance);
    }

    public AlphaCentrality(Graph<V, E> g, double dampingFactor, ToDoubleFunction<V> exogenousFactorFunction, int maxIterations, double tolerance) {
        this.g = g;
        this.scores = new HashMap<V, Double>();
        this.validate(dampingFactor, maxIterations, tolerance);
        this.run(dampingFactor, exogenousFactorFunction, maxIterations, tolerance);
    }

    @Override
    public Map<V, Double> getScores() {
        return Collections.unmodifiableMap(this.scores);
    }

    @Override
    public Double getVertexScore(V v) {
        if (!this.g.containsVertex(v)) {
            throw new IllegalArgumentException("Cannot return score of unknown vertex");
        }
        return this.scores.get(v);
    }

    private void validate(double dampingFactor, int maxIterations, double tolerance) {
        if (maxIterations <= 0) {
            throw new IllegalArgumentException("Maximum iterations must be positive");
        }
        if (dampingFactor < 0.0 || dampingFactor > 1.0) {
            throw new IllegalArgumentException("Damping factor not valid");
        }
        if (tolerance <= 0.0) {
            throw new IllegalArgumentException("Tolerance not valid, must be positive");
        }
    }

    private void run(double dampingFactor, ToDoubleFunction<V> exofactorFunction, int maxIterations, double tolerance) {
        int totalVertices = this.g.vertexSet().size();
        double initScore = 1.0 / (double)totalVertices;
        for (V v : this.g.vertexSet()) {
            this.scores.put((Double)v, initScore);
        }
        Map<Double, Double> nextScores = new HashMap<V, Double>();
        double maxChange = tolerance;
        while (maxIterations > 0 && maxChange >= tolerance) {
            maxChange = 0.0;
            for (V v : this.g.vertexSet()) {
                double contribution = 0.0;
                for (E e : this.g.incomingEdgesOf(v)) {
                    V w = Graphs.getOppositeVertex(this.g, e, v);
                    contribution += dampingFactor * this.scores.get(w) * this.g.getEdgeWeight(e);
                }
                double vOldValue = this.scores.get(v);
                double vNewValue = contribution + exofactorFunction.applyAsDouble(v);
                maxChange = Math.max(maxChange, Math.abs(vNewValue - vOldValue));
                nextScores.put((Double)v, vNewValue);
            }
            Map<V, Double> tmp = this.scores;
            this.scores = nextScores;
            nextScores = tmp;
            --maxIterations;
        }
    }
}

