/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.osgi.internal.log;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import paper.libs.org.eclipse.osgi.internal.log.ExtendedLogServiceFactory;
import paper.libs.org.osgi.framework.Bundle;
import paper.libs.org.osgi.framework.BundleContext;
import paper.libs.org.osgi.framework.ServiceReference;
import paper.libs.org.osgi.framework.ServiceRegistration;
import paper.libs.org.osgi.service.log.LogLevel;
import paper.libs.org.osgi.util.tracker.ServiceTracker;
import paper.libs.org.osgi.util.tracker.ServiceTrackerCustomizer;

class ConfigAdminListener
implements ServiceTrackerCustomizer<Object, ServiceRegistration<?>> {
    private static final String CLASS_CONFIG_ADMIN = "paper.libs.org.osgi.service.cm.ConfigurationAdmin";
    private static final String METHOD_CONFIG_ADMIN_GET_CONFIGURATION = "getConfiguration";
    private static final String METHOD_CONFIG_ADMIN_LIST_CONFIGURATIONS = "listConfigurations";
    private static final String CLASS_SYNC_CONFIG_LISTENER = "paper.libs.org.osgi.service.cm.SynchronousConfigurationListener";
    private static final String CLASS_CONFIG_EVENT = "paper.libs.org.osgi.service.cm.ConfigurationEvent";
    private static final String METHOD_CONFIG_EVENT_GET_PID = "getPid";
    private static final String METHOD_CONFIG_EVENT_GET_FACTORY_PID = "getFactoryPid";
    private static final String METHOD_CONFIG_EVENT_GET_REFERENCE = "getReference";
    private static final String METHOD_CONFIG_EVENT_GET_TYPE = "getType";
    private static final int CM_UPDATED = 1;
    private static final int CM_DELETED = 2;
    private static final int CM_LOCATION_CHANGED = 3;
    private static final String CLASS_CONFIG = "paper.libs.org.osgi.service.cm.Configuration";
    private static final String METHOD_CONFIG_GET_PROPERTIES = "getProperties";
    private static final String METHOD_CONFIG_GET_PID = "getPid";
    private static final String METHOD_CONFIG_GET_FACTORY_PID = "getFactoryPid";
    private static final String PID_PREFIX_LOG_ADMIN = "paper.libs.org.osgi.service.log.admin";
    private static final String PID_FILTER = "(service.pid=org.osgi.service.log.admin*)";
    private final ServiceTracker<Object, ServiceRegistration<?>> configTracker;
    final ExtendedLogServiceFactory factory;
    final BundleContext context;

    ConfigAdminListener(BundleContext context, ExtendedLogServiceFactory factory) {
        this.context = context;
        this.configTracker = new ServiceTracker(context, CLASS_CONFIG_ADMIN, this);
        this.factory = factory;
    }

    void start() {
        this.configTracker.open();
    }

    void stop() {
        this.configTracker.close();
    }

    private ServiceRegistration<?> registerConfigurationListener(ServiceReference<?> configRef) {
        try {
            Class<?> listenerClass = configRef.getBundle().loadClass(CLASS_SYNC_CONFIG_LISTENER);
            return this.registerProxyConfigListener(configRef, listenerClass);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(CLASS_SYNC_CONFIG_LISTENER, e);
        }
    }

    private ServiceRegistration<?> registerProxyConfigListener(ServiceReference<?> configRef, Class<?> listenerClass) throws ClassNotFoundException, NoSuchMethodException {
        LoggerContextConfiguration loggerConfiguration = new LoggerContextConfiguration(listenerClass, configRef);
        return loggerConfiguration.register();
    }

    @Override
    public ServiceRegistration<?> addingService(ServiceReference<Object> configRef) {
        return this.registerConfigurationListener(configRef);
    }

    @Override
    public void modifiedService(ServiceReference<Object> configRef, ServiceRegistration<?> configReg) {
    }

    @Override
    public void removedService(ServiceReference<Object> configRef, ServiceRegistration<?> loggerConfiguration) {
        loggerConfiguration.unregister();
    }

    class LoggerContextConfiguration
    implements InvocationHandler {
        private final Object listenerProxy;
        private final Object configAdmin;
        private final ServiceReference<?> configAdminRef;
        private final Class<?> configClass;
        private final Method getConfigProperties;
        private final Method getConfigPid;
        private final Method getConfigFactoryPid;
        private final Class<?> configAdminClass;
        private final Method getConfiguration;
        private final Method listConfigurations;
        private final Class<?> configEventClass;
        private final Method getEventPid;
        private final Method getEventFactoryPid;
        private final Method getEventReference;
        private final Method getEventType;

        public LoggerContextConfiguration(Class<?> listenerClass, ServiceReference<?> ref) throws ClassNotFoundException, NoSuchMethodException {
            this.listenerProxy = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, (InvocationHandler)this);
            this.configAdminRef = ref;
            ClassLoader cl = listenerClass.getClassLoader();
            this.configClass = cl.loadClass(ConfigAdminListener.CLASS_CONFIG);
            this.getConfigProperties = this.configClass.getMethod(ConfigAdminListener.METHOD_CONFIG_GET_PROPERTIES, new Class[0]);
            this.getConfigFactoryPid = this.configClass.getMethod("getFactoryPid", new Class[0]);
            this.getConfigPid = this.configClass.getMethod("getPid", new Class[0]);
            this.configAdminClass = cl.loadClass(ConfigAdminListener.CLASS_CONFIG_ADMIN);
            this.getConfiguration = this.configAdminClass.getMethod(ConfigAdminListener.METHOD_CONFIG_ADMIN_GET_CONFIGURATION, String.class, String.class);
            this.listConfigurations = this.configAdminClass.getMethod(ConfigAdminListener.METHOD_CONFIG_ADMIN_LIST_CONFIGURATIONS, String.class);
            this.configEventClass = cl.loadClass(ConfigAdminListener.CLASS_CONFIG_EVENT);
            this.getEventPid = this.configEventClass.getMethod("getPid", new Class[0]);
            this.getEventFactoryPid = this.configEventClass.getMethod("getFactoryPid", new Class[0]);
            this.getEventReference = this.configEventClass.getMethod(ConfigAdminListener.METHOD_CONFIG_EVENT_GET_REFERENCE, new Class[0]);
            this.getEventType = this.configEventClass.getMethod(ConfigAdminListener.METHOD_CONFIG_EVENT_GET_TYPE, new Class[0]);
            this.configAdmin = ConfigAdminListener.this.context.getService(ref);
        }

        public ServiceRegistration<?> register() {
            BundleContext configContext;
            Bundle configBundle = this.configAdminRef.getBundle();
            BundleContext bundleContext = configContext = configBundle != null ? this.configAdminRef.getBundle().getBundleContext() : null;
            if (configContext == null) {
                return null;
            }
            ServiceRegistration<?> registration = configContext.registerService(ConfigAdminListener.CLASS_SYNC_CONFIG_LISTENER, this.listenerProxy, null);
            try {
                Object[] configs = (Object[])this.listConfigurations.invoke(this.configAdmin, ConfigAdminListener.PID_FILTER);
                if (configs != null) {
                    Object[] objectArray = configs;
                    int n = configs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object config = objectArray[n2];
                        String factoryPid = (String)this.getConfigFactoryPid.invoke(config, new Object[0]);
                        if (factoryPid == null) {
                            String pid = (String)this.getConfigPid.invoke(config, new Object[0]);
                            String contextName = this.getContextName(pid);
                            Dictionary configDictionary = (Dictionary)this.getConfigProperties.invoke(config, new Object[0]);
                            if (configDictionary != null) {
                                this.setLogLevels(contextName, this.getLogLevels(configDictionary));
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            return registration;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] event) throws Throwable {
            if (!this.configAdminRef.equals(this.getReference(event))) {
                return null;
            }
            String pid = this.getEventPid(event);
            if (pid == null) {
                return null;
            }
            int type = this.getType(event);
            if (type == 3) {
                return null;
            }
            String contextName = this.getContextName(pid);
            if (type == 2) {
                this.setLogLevels(contextName, Collections.emptyMap());
                return null;
            }
            if (type == 1) {
                Dictionary<String, Object> configDictionary = this.findConfiguration(pid);
                if (configDictionary == null) {
                    this.setLogLevels(contextName, Collections.emptyMap());
                    return null;
                }
                Map<String, LogLevel> levelConfig = this.getLogLevels(configDictionary);
                this.setLogLevels(contextName, levelConfig);
            }
            return null;
        }

        private String getContextName(String pid) {
            if (ConfigAdminListener.PID_PREFIX_LOG_ADMIN.equals(pid)) {
                return null;
            }
            char separator = pid.charAt(ConfigAdminListener.PID_PREFIX_LOG_ADMIN.length());
            if (separator != '|') {
                return null;
            }
            int startName = ConfigAdminListener.PID_PREFIX_LOG_ADMIN.length() + 1;
            return pid.substring(startName);
        }

        private Map<String, LogLevel> getLogLevels(Dictionary<String, Object> configDictionary) {
            HashMap<String, LogLevel> result = new HashMap<String, LogLevel>(configDictionary.size());
            Enumeration<String> keys = configDictionary.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                Object v = configDictionary.get(key);
                if (!(v instanceof String)) continue;
                try {
                    result.put(key, LogLevel.valueOf((String)v));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return result;
        }

        private Object getReference(Object[] event) {
            try {
                return this.getEventReference.invoke(event[0], new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        private String getEventPid(Object[] event) {
            block4: {
                String factoryPid = (String)this.getEventFactoryPid.invoke(event[0], new Object[0]);
                if (factoryPid == null) break block4;
                return null;
            }
            try {
                String pid = (String)this.getEventPid.invoke(event[0], new Object[0]);
                if (pid.startsWith(ConfigAdminListener.PID_PREFIX_LOG_ADMIN)) {
                    return pid;
                }
                return null;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        private int getType(Object[] event) {
            try {
                Integer type = (Integer)this.getEventType.invoke(event[0], new Object[0]);
                return type == null ? 0 : type;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        private Dictionary<String, Object> findConfiguration(String pid) {
            try {
                Object config = this.getConfiguration.invoke(this.configAdmin, pid, null);
                return (Dictionary)this.getConfigProperties.invoke(config, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        private void setLogLevels(String contextName, Map<String, LogLevel> logLevels) {
            ConfigAdminListener.this.factory.getLoggerAdmin().getLoggerContext(contextName).setLogLevels(logLevels);
        }
    }
}

