/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.osgi.internal.loader.classpath;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import paper.libs.org.eclipse.osgi.container.Module;
import paper.libs.org.eclipse.osgi.container.ModuleCapability;
import paper.libs.org.eclipse.osgi.container.ModuleContainerAdaptor;
import paper.libs.org.eclipse.osgi.container.ModuleRevision;
import paper.libs.org.eclipse.osgi.container.ModuleWire;
import paper.libs.org.eclipse.osgi.framework.util.ArrayMap;
import paper.libs.org.eclipse.osgi.internal.debug.Debug;
import paper.libs.org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import paper.libs.org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import paper.libs.org.eclipse.osgi.internal.hookregistry.HookRegistry;
import paper.libs.org.eclipse.osgi.internal.loader.ModuleClassLoader;
import paper.libs.org.eclipse.osgi.internal.loader.classpath.ClasspathEntry;
import paper.libs.org.eclipse.osgi.internal.loader.classpath.FragmentClasspath;
import paper.libs.org.eclipse.osgi.internal.loader.classpath.ManifestPackageAttributes;
import paper.libs.org.eclipse.osgi.internal.loader.classpath.TitleVersionVendor;
import paper.libs.org.eclipse.osgi.internal.messages.Msg;
import paper.libs.org.eclipse.osgi.internal.weaving.WeavingHookConfigurator;
import paper.libs.org.eclipse.osgi.storage.BundleInfo;
import paper.libs.org.eclipse.osgi.storage.Storage;
import paper.libs.org.eclipse.osgi.storage.bundlefile.BundleEntry;
import paper.libs.org.eclipse.osgi.storage.bundlefile.BundleFile;
import paper.libs.org.eclipse.osgi.util.NLS;
import paper.libs.org.osgi.framework.BundleException;
import paper.libs.org.osgi.framework.FrameworkListener;

public class ClasspathManager {
    private static final FragmentClasspath[] emptyFragments = new FragmentClasspath[0];
    private static final String[] DEFAULT_CLASSPATH = new String[]{"."};
    private final BundleInfo.Generation generation;
    private final ModuleClassLoader classloader;
    private final HookRegistry hookRegistry;
    private final Debug debug;
    private final ClasspathEntry[] entries;
    private volatile FragmentClasspath[] fragments;
    private ArrayMap<String, String> loadedLibraries = null;
    private ThreadLocal<DefineContext> currentDefineContext = new ThreadLocal();

    public ClasspathManager(BundleInfo.Generation generation, ModuleClassLoader classloader) {
        EquinoxConfiguration configuration = generation.getBundleInfo().getStorage().getConfiguration();
        this.debug = configuration.getDebug();
        this.hookRegistry = configuration.getHookRegistry();
        this.generation = generation;
        this.classloader = classloader;
        String[] cp = ClasspathManager.getClassPath(generation.getRevision());
        this.fragments = this.buildFragmentClasspaths(this.classloader, this);
        this.entries = this.buildClasspath(cp, this, this.generation);
    }

    private static String[] getClassPath(ModuleRevision revision) {
        List<ModuleCapability> moduleDatas = revision.getModuleCapabilities("equinox.module.data");
        List cp = moduleDatas.isEmpty() ? null : (List)moduleDatas.get(0).getAttributes().get("classpath");
        return cp == null ? DEFAULT_CLASSPATH : cp.toArray(new String[cp.size()]);
    }

    private FragmentClasspath[] buildFragmentClasspaths(ModuleClassLoader hostloader, ClasspathManager manager) {
        if (hostloader == null) {
            return emptyFragments;
        }
        List<ModuleWire> fragmentWires = hostloader.getBundleLoader().getWiring().getProvidedModuleWires("osgi.wiring.host");
        if (fragmentWires == null || fragmentWires.isEmpty()) {
            return emptyFragments;
        }
        ArrayList<FragmentClasspath> result = new ArrayList<FragmentClasspath>(fragmentWires.size());
        for (ModuleWire fragmentWire : fragmentWires) {
            ModuleRevision revision = fragmentWire.getRequirer();
            BundleInfo.Generation fragGeneration = (BundleInfo.Generation)revision.getRevisionInfo();
            String[] cp = ClasspathManager.getClassPath(revision);
            ClasspathEntry[] fragEntries = this.buildClasspath(cp, manager, fragGeneration);
            FragmentClasspath fragClasspath = new FragmentClasspath(fragGeneration, fragEntries);
            ClasspathManager.insertFragment(fragClasspath, result);
        }
        return result.toArray(new FragmentClasspath[result.size()]);
    }

    private static void insertFragment(FragmentClasspath fragClasspath, List<FragmentClasspath> existing) {
        long fragID = fragClasspath.getGeneration().getRevision().getRevisions().getModule().getId();
        ListIterator<FragmentClasspath> iExisting = existing.listIterator();
        while (iExisting.hasNext()) {
            long otherID = iExisting.next().getGeneration().getRevision().getRevisions().getModule().getId();
            if (fragID >= otherID) continue;
            iExisting.previous();
            iExisting.add(fragClasspath);
            return;
        }
        existing.add(fragClasspath);
    }

    public void close() {
        FragmentClasspath[] currentFragments;
        ClasspathEntry[] classpathEntryArray = this.entries;
        int n = this.entries.length;
        int n2 = 0;
        while (n2 < n) {
            ClasspathEntry entry = classpathEntryArray[n2];
            if (entry != null) {
                try {
                    entry.close();
                }
                catch (IOException e) {
                    this.generation.getBundleInfo().getStorage().getAdaptor().publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.ERROR, this.generation.getRevision().getRevisions().getModule(), e, new FrameworkListener[0]);
                }
            }
            ++n2;
        }
        FragmentClasspath[] fragmentClasspathArray = currentFragments = this.getFragmentClasspaths();
        int n3 = currentFragments.length;
        n = 0;
        while (n < n3) {
            FragmentClasspath currentFragment = fragmentClasspathArray[n];
            currentFragment.close();
            ++n;
        }
    }

    private ClasspathEntry[] buildClasspath(String[] cp, ClasspathManager hostloader, BundleInfo.Generation source) {
        ArrayList<ClasspathEntry> result = new ArrayList<ClasspathEntry>(cp.length);
        String[] stringArray = cp;
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            String cpEntry = stringArray[n2];
            this.findClassPathEntry(result, cpEntry, hostloader, source);
            ++n2;
        }
        return result.toArray(new ClasspathEntry[result.size()]);
    }

    private void findClassPathEntry(ArrayList<ClasspathEntry> result, String cp, ClasspathManager hostloader, BundleInfo.Generation sourceGeneration) {
        List<ClassLoaderHook> loaderHooks = this.hookRegistry.getClassLoaderHooks();
        boolean hookAdded = false;
        for (ClassLoaderHook hook : loaderHooks) {
            hookAdded |= hook.addClassPathEntry(result, cp, hostloader, sourceGeneration);
        }
        if (!this.addClassPathEntry(result, cp, hostloader, sourceGeneration) && !hookAdded) {
            BundleException be = new BundleException(NLS.bind(Msg.BUNDLE_CLASSPATH_ENTRY_NOT_FOUND_EXCEPTION, cp, sourceGeneration.getRevision().toString()), 3);
            sourceGeneration.getBundleInfo().getStorage().getAdaptor().publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.INFO, sourceGeneration.getRevision().getRevisions().getModule(), be, new FrameworkListener[0]);
        }
    }

    public boolean addClassPathEntry(ArrayList<ClasspathEntry> result, String cp, ClasspathManager hostManager, BundleInfo.Generation source) {
        return ClasspathManager.addStandardClassPathEntry(result, cp, hostManager, source) || this.addEclipseClassPathEntry(result, cp, hostManager, source);
    }

    public static boolean addStandardClassPathEntry(ArrayList<ClasspathEntry> result, String cp, ClasspathManager hostManager, BundleInfo.Generation generation) {
        if (cp.equals(".")) {
            result.add(hostManager.createClassPathEntry(generation.getBundleFile(), generation));
            return true;
        }
        ClasspathEntry element = hostManager.getClasspath(cp, generation);
        if (element != null) {
            result.add(element);
            return true;
        }
        if (hostManager.generation == generation) {
            FragmentClasspath[] hostFrags;
            FragmentClasspath[] fragmentClasspathArray = hostFrags = hostManager.getFragmentClasspaths();
            int n = hostFrags.length;
            int n2 = 0;
            while (n2 < n) {
                FragmentClasspath fragCP = fragmentClasspathArray[n2];
                element = hostManager.getClasspath(cp, fragCP.getGeneration());
                if (element != null) {
                    result.add(element);
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean addEclipseClassPathEntry(ArrayList<ClasspathEntry> result, String cp, ClasspathManager hostManager, BundleInfo.Generation source) {
        String var = ClasspathManager.hasPrefix(cp);
        if (var != null) {
            return this.addInternalClassPath(var, result, cp, hostManager, source);
        }
        if (cp.startsWith("external:")) {
            cp = cp.substring("external:".length());
            ClasspathEntry cpEntry = hostManager.getExternalClassPath(source.getBundleInfo().getStorage().getConfiguration().substituteVars(cp), source);
            if (cpEntry != null) {
                result.add(cpEntry);
                return true;
            }
        }
        return false;
    }

    private boolean addInternalClassPath(String var, ArrayList<ClasspathEntry> cpEntries, String cp, ClasspathManager hostManager, BundleInfo.Generation source) {
        EquinoxConfiguration configuration = source.getBundleInfo().getStorage().getConfiguration();
        if (var.equals("ws")) {
            return ClasspathManager.addStandardClassPathEntry(cpEntries, "ws/" + configuration.getWS() + cp.substring(4), hostManager, source);
        }
        if (var.equals("os")) {
            return ClasspathManager.addStandardClassPathEntry(cpEntries, "os/" + configuration.getOS() + cp.substring(4), hostManager, source);
        }
        if (var.equals("nl")) {
            cp = cp.substring(4);
            List<String> NL_JAR_VARIANTS = source.getBundleInfo().getStorage().getConfiguration().ECLIPSE_NL_JAR_VARIANTS;
            for (String nlVariant : NL_JAR_VARIANTS) {
                if (!ClasspathManager.addStandardClassPathEntry(cpEntries, "nl/" + nlVariant + cp, hostManager, source)) continue;
                return true;
            }
        }
        return false;
    }

    private static String hasPrefix(String libPath) {
        if (libPath.startsWith("$ws$")) {
            return "ws";
        }
        if (libPath.startsWith("$os$")) {
            return "os";
        }
        if (libPath.startsWith("$nl$")) {
            return "nl";
        }
        return null;
    }

    public ClasspathEntry getClasspath(String cp, BundleInfo.Generation cpGeneration) {
        BundleFile bundlefile = null;
        BundleEntry cpEntry = cpGeneration.getBundleFile().getEntry(cp);
        if (cpEntry != null && cpEntry.getName().endsWith("/")) {
            bundlefile = ClasspathManager.createBundleFile(cp, cpGeneration);
        } else {
            File file = cpGeneration.getBundleFile().getFile(cp, false);
            if (file != null) {
                bundlefile = ClasspathManager.createBundleFile(file, cpGeneration);
            }
        }
        if (bundlefile != null) {
            return this.createClassPathEntry(bundlefile, cpGeneration);
        }
        return null;
    }

    public ClasspathEntry getExternalClassPath(String cp, BundleInfo.Generation cpGeneration) {
        File file = new File(cp);
        if (!file.isAbsolute()) {
            return null;
        }
        BundleFile bundlefile = ClasspathManager.createBundleFile(file, cpGeneration);
        if (bundlefile != null) {
            return this.createClassPathEntry(bundlefile, cpGeneration);
        }
        return null;
    }

    public synchronized void loadFragments(Collection<ModuleRevision> addedFragments) {
        ArrayList<FragmentClasspath> result = new ArrayList<FragmentClasspath>(Arrays.asList(this.fragments));
        for (ModuleRevision addedFragment : addedFragments) {
            BundleInfo.Generation fragGeneration = (BundleInfo.Generation)addedFragment.getRevisionInfo();
            String[] cp = ClasspathManager.getClassPath(addedFragment);
            ClasspathEntry[] fragEntries = this.buildClasspath(cp, this, fragGeneration);
            FragmentClasspath fragClasspath = new FragmentClasspath(fragGeneration, fragEntries);
            ClasspathManager.insertFragment(fragClasspath, result);
        }
        this.fragments = result.toArray(new FragmentClasspath[result.size()]);
    }

    private static BundleFile createBundleFile(File content, BundleInfo.Generation generation) {
        if (!content.exists()) {
            return null;
        }
        return generation.getBundleInfo().getStorage().createBundleFile(content, generation, content.isDirectory(), false);
    }

    private static BundleFile createBundleFile(String nestedDir, BundleInfo.Generation generation) {
        return generation.getBundleInfo().getStorage().createNestedBundleFile(nestedDir, generation.getBundleFile(), generation);
    }

    private ClasspathEntry createClassPathEntry(BundleFile bundlefile, BundleInfo.Generation source) {
        ClasspathEntry entry = this.classloader != null ? this.classloader.createClassPathEntry(bundlefile, source) : new ClasspathEntry(bundlefile, source.getDomain(), source);
        return entry;
    }

    /*
     * Unable to fully structure code
     */
    public URL findLocalResource(String resource) {
        hooks = this.hookRegistry.getClassLoaderHooks();
        hookFailed = false;
        for (ClassLoaderHook hook : hooks) {
            try {
                hook.preFindLocalResource(resource, this);
            }
            catch (NoSuchElementException v0) {
                hookFailed = true;
            }
        }
        result = null;
        try {
            if (!hookFailed) {
                result = this.findLocalResourceImpl(resource, -1);
            }
        }
        finally {
            var7_8 = hooks.iterator();
            if (true) ** GOTO lbl28
        }
        {
        }
        do {
            hook = var7_8.next();
            try {
                hook.postFindLocalResource(resource, result, this);
            }
            catch (NoSuchElementException v1) {
                result = null;
            }
lbl28:
            // 3 sources

        } while (var7_8.hasNext());
        return result;
    }

    private URL findLocalResourceImpl(String resource, int classPathIndex) {
        Module m = this.generation.getRevision().getRevisions().getModule();
        URL result = null;
        int[] curIndex = new int[1];
        for (ClassLoaderHook hook : this.hookRegistry.getClassLoaderHooks()) {
            ClasspathEntry[] hookEntries = hook.getClassPathEntries(resource, this);
            if (hookEntries == null) continue;
            return this.findLocalResourceImpl(resource, hookEntries, m, classPathIndex, curIndex);
        }
        curIndex[0] = 0;
        result = this.findLocalResourceImpl(resource, this.entries, m, classPathIndex, curIndex);
        if (result != null) {
            return result;
        }
        FragmentClasspath[] fragmentClasspathArray = this.getFragmentClasspaths();
        int n = fragmentClasspathArray.length;
        int n2 = 0;
        while (n2 < n) {
            FragmentClasspath fragCP = fragmentClasspathArray[n2];
            result = this.findLocalResourceImpl(resource, fragCP.getEntries(), m, classPathIndex, curIndex);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    private URL findLocalResourceImpl(String resource, ClasspathEntry[] cpEntries, Module m, int classPathIndex, int[] curIndex) {
        ClasspathEntry[] classpathEntryArray = cpEntries;
        int n = cpEntries.length;
        int n2 = 0;
        while (n2 < n) {
            URL result;
            ClasspathEntry cpEntry = classpathEntryArray[n2];
            if (cpEntry != null && (result = cpEntry.findResource(resource, m, curIndex[0])) != null && (classPathIndex == -1 || classPathIndex == curIndex[0])) {
                return result;
            }
            curIndex[0] = curIndex[0] + 1;
            ++n2;
        }
        return null;
    }

    public Enumeration<URL> findLocalResources(String resource) {
        Module m = this.generation.getRevision().getRevisions().getModule();
        ArrayList<URL> resources = new ArrayList<URL>(6);
        int[] classPathIndex = new int[1];
        for (ClassLoaderHook hook : this.hookRegistry.getClassLoaderHooks()) {
            ClasspathEntry[] hookEntries = hook.getClassPathEntries(resource, this);
            if (hookEntries == null) continue;
            this.findLocalResources(resource, hookEntries, m, classPathIndex, resources);
            return resources.size() > 0 ? Collections.enumeration(resources) : Collections.emptyEnumeration();
        }
        classPathIndex[0] = 0;
        this.findLocalResources(resource, this.entries, m, classPathIndex, resources);
        FragmentClasspath[] fragmentClasspathArray = this.getFragmentClasspaths();
        int n = fragmentClasspathArray.length;
        int n2 = 0;
        while (n2 < n) {
            FragmentClasspath fragCP = fragmentClasspathArray[n2];
            this.findLocalResources(resource, fragCP.getEntries(), m, classPathIndex, resources);
            ++n2;
        }
        if (resources.size() > 0) {
            return Collections.enumeration(resources);
        }
        return Collections.emptyEnumeration();
    }

    private void findLocalResources(String resource, ClasspathEntry[] cpEntries, Module m, int[] classPathIndex, List<URL> resources) {
        ClasspathEntry[] classpathEntryArray = cpEntries;
        int n = cpEntries.length;
        int n2 = 0;
        while (n2 < n) {
            URL url;
            ClasspathEntry cpEntry = classpathEntryArray[n2];
            if (cpEntry != null && (url = cpEntry.findResource(resource, m, classPathIndex[0])) != null) {
                resources.add(url);
            }
            classPathIndex[0] = classPathIndex[0] + 1;
            ++n2;
        }
    }

    public BundleEntry findLocalEntry(String path) {
        return this.findLocalEntry(path, -1);
    }

    public BundleEntry findLocalEntry(String path, int classPathIndex) {
        BundleEntry result = null;
        int[] curIndex = new int[1];
        for (ClassLoaderHook hook : this.hookRegistry.getClassLoaderHooks()) {
            ClasspathEntry[] hookEntries = hook.getClassPathEntries(path, this);
            if (hookEntries == null) continue;
            return this.findLocalEntry(path, hookEntries, classPathIndex, curIndex);
        }
        curIndex[0] = 0;
        result = this.findLocalEntry(path, this.entries, classPathIndex, curIndex);
        if (result != null) {
            return result;
        }
        FragmentClasspath[] fragmentClasspathArray = this.getFragmentClasspaths();
        int n = fragmentClasspathArray.length;
        int n2 = 0;
        while (n2 < n) {
            FragmentClasspath fragCP = fragmentClasspathArray[n2];
            result = this.findLocalEntry(path, fragCP.getEntries(), classPathIndex, curIndex);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    private BundleEntry findLocalEntry(String path, ClasspathEntry[] cpEntries, int classPathIndex, int[] curIndex) {
        ClasspathEntry[] classpathEntryArray = cpEntries;
        int n = cpEntries.length;
        int n2 = 0;
        while (n2 < n) {
            BundleEntry result;
            ClasspathEntry cpEntry = classpathEntryArray[n2];
            if (cpEntry != null && (classPathIndex == -1 || classPathIndex == curIndex[0]) && (result = cpEntry.findEntry(path)) != null) {
                return result;
            }
            curIndex[0] = curIndex[0] + 1;
            ++n2;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class<?> findLocalClass(String classname) throws ClassNotFoundException {
        result = null;
        hooks = this.hookRegistry.getClassLoaderHooks();
        try {
            for (ClassLoaderHook hook : hooks) {
                hook.preFindLocalClass(classname, this);
            }
            result = this.classloader.publicFindLoaded(classname);
            if (result != null) {
                var7_6 = result;
                return var7_6;
            }
            var7_7 = result = this.findLocalClassImpl(classname, hooks);
            return var7_7;
        }
        finally {
            ** for (hook : hooks)
        }
lbl-1000:
        // 1 sources

        {
            hook.postFindLocalClass(classname, result, this);
            continue;
        }
lbl17:
        // 1 sources

        return var7_6;
    }

    private Class<?> findLocalClassImpl(String classname, List<ClassLoaderHook> hooks) {
        for (ClassLoaderHook hook : this.hookRegistry.getClassLoaderHooks()) {
            ClasspathEntry[] hookEntries = hook.getClassPathEntries(classname, this);
            if (hookEntries == null) continue;
            return this.findLocalClassImpl(classname, hookEntries, hooks);
        }
        Class<?> result = this.findLocalClassImpl(classname, this.entries, hooks);
        if (result != null) {
            return result;
        }
        FragmentClasspath[] fragmentClasspathArray = this.getFragmentClasspaths();
        int n = fragmentClasspathArray.length;
        int n2 = 0;
        while (n2 < n) {
            FragmentClasspath fragCP = fragmentClasspathArray[n2];
            result = this.findLocalClassImpl(classname, fragCP.getEntries(), hooks);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    private Class<?> findLocalClassImpl(String classname, ClasspathEntry[] cpEntries, List<ClassLoaderHook> hooks) {
        ClasspathEntry[] classpathEntryArray = cpEntries;
        int n = cpEntries.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> result;
            ClasspathEntry cpEntry = classpathEntryArray[n2];
            if (cpEntry != null && (result = this.findClassImpl(classname, cpEntry, hooks)) != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    private Class<?> findClassImpl(String name2, ClasspathEntry classpathEntry, List<ClassLoaderHook> hooks) {
        byte[] classbytes;
        String filename;
        BundleEntry entry;
        if (this.debug.DEBUG_LOADER) {
            Debug.println("ModuleClassLoader[" + this.classloader.getBundleLoader() + " - " + classpathEntry.getBundleFile() + "].findClassImpl(" + name2 + ")");
        }
        if ((entry = classpathEntry.findEntry(filename = name2.replace('.', '/').concat(".class"))) == null) {
            return null;
        }
        try {
            classbytes = entry.getBytes();
        }
        catch (IOException e) {
            if (this.debug.DEBUG_LOADER) {
                Debug.println("  IOException reading " + filename + " from " + classpathEntry.getBundleFile());
            }
            throw (LinkageError)new LinkageError("Error reading class bytes: " + name2).initCause(e);
        }
        if (this.debug.DEBUG_LOADER) {
            Debug.println("  read " + classbytes.length + " bytes from " + classpathEntry.getBundleFile() + "!/" + filename);
            Debug.println("  defining class " + name2);
        }
        try {
            return this.defineClass(name2, classbytes, classpathEntry, entry, hooks);
        }
        catch (Error e) {
            if (this.debug.DEBUG_LOADER) {
                Debug.println("  error defining class " + name2);
            }
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    private Class<?> defineClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, List<ClassLoaderHook> hooks) {
        block23: {
            block24: {
                block21: {
                    block22: {
                        block18: {
                            block19: {
                                result = null;
                                recursionDetected = false;
                                this.definePackage(name, classpathEntry);
                                context = this.currentDefineContext.get();
                                if (context == null) {
                                    context = new DefineContext();
                                    this.currentDefineContext.set(context);
                                }
                                if (this.hookRegistry.getContainer().isProcessClassRecursionSupportedByAll()) ** GOTO lbl33
                                if (!context.currentlyProcessing.contains(name)) break block18;
                                recursionDetected = true;
                                if (recursionDetected) break block19;
                                defined = result != null && result.defined != false ? result.clazz : null;
                                for (ClassLoaderHook hook : hooks) {
                                    hook.recordClassDefine(name, defined, classbytes, classpathEntry, entry, this);
                                }
                            }
                            return null;
                        }
                        context.currentlyProcessing.add(name);
                        try {
                            for (ClassLoaderHook hook : hooks) {
                                if (hook.isProcessClassRecursionSupported()) continue;
                                classbytes = this.processClass(hook, name, classbytes, classpathEntry, entry, this, hooks);
                            }
                        }
                        finally {
                            context.currentlyProcessing.remove(name);
                        }
                        for (ClassLoaderHook hook : hooks) {
                            if (!hook.isProcessClassRecursionSupported()) continue;
                            classbytes = this.processClass(hook, name, classbytes, classpathEntry, entry, this, hooks);
                        }
                        if (!context.currentlyDefining.contains(name)) break block21;
                        if (recursionDetected) break block22;
                        defined = result != null && result.defined != false ? result.clazz : null;
                        for (ClassLoaderHook hook : hooks) {
                            hook.recordClassDefine(name, defined, classbytes, classpathEntry, entry, this);
                        }
                    }
                    return null;
                }
                try {
                    context.currentlyDefining.add(name);
                    try {
                        result = this.classloader.defineClass(name, classbytes, classpathEntry);
                        break block23;
                    }
                    finally {
                        context.currentlyDefining.remove(name);
                    }
                }
                catch (Throwable var12_25) {
                    if (recursionDetected) break block24;
                    defined = result != null && result.defined != false ? result.clazz : null;
                    ** for (hook : hooks)
                }
lbl-1000:
                // 1 sources

                {
                    hook.recordClassDefine(name, defined, classbytes, classpathEntry, entry, this);
                    continue;
                }
            }
            throw var12_25;
        }
        if (!recursionDetected) {
            defined = result != null && result.defined != false ? result.clazz : null;
            for (ClassLoaderHook hook : hooks) {
                hook.recordClassDefine(name, defined, classbytes, classpathEntry, entry, this);
            }
        }
        return result == null ? null : result.clazz;
    }

    private byte[] processClass(ClassLoaderHook hook, String name2, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager classpathManager, List<ClassLoaderHook> hooks) {
        byte[] modifiedBytes = hook.processClass(name2, classbytes, classpathEntry, entry, this);
        if (modifiedBytes != null) {
            if (!(hook instanceof WeavingHookConfigurator)) {
                for (ClassLoaderHook rejectHook : hooks) {
                    if (!rejectHook.rejectTransformation(name2, modifiedBytes, classpathEntry, entry, this)) continue;
                    modifiedBytes = null;
                    break;
                }
            }
            if (modifiedBytes != null) {
                classbytes = modifiedBytes;
            }
        }
        return classbytes;
    }

    private void definePackage(String name2, ClasspathEntry classpathEntry) {
        int lastIndex = name2.lastIndexOf(46);
        if (lastIndex < 0) {
            return;
        }
        String packageName = name2.substring(0, lastIndex);
        Package pkg = this.classloader.publicGetPackage(packageName);
        if (pkg != null) {
            return;
        }
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        if (this.generation.getBundleInfo().getStorage().getConfiguration().DEFINE_PACKAGE_ATTRIBUTES) {
            ManifestPackageAttributes manifestPackageAttributes = classpathEntry.manifestPackageAttributesFor(packageName);
            TitleVersionVendor specification = manifestPackageAttributes.getSpecification();
            TitleVersionVendor implementation = manifestPackageAttributes.getImplementation();
            specTitle = specification.getTitle();
            specVersion = specification.getVersion();
            specVendor = specification.getVendor();
            implTitle = implementation.getTitle();
            implVersion = implementation.getVersion();
            implVendor = implementation.getVendor();
        }
        this.classloader.publicDefinePackage(packageName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, null);
    }

    public FragmentClasspath[] getFragmentClasspaths() {
        return this.fragments;
    }

    public ClasspathEntry[] getHostClasspathEntries() {
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findLibrary(String libname) {
        Object object = this;
        synchronized (object) {
            if (this.loadedLibraries == null) {
                this.loadedLibraries = new ArrayMap(1);
            }
        }
        object = this.loadedLibraries;
        synchronized (object) {
            String libpath = this.loadedLibraries.get(libname);
            if (libpath != null) {
                return libpath;
            }
            libpath = this.findLibrary0(libname);
            if (libpath != null) {
                this.loadedLibraries.put(libname, libpath);
            }
            return libpath;
        }
    }

    private String findLibrary0(String libname) {
        FragmentClasspath[] currentFragments;
        List<ClassLoaderHook> hooks = this.hookRegistry.getClassLoaderHooks();
        String result = null;
        for (ClassLoaderHook hook : hooks) {
            try {
                result = hook.preFindLibrary(libname, this.classloader);
                if (result == null) continue;
                return result;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        result = this.generation.findLibrary(libname);
        if (result != null) {
            return result;
        }
        FragmentClasspath[] fragmentClasspathArray = currentFragments = this.getFragmentClasspaths();
        int n = currentFragments.length;
        int n2 = 0;
        while (n2 < n) {
            FragmentClasspath fragment = fragmentClasspathArray[n2];
            result = fragment.getGeneration().findLibrary(libname);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        for (ClassLoaderHook hook : hooks) {
            result = hook.postFindLibrary(libname, this.classloader);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    public List<URL> findEntries(String path, String filePattern, int options) {
        FragmentClasspath[] currentFragments;
        ArrayList<BundleInfo.Generation> generations = new ArrayList<BundleInfo.Generation>();
        generations.add(this.generation);
        FragmentClasspath[] fragmentClasspathArray = currentFragments = this.getFragmentClasspaths();
        int n = currentFragments.length;
        int n2 = 0;
        while (n2 < n) {
            FragmentClasspath fragmentClasspath = fragmentClasspathArray[n2];
            generations.add(fragmentClasspath.getGeneration());
            ++n2;
        }
        Enumeration<URL> eURLs = Storage.findEntries(generations, path, filePattern, options);
        if (eURLs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Collections.list(eURLs));
    }

    public Collection<String> listLocalResources(String path, String filePattern, int options) {
        ArrayList<BundleFile> bundleFiles = new ArrayList<BundleFile>();
        for (ClassLoaderHook hook : this.hookRegistry.getClassLoaderHooks()) {
            ClasspathEntry[] hookEntries = hook.getClassPathEntries(path, this);
            if (hookEntries == null) continue;
            ClasspathEntry[] classpathEntryArray = hookEntries;
            int n = hookEntries.length;
            int n2 = 0;
            while (n2 < n) {
                ClasspathEntry cpEntry = classpathEntryArray[n2];
                cpEntry.addBundleFiles(bundleFiles);
                ++n2;
            }
            return Storage.listEntryPaths(bundleFiles, path, filePattern, options);
        }
        ClasspathEntry[] cpEntries = this.getHostClasspathEntries();
        Object[] objectArray = cpEntries;
        int n = cpEntries.length;
        int n3 = 0;
        while (n3 < n) {
            ClasspathEntry cpEntry = objectArray[n3];
            cpEntry.addBundleFiles(bundleFiles);
            ++n3;
        }
        objectArray = this.getFragmentClasspaths();
        n = objectArray.length;
        n3 = 0;
        while (n3 < n) {
            Object fragmentClasspath = objectArray[n3];
            ClasspathEntry[] classpathEntryArray = ((FragmentClasspath)fragmentClasspath).getEntries();
            int n4 = classpathEntryArray.length;
            int n5 = 0;
            while (n5 < n4) {
                ClasspathEntry cpEntry = classpathEntryArray[n5];
                cpEntry.addBundleFiles(bundleFiles);
                ++n5;
            }
            ++n3;
        }
        return Storage.listEntryPaths(bundleFiles, path, filePattern, options);
    }

    public BundleInfo.Generation getGeneration() {
        return this.generation;
    }

    public ModuleClassLoader getClassLoader() {
        return this.classloader;
    }

    static class DefineContext {
        Collection<String> currentlyProcessing = new ArrayList<String>(5);
        Collection<String> currentlyDefining = new ArrayList<String>(5);

        DefineContext() {
        }
    }
}

