/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.osgi.internal.loader.buddy;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import paper.libs.org.eclipse.osgi.container.ModuleWire;
import paper.libs.org.eclipse.osgi.container.ModuleWiring;
import paper.libs.org.eclipse.osgi.internal.loader.BundleLoader;
import paper.libs.org.eclipse.osgi.internal.loader.buddy.IBuddyPolicy;

public class DependentPolicy
implements IBuddyPolicy {
    BundleLoader buddyRequester;
    int lastDependentOfAdded = -1;
    List<ModuleWiring> allDependents = null;

    public DependentPolicy(BundleLoader requester) {
        this.buddyRequester = requester;
        this.allDependents = new ArrayList<ModuleWiring>();
        this.basicAddImmediateDependents(requester.getWiring());
        if (this.allDependents.size() == 0) {
            this.allDependents = null;
        }
    }

    @Override
    public Class<?> loadClass(String name2) {
        if (this.allDependents == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < this.allDependents.size()) {
            ModuleWiring searchWiring = this.allDependents.get(i2);
            BundleLoader searchLoader = (BundleLoader)searchWiring.getModuleLoader();
            if (searchLoader != null) {
                Class<?> result = searchLoader.findClassNoParentNoException(name2);
                if (result != null) {
                    return result;
                }
                this.addDependent(i2, searchWiring);
            }
            ++i2;
        }
        return null;
    }

    private synchronized void addDependent(int i2, ModuleWiring searchedWiring) {
        if (i2 > this.lastDependentOfAdded) {
            this.lastDependentOfAdded = i2;
            this.basicAddImmediateDependents(searchedWiring);
        }
    }

    @Override
    public URL loadResource(String name2) {
        if (this.allDependents == null) {
            return null;
        }
        URL result = null;
        int i2 = 0;
        while (i2 < this.allDependents.size() && result == null) {
            ModuleWiring searchWiring = this.allDependents.get(i2);
            BundleLoader searchLoader = (BundleLoader)searchWiring.getModuleLoader();
            if (searchLoader != null && (result = searchLoader.findResource(name2)) == null) {
                this.addDependent(i2, searchWiring);
            }
            ++i2;
        }
        return result;
    }

    @Override
    public Enumeration<URL> loadResources(String name2) {
        if (this.allDependents == null) {
            return null;
        }
        Enumeration<URL> results = null;
        int i2 = 0;
        while (i2 < this.allDependents.size()) {
            ModuleWiring searchWiring = this.allDependents.get(i2);
            BundleLoader searchLoader = (BundleLoader)searchWiring.getModuleLoader();
            if (searchLoader != null) {
                try {
                    results = BundleLoader.compoundEnumerations(results, searchLoader.findResources(name2));
                    this.addDependent(i2, searchWiring);
                }
                catch (IOException iOException) {}
            }
            ++i2;
        }
        return results;
    }

    private void basicAddImmediateDependents(ModuleWiring wiring) {
        List<ModuleWire> providedWires = wiring.getProvidedModuleWires(null);
        if (providedWires != null) {
            for (ModuleWire wire : providedWires) {
                ModuleWiring dependent;
                String namespace = wire.getRequirement().getNamespace();
                if (!"osgi.wiring.package".equals(namespace) && !"osgi.wiring.bundle".equals(namespace) || this.allDependents.contains(dependent = wire.getRequirerWiring())) continue;
                this.allDependents.add(dependent);
            }
        }
    }
}

