/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.osgi.internal.hookregistry;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import paper.libs.org.eclipse.osgi.framework.log.FrameworkLogEntry;
import paper.libs.org.eclipse.osgi.internal.cds.CDSHookConfigurator;
import paper.libs.org.eclipse.osgi.internal.connect.ConnectHookConfigurator;
import paper.libs.org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import paper.libs.org.eclipse.osgi.internal.framework.EquinoxContainer;
import paper.libs.org.eclipse.osgi.internal.hookregistry.ActivatorHookFactory;
import paper.libs.org.eclipse.osgi.internal.hookregistry.BundleFileWrapperFactoryHook;
import paper.libs.org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import paper.libs.org.eclipse.osgi.internal.hookregistry.HookConfigurator;
import paper.libs.org.eclipse.osgi.internal.hookregistry.StorageHookFactory;
import paper.libs.org.eclipse.osgi.internal.hooks.DevClassLoadingHook;
import paper.libs.org.eclipse.osgi.internal.hooks.EclipseLazyStarter;
import paper.libs.org.eclipse.osgi.internal.signedcontent.SignedBundleHook;
import paper.libs.org.eclipse.osgi.internal.weaving.WeavingHookConfigurator;
import paper.libs.org.eclipse.osgi.util.ManifestElement;

public final class HookRegistry {
    public static final String HOOK_CONFIGURATORS_FILE = "hookconfigurators.properties";
    public static final String HOOK_CONFIGURATORS = "hook.configurators";
    public static final String PROP_HOOK_CONFIGURATORS_INCLUDE = "osgi.hook.configurators.include";
    public static final String PROP_HOOK_CONFIGURATORS_EXCLUDE = "osgi.hook.configurators.exclude";
    public static final String PROP_HOOK_CONFIGURATORS = "osgi.hook.configurators";
    private static final String BUILTIN_HOOKS = "builtin.hooks";
    private final EquinoxContainer container;
    private volatile boolean initialized = false;
    private final List<ClassLoaderHook> classLoaderHooks = new ArrayList<ClassLoaderHook>();
    private final List<ClassLoaderHook> classLoaderHooksRO = Collections.unmodifiableList(this.classLoaderHooks);
    private final List<StorageHookFactory<?, ?, ?>> storageHookFactories = new ArrayList();
    private final List<StorageHookFactory<?, ?, ?>> storageHookFactoriesRO = Collections.unmodifiableList(this.storageHookFactories);
    private final List<BundleFileWrapperFactoryHook> bundleFileWrapperFactoryHooks = new ArrayList<BundleFileWrapperFactoryHook>();
    private final List<BundleFileWrapperFactoryHook> bundleFileWrapperFactoryHooksRO = Collections.unmodifiableList(this.bundleFileWrapperFactoryHooks);
    private final List<ActivatorHookFactory> activatorHookFactories = new ArrayList<ActivatorHookFactory>();
    private final List<ActivatorHookFactory> activatorHookFactoriesRO = Collections.unmodifiableList(this.activatorHookFactories);

    public HookRegistry(EquinoxContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        ArrayList<String> configurators = new ArrayList<String>(5);
        ArrayList<FrameworkLogEntry> errors = new ArrayList<FrameworkLogEntry>(0);
        this.mergeFileHookConfigurators(configurators, errors);
        this.mergePropertyHookConfigurators(configurators);
        configurators.add(0, ConnectHookConfigurator.class.getName());
        HookRegistry hookRegistry = this;
        synchronized (hookRegistry) {
            this.addClassLoaderHook(new DevClassLoadingHook(this.container.getConfiguration()));
            this.addClassLoaderHook(new EclipseLazyStarter(this.container));
            this.addClassLoaderHook(new WeavingHookConfigurator(this.container));
            configurators.add(SignedBundleHook.class.getName());
            configurators.add(CDSHookConfigurator.class.getName());
            this.loadConfigurators(configurators, errors);
            this.initialized = true;
        }
        for (FrameworkLogEntry error : errors) {
            this.container.getLogServices().getFrameworkLog().log(error);
        }
    }

    private void mergeFileHookConfigurators(List<String> configuratorList, List<FrameworkLogEntry> errors) {
        Enumeration<URL> hookConfigurators;
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            hookConfigurators = cl != null ? cl.getResources(HOOK_CONFIGURATORS_FILE) : ClassLoader.getSystemResources(HOOK_CONFIGURATORS_FILE);
        }
        catch (IOException e) {
            errors.add(new FrameworkLogEntry("paper.libs.org.eclipse.osgi", 4, 0, "getResources error on hookconfigurators.properties", 0, e, null));
            return;
        }
        int curBuiltin = 0;
        while (hookConfigurators.hasMoreElements()) {
            String hooksValue;
            Properties configuratorProps;
            InputStream input;
            URL url;
            block21: {
                url = hookConfigurators.nextElement();
                input = null;
                configuratorProps = new Properties();
                input = url.openStream();
                configuratorProps.load(input);
                hooksValue = configuratorProps.getProperty(HOOK_CONFIGURATORS);
                if (hooksValue != null) break block21;
                if (input == null) continue;
                try {
                    input.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            try {
                try {
                    String[] configurators;
                    boolean builtin = Boolean.valueOf(configuratorProps.getProperty(BUILTIN_HOOKS));
                    String[] stringArray = configurators = ManifestElement.getArrayFromList(hooksValue, ",");
                    int n = configurators.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String configurator = stringArray[n2];
                        if (!configuratorList.contains(configurator)) {
                            if (builtin) {
                                configuratorList.add(curBuiltin++, configurator);
                            } else {
                                configuratorList.add(configurator);
                            }
                        }
                        ++n2;
                    }
                }
                catch (IOException e) {
                    errors.add(new FrameworkLogEntry("paper.libs.org.eclipse.osgi", 4, 0, "error loading: " + url.toExternalForm(), 0, e, null));
                    if (input == null) continue;
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (input == null) continue;
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void mergePropertyHookConfigurators(List<String> configuratorList) {
        String[] excludeHooks;
        String[] includeConfigurators;
        String[] configurators = ManifestElement.getArrayFromList(this.container.getConfiguration().getConfiguration(PROP_HOOK_CONFIGURATORS), ",");
        if (configurators.length > 0) {
            configuratorList.clear();
            String[] stringArray = configurators;
            int n = configurators.length;
            int n2 = 0;
            while (n2 < n) {
                String configurator = stringArray[n2];
                if (!configuratorList.contains(configurator)) {
                    configuratorList.add(configurator);
                }
                ++n2;
            }
            return;
        }
        String[] stringArray = includeConfigurators = ManifestElement.getArrayFromList(this.container.getConfiguration().getConfiguration(PROP_HOOK_CONFIGURATORS_INCLUDE), ",");
        int n = includeConfigurators.length;
        int n3 = 0;
        while (n3 < n) {
            String includeConfigurator = stringArray[n3];
            if (!configuratorList.contains(includeConfigurator)) {
                configuratorList.add(includeConfigurator);
            }
            ++n3;
        }
        String[] stringArray2 = excludeHooks = ManifestElement.getArrayFromList(this.container.getConfiguration().getConfiguration(PROP_HOOK_CONFIGURATORS_EXCLUDE), ",");
        int n4 = excludeHooks.length;
        n = 0;
        while (n < n4) {
            String excludeHook = stringArray2[n];
            configuratorList.remove(excludeHook);
            ++n;
        }
    }

    private void loadConfigurators(List<String> configurators, List<FrameworkLogEntry> errors) {
        for (String hookName : configurators) {
            try {
                Class<?> clazz = Class.forName(hookName);
                HookConfigurator configurator = (HookConfigurator)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                configurator.addHooks(this);
            }
            catch (Throwable t) {
                errors.add(new FrameworkLogEntry("paper.libs.org.eclipse.osgi", 4, 0, "error loading hook: " + hookName, 0, t, null));
            }
        }
    }

    public List<ClassLoaderHook> getClassLoaderHooks() {
        return this.classLoaderHooksRO;
    }

    public List<StorageHookFactory<?, ?, ?>> getStorageHookFactories() {
        return this.storageHookFactoriesRO;
    }

    public List<BundleFileWrapperFactoryHook> getBundleFileWrapperFactoryHooks() {
        return this.bundleFileWrapperFactoryHooksRO;
    }

    public List<ActivatorHookFactory> getActivatorHookFactories() {
        return this.activatorHookFactoriesRO;
    }

    private <H> void add(H hook, List<H> hooks) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot add hooks dynamically.");
        }
        hooks.add(hook);
    }

    public void addClassLoaderHook(ClassLoaderHook classLoaderHook) {
        this.add(classLoaderHook, this.classLoaderHooks);
    }

    public void addStorageHookFactory(StorageHookFactory<?, ?, ?> storageHookFactory) {
        this.add(storageHookFactory, this.storageHookFactories);
    }

    public void addBundleFileWrapperFactoryHook(BundleFileWrapperFactoryHook factory) {
        this.add(factory, this.bundleFileWrapperFactoryHooks);
    }

    public void addActivatorHookFactory(ActivatorHookFactory activatorHookFactory) {
        this.add(activatorHookFactory, this.activatorHookFactories);
    }

    public EquinoxConfiguration getConfiguration() {
        return this.container.getConfiguration();
    }

    public EquinoxContainer getContainer() {
        return this.container;
    }
}

