/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.osgi.internal.framework;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import paper.libs.org.apache.felix.resolver.Logger;
import paper.libs.org.apache.felix.resolver.ResolverImpl;
import paper.libs.org.eclipse.osgi.internal.debug.Debug;
import paper.libs.org.eclipse.osgi.internal.debug.FrameworkDebugOptions;
import paper.libs.org.eclipse.osgi.internal.framework.ContextFinder;
import paper.libs.org.eclipse.osgi.internal.framework.EquinoxBundle;
import paper.libs.org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import paper.libs.org.eclipse.osgi.internal.framework.EquinoxContainer;
import paper.libs.org.eclipse.osgi.internal.framework.XMLParsingServiceFactory;
import paper.libs.org.eclipse.osgi.internal.framework.legacy.PackageAdminImpl;
import paper.libs.org.eclipse.osgi.internal.framework.legacy.StartLevelImpl;
import paper.libs.org.eclipse.osgi.internal.location.EquinoxLocations;
import paper.libs.org.eclipse.osgi.internal.permadmin.EquinoxSecurityManager;
import paper.libs.org.eclipse.osgi.internal.permadmin.SecurityAdmin;
import paper.libs.org.eclipse.osgi.internal.url.EquinoxFactoryManager;
import paper.libs.org.eclipse.osgi.service.datalocation.Location;
import paper.libs.org.eclipse.osgi.service.debug.DebugOptions;
import paper.libs.org.eclipse.osgi.service.debug.DebugOptionsListener;
import paper.libs.org.eclipse.osgi.service.environment.EnvironmentInfo;
import paper.libs.org.eclipse.osgi.service.localization.BundleLocalization;
import paper.libs.org.eclipse.osgi.service.urlconversion.URLConverter;
import paper.libs.org.eclipse.osgi.storage.BundleLocalizationImpl;
import paper.libs.org.eclipse.osgi.storage.url.BundleURLConverter;
import paper.libs.org.osgi.framework.BundleActivator;
import paper.libs.org.osgi.framework.BundleContext;
import paper.libs.org.osgi.framework.BundleException;
import paper.libs.org.osgi.framework.ServiceRegistration;
import paper.libs.org.osgi.service.condition.Condition;
import paper.libs.org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import paper.libs.org.osgi.service.packageadmin.PackageAdmin;
import paper.libs.org.osgi.service.permissionadmin.PermissionAdmin;
import paper.libs.org.osgi.service.resolver.Resolver;
import paper.libs.org.osgi.service.startlevel.StartLevel;

public class SystemBundleActivator
implements BundleActivator {
    private EquinoxFactoryManager urlFactoryManager;
    private List<ServiceRegistration<?>> registrations = new ArrayList(10);
    private SecurityManager setSecurityManagner;

    @Override
    public void start(BundleContext bc) throws Exception {
        this.registrations.clear();
        EquinoxBundle bundle = (EquinoxBundle)bc.getBundle();
        EquinoxContainer equinoxContainer = bundle.getEquinoxContainer();
        equinoxContainer.systemStart(bc);
        EquinoxConfiguration configuration = bundle.getEquinoxContainer().getConfiguration();
        this.installSecurityManager(configuration);
        equinoxContainer.getLogServices().start(bc);
        this.urlFactoryManager = new EquinoxFactoryManager(equinoxContainer);
        this.urlFactoryManager.installHandlerFactories(bc);
        FrameworkDebugOptions dbgOptions = (FrameworkDebugOptions)configuration.getDebugOptions();
        dbgOptions.start(bc);
        Hashtable<String, Object> props = new Hashtable<String, Object>(7);
        props.clear();
        props.put("osgi.condition.id", "true");
        this.register(bc, Condition.class, (Object)Condition.INSTANCE, false, props);
        this.registerLocations(bc, equinoxContainer.getLocations());
        this.register(bc, EnvironmentInfo.class, equinoxContainer.getConfiguration(), null);
        PackageAdminImpl packageAdmin = new PackageAdminImpl(equinoxContainer, equinoxContainer.getStorage().getModuleContainer().getFrameworkWiring());
        this.register(bc, PackageAdmin.class, packageAdmin, null);
        StartLevelImpl startLevel = new StartLevelImpl(equinoxContainer.getStorage().getModuleContainer().getFrameworkStartLevel());
        this.register(bc, StartLevel.class, startLevel, null);
        SecurityAdmin sa = equinoxContainer.getStorage().getSecurityAdmin();
        this.register(bc, PermissionAdmin.class, sa, null);
        this.register(bc, ConditionalPermissionAdmin.class, sa, null);
        props.clear();
        props.put("service.ranking", Integer.MIN_VALUE);
        this.register(bc, Resolver.class, (Object)new ResolverImpl(new Logger(0), null), false, props);
        this.register(bc, DebugOptions.class, dbgOptions, null);
        ContextFinder tccl = equinoxContainer.getContextFinder();
        if (tccl != null) {
            props.clear();
            props.put("equinox.classloader.type", "contextClassLoader");
            this.register(bc, ClassLoader.class, tccl, props);
        }
        props.clear();
        props.put("protocol", new String[]{"bundleentry", "bundleresource"});
        this.register(bc, URLConverter.class, new BundleURLConverter(), props);
        this.register(bc, BundleLocalization.class, new BundleLocalizationImpl(), null);
        boolean setTccl = "true".equals(bundle.getEquinoxContainer().getConfiguration().getConfiguration("eclipse.parsers.setTCCL", "true"));
        try {
            this.register(bc, "javax.xml.parsers.SAXParserFactory", (Object)new XMLParsingServiceFactory(true, setTccl), false, null);
            this.register(bc, "javax.xml.parsers.DocumentBuilderFactory", (Object)new XMLParsingServiceFactory(false, setTccl), false, null);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        bundle.getEquinoxContainer().getStorage().getExtensionInstaller().startExtensionActivators(bc);
        props.clear();
        props.put("listener.symbolic.name", "paper.libs.org.eclipse.osgi");
        this.register(bc, DebugOptionsListener.class, bundle.getEquinoxContainer().getConfiguration().getDebug(), props);
        this.register(bc, DebugOptionsListener.class, bundle.getModule().getContainer(), props);
    }

    private void installSecurityManager(EquinoxConfiguration configuration) throws BundleException {
        SecurityManager toInstall;
        block23: {
            String javaSecurityProp;
            block22: {
                String frameworkSecurityProp = configuration.getConfiguration("paper.libs.org.osgi.framework.security");
                if (System.getSecurityManager() != null) {
                    if ("osgi".equals(frameworkSecurityProp)) {
                        throw new BundleException("Cannot specify the \"org.osgi.framework.security\" configuration property when a security manager is already installed.");
                    }
                    return;
                }
                javaSecurityProp = configuration.getConfiguration("eclipse.security", configuration.getProperty("java.security.manager"));
                toInstall = null;
                if (!"osgi".equals(frameworkSecurityProp)) break block22;
                toInstall = new EquinoxSecurityManager();
                break block23;
            }
            if (javaSecurityProp == null) break block23;
            switch (javaSecurityProp) {
                case "": 
                case "default": {
                    toInstall = new SecurityManager();
                    break;
                }
                default: {
                    try {
                        Class<?> clazz = Class.forName(javaSecurityProp);
                        toInstall = (SecurityManager)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                        break;
                    }
                    catch (Throwable t) {
                        throw new BundleException("Failed to create security manager", t);
                    }
                }
                case "allow": 
                case "disallow": 
            }
        }
        if (configuration.getDebug().DEBUG_SECURITY) {
            Debug.println("Setting SecurityManager to: " + toInstall);
        }
        try {
            if (toInstall != null) {
                System.setSecurityManager(toInstall);
            }
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException("Setting the security manager is not allowed. The java.security.manager=allow java property must be set.", e);
        }
        this.setSecurityManagner = toInstall;
    }

    private void registerLocations(BundleContext bc, EquinoxLocations equinoxLocations) {
        Hashtable<String, Object> locationProperties = new Hashtable<String, Object>(1);
        Location location = equinoxLocations.getUserLocation();
        if (location != null) {
            ((Dictionary)locationProperties).put("type", "osgi.user.area");
            this.register(bc, Location.class, location, locationProperties);
        }
        if ((location = equinoxLocations.getInstanceLocation()) != null) {
            ((Dictionary)locationProperties).put("type", "osgi.instance.area");
            this.register(bc, Location.class, location, locationProperties);
        }
        if ((location = equinoxLocations.getConfigurationLocation()) != null) {
            ((Dictionary)locationProperties).put("type", "osgi.configuration.area");
            this.register(bc, Location.class, location, locationProperties);
        }
        if ((location = equinoxLocations.getInstallLocation()) != null) {
            ((Dictionary)locationProperties).put("type", "osgi.install.area");
            this.register(bc, Location.class, location, locationProperties);
        }
        if ((location = equinoxLocations.getEclipseHomeLocation()) != null) {
            ((Dictionary)locationProperties).put("type", "eclipse.home.location");
            this.register(bc, Location.class, location, locationProperties);
        }
    }

    @Override
    public void stop(BundleContext bc) throws Exception {
        EquinoxBundle bundle = (EquinoxBundle)bc.getBundle();
        bundle.getEquinoxContainer().getStorage().getExtensionInstaller().stopExtensionActivators(bc);
        FrameworkDebugOptions dbgOptions = (FrameworkDebugOptions)bundle.getEquinoxContainer().getConfiguration().getDebugOptions();
        dbgOptions.stop(bc);
        this.urlFactoryManager.uninstallHandlerFactories();
        for (ServiceRegistration<?> registration : this.registrations) {
            registration.unregister();
        }
        this.registrations.clear();
        bundle.getEquinoxContainer().getLogServices().stop(bc);
        this.unintallSecurityManager();
        bundle.getEquinoxContainer().systemStop(bc);
    }

    private void unintallSecurityManager() {
        if (this.setSecurityManagner != null && System.getSecurityManager() == this.setSecurityManagner) {
            System.setSecurityManager(null);
        }
        this.setSecurityManagner = null;
    }

    private void register(BundleContext context, Class<?> serviceClass, Object service, Dictionary<String, Object> properties) {
        this.register(context, serviceClass.getName(), service, true, properties);
    }

    private void register(BundleContext context, Class<?> serviceClass, Object service, boolean setRanking, Dictionary<String, Object> properties) {
        this.register(context, serviceClass.getName(), service, setRanking, properties);
    }

    private void register(BundleContext context, String serviceClass, Object service, boolean setRanking, Dictionary<String, Object> properties) {
        if (properties == null) {
            properties = new Hashtable<String, Object>();
        }
        if (setRanking) {
            properties.put("service.ranking", Integer.MAX_VALUE);
        }
        properties.put("service.pid", String.valueOf(context.getBundle().getBundleId()) + "." + service.getClass().getName());
        this.registrations.add(context.registerService(serviceClass, service, properties));
    }
}

