/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jface.text;

import paper.libs.org.eclipse.jface.text.AbstractLineTracker;
import paper.libs.org.eclipse.jface.text.TextUtilities;

public class DefaultLineTracker
extends AbstractLineTracker {
    public static final String[] DELIMITERS = new String[]{"\r", "\n", "\r\n"};
    private AbstractLineTracker.DelimiterInfo fDelimiterInfo = new AbstractLineTracker.DelimiterInfo();

    @Override
    public String[] getLegalLineDelimiters() {
        return TextUtilities.copy(DELIMITERS);
    }

    @Override
    protected AbstractLineTracker.DelimiterInfo nextDelimiterInfo(String text, int offset) {
        int length = text.length();
        int i2 = offset;
        while (i2 < length) {
            char ch = text.charAt(i2);
            if (ch == '\r') {
                if (i2 + 1 < length && text.charAt(i2 + 1) == '\n') {
                    this.fDelimiterInfo.delimiter = DELIMITERS[2];
                    this.fDelimiterInfo.delimiterIndex = i2;
                    this.fDelimiterInfo.delimiterLength = 2;
                    return this.fDelimiterInfo;
                }
                this.fDelimiterInfo.delimiter = DELIMITERS[0];
                this.fDelimiterInfo.delimiterIndex = i2;
                this.fDelimiterInfo.delimiterLength = 1;
                return this.fDelimiterInfo;
            }
            if (ch == '\n') {
                this.fDelimiterInfo.delimiter = DELIMITERS[1];
                this.fDelimiterInfo.delimiterIndex = i2;
                this.fDelimiterInfo.delimiterLength = 1;
                return this.fDelimiterInfo;
            }
            ++i2;
        }
        return null;
    }
}

