/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.search.indexing;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import paper.libs.org.eclipse.core.runtime.Path;
import paper.libs.org.eclipse.jdt.core.search.SearchEngine;
import paper.libs.org.eclipse.jdt.core.search.SearchParticipant;
import paper.libs.org.eclipse.jdt.internal.compiler.util.Util;
import paper.libs.org.eclipse.jdt.internal.core.index.FileIndexLocation;
import paper.libs.org.eclipse.jdt.internal.core.index.Index;
import paper.libs.org.eclipse.jdt.internal.core.search.JavaSearchDocument;
import paper.libs.org.eclipse.jdt.internal.core.search.indexing.BinaryIndexer;

public class DefaultJavaIndexer {
    private static final char JAR_SEPARATOR = "|".charAt(0);

    public void generateIndexForJar(String pathToJar, String pathToIndexFile) throws IOException {
        File f = new File(pathToJar);
        if (!f.exists()) {
            throw new FileNotFoundException(String.valueOf(pathToJar) + " not found");
        }
        FileIndexLocation indexLocation = new FileIndexLocation(new File(pathToIndexFile));
        Index index = new Index(indexLocation, pathToJar, false);
        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
        index.separator = JAR_SEPARATOR;
        try (ZipFile zip = new ZipFile(pathToJar);){
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                String zipEntryName = ze.getName();
                if (!Util.isClassFileName(zipEntryName)) continue;
                byte[] classFileBytes = Util.getZipEntryByteContent(ze, zip);
                JavaSearchDocument entryDocument = new JavaSearchDocument(ze, new Path(pathToJar), classFileBytes, participant);
                entryDocument.setIndex(index);
                new BinaryIndexer(entryDocument).indexDocument();
            }
            index.save();
        }
    }
}

