/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.index;

import java.io.IOException;
import paper.libs.org.eclipse.jdt.core.compiler.CharOperation;
import paper.libs.org.eclipse.jdt.internal.compiler.util.SimpleSet;
import paper.libs.org.eclipse.jdt.internal.core.index.Index;

public class EntryResult {
    private char[] word;
    private Object[] documentTables;
    private SimpleSet documentNames;

    public EntryResult(char[] word, Object table) {
        this.word = word;
        if (table != null) {
            this.documentTables = new Object[]{table};
        }
    }

    public void addDocumentName(String documentName) {
        if (this.documentNames == null) {
            this.documentNames = new SimpleSet(3);
        }
        this.documentNames.add(documentName);
    }

    public void addDocumentTable(Object table) {
        if (this.documentTables != null) {
            int length = this.documentTables.length;
            this.documentTables = new Object[length + 1];
            System.arraycopy(this.documentTables, 0, this.documentTables, 0, length);
            this.documentTables[length] = table;
        } else {
            this.documentTables = new Object[]{table};
        }
    }

    public char[] getWord() {
        return this.word;
    }

    public String[] getDocumentNames(Index index) throws IOException {
        if (this.documentTables != null) {
            int length = this.documentTables.length;
            if (length == 1 && this.documentNames == null) {
                Object offset = this.documentTables[0];
                int[] numbers = index.diskIndex.readDocumentNumbers(offset);
                String[] names = new String[numbers.length];
                int i2 = 0;
                int l = numbers.length;
                while (i2 < l) {
                    names[i2] = index.diskIndex.readDocumentName(numbers[i2]);
                    ++i2;
                }
                return names;
            }
            int i3 = 0;
            while (i3 < length) {
                Object offset = this.documentTables[i3];
                int[] numbers = index.diskIndex.readDocumentNumbers(offset);
                int j = 0;
                int k = numbers.length;
                while (j < k) {
                    this.addDocumentName(index.diskIndex.readDocumentName(numbers[j]));
                    ++j;
                }
                ++i3;
            }
        }
        if (this.documentNames == null) {
            return CharOperation.NO_STRINGS;
        }
        String[] names = new String[this.documentNames.elementSize];
        int count = 0;
        Object[] values = this.documentNames.values;
        int i4 = 0;
        int l = values.length;
        while (i4 < l) {
            if (values[i4] != null) {
                names[count++] = (String)values[i4];
            }
            ++i4;
        }
        return names;
    }

    public boolean isEmpty() {
        return this.documentTables == null && this.documentNames == null;
    }
}

