/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.dom.rewrite.imports;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import paper.libs.org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportAdder;
import paper.libs.org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportName;

final class OrderPreservingImportAdder
implements ImportAdder {
    private final Comparator<ImportName> importComparator;

    private static int countMatchingPrefixSegments(String name1, String name2) {
        if (name1.isEmpty() || name2.isEmpty()) {
            return 0;
        }
        int matchingSegments = 0;
        int i2 = 0;
        while (i2 <= name1.length() && i2 <= name2.length()) {
            boolean atEndOfName2Segment;
            boolean atEndOfName1Segment = i2 == name1.length() || name1.charAt(i2) == '.';
            boolean bl = atEndOfName2Segment = i2 == name2.length() || name2.charAt(i2) == '.';
            if (atEndOfName1Segment && atEndOfName2Segment) {
                ++matchingSegments;
            } else if (atEndOfName1Segment || atEndOfName2Segment || name1.charAt(i2) != name2.charAt(i2)) break;
            ++i2;
        }
        return matchingSegments;
    }

    OrderPreservingImportAdder(Comparator<ImportName> importComparator) {
        this.importComparator = importComparator;
    }

    @Override
    public List<ImportName> addImports(Collection<ImportName> existingImports, Collection<ImportName> importsToAdd) {
        if (importsToAdd.isEmpty()) {
            return new ArrayList<ImportName>(existingImports);
        }
        ArrayList<ImportName> sortedNewImports = new ArrayList<ImportName>(importsToAdd);
        sortedNewImports.removeAll(new HashSet<ImportName>(existingImports));
        Collections.sort(sortedNewImports, this.importComparator);
        if (existingImports.isEmpty()) {
            return sortedNewImports;
        }
        Map<ImportName, AdjacentImports> adjacentNewImports = this.determineAdjacentNewImports(new ArrayList<ImportName>(existingImports), sortedNewImports);
        ArrayList<ImportName> importsWithAdditions = new ArrayList<ImportName>(existingImports.size() + sortedNewImports.size());
        for (ImportName existingImport : existingImports) {
            AdjacentImports adjacentImports = adjacentNewImports.remove(existingImport);
            if (adjacentImports != null) {
                importsWithAdditions.addAll(adjacentImports.importsBefore);
            }
            importsWithAdditions.add(existingImport);
            if (adjacentImports == null) continue;
            importsWithAdditions.addAll(adjacentImports.importsAfter);
        }
        return importsWithAdditions;
    }

    private Map<ImportName, AdjacentImports> determineAdjacentNewImports(Collection<ImportName> existingImports, Iterable<ImportName> sortedNewImports) {
        TreeSet<ImportName> existingImportsTreeSet = new TreeSet<ImportName>(this.importComparator);
        existingImportsTreeSet.addAll(existingImports);
        HashMap<ImportName, AdjacentImports> adjacentNewImports = new HashMap<ImportName, AdjacentImports>();
        for (ImportName existingImport : existingImports) {
            adjacentNewImports.put(existingImport, new AdjacentImports());
        }
        for (ImportName newImport : sortedNewImports) {
            ImportName succeedingExistingImport;
            ImportName precedingExistingImport;
            if (this.shouldGroupWithSucceeding(newImport, precedingExistingImport = existingImportsTreeSet.lower(newImport), succeedingExistingImport = existingImportsTreeSet.higher(newImport))) {
                ((AdjacentImports)adjacentNewImports.get((Object)succeedingExistingImport)).importsBefore.add(newImport);
                continue;
            }
            ((AdjacentImports)adjacentNewImports.get((Object)precedingExistingImport)).importsAfter.add(newImport);
        }
        return adjacentNewImports;
    }

    private boolean shouldGroupWithSucceeding(ImportName newImport, ImportName precedingExistingImport, ImportName succeedingExistingImport) {
        if (precedingExistingImport == null) {
            return true;
        }
        if (succeedingExistingImport == null) {
            return false;
        }
        String containerName = newImport.containerName;
        int prefixSharedWithPreceding = OrderPreservingImportAdder.countMatchingPrefixSegments(containerName, precedingExistingImport.containerName);
        int prefixSharedWithSucceeding = OrderPreservingImportAdder.countMatchingPrefixSegments(containerName, succeedingExistingImport.containerName);
        return prefixSharedWithSucceeding > prefixSharedWithPreceding;
    }

    static class AdjacentImports {
        final Collection<ImportName> importsBefore = new ArrayList<ImportName>();
        final Collection<ImportName> importsAfter = new ArrayList<ImportName>();

        AdjacentImports() {
        }

        public String toString() {
            return String.format("(%s, %s)", this.importsBefore.toString(), this.importsAfter.toString());
        }
    }
}

