/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.builder;

import java.util.Locale;
import java.util.Map;
import paper.libs.org.eclipse.core.resources.IFile;
import paper.libs.org.eclipse.core.resources.IResource;
import paper.libs.org.eclipse.jdt.core.IJavaProject;
import paper.libs.org.eclipse.jdt.core.IModuleDescription;
import paper.libs.org.eclipse.jdt.core.IPackageFragmentRoot;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.core.util.IAttributeNamesConstants;
import paper.libs.org.eclipse.jdt.internal.compiler.ClassFile;
import paper.libs.org.eclipse.jdt.internal.compiler.CompilationResult;
import paper.libs.org.eclipse.jdt.internal.compiler.Compiler;
import paper.libs.org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import paper.libs.org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import paper.libs.org.eclipse.jdt.internal.compiler.IProblemFactory;
import paper.libs.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import paper.libs.org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import paper.libs.org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import paper.libs.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import paper.libs.org.eclipse.jdt.internal.compiler.util.SimpleSetOfCharArray;
import paper.libs.org.eclipse.jdt.internal.core.CompilationGroup;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelStatus;
import paper.libs.org.eclipse.jdt.internal.core.ModuleUpdater;
import paper.libs.org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import paper.libs.org.eclipse.jdt.internal.core.builder.NameEnvironment;
import paper.libs.org.eclipse.jdt.internal.core.builder.ProblemFactory;
import paper.libs.org.eclipse.jdt.internal.core.builder.SourceFile;

public class ModuleInfoBuilder {
    public byte[] compileWithAttributes(IModuleDescription module, Map<String, String> classFileAttributes) throws JavaModelException {
        IJavaProject javaProject = module.getJavaProject();
        NameEnvironment nameEnvironment = new NameEnvironment(javaProject, CompilationGroup.MAIN);
        this.addModuleUpdates(module, nameEnvironment.moduleUpdater, classFileAttributes);
        ClasspathMultiDirectory sourceLocation = this.getSourceLocation(javaProject, nameEnvironment, module);
        IFile file = (IFile)module.getCompilationUnit().getCorrespondingResource();
        ICompilationUnit[] sourceUnits = new ICompilationUnit[]{new SourceFile(file, sourceLocation)};
        BytecodeCollector collector = new BytecodeCollector();
        Compiler newCompiler = new Compiler((INameEnvironment)nameEnvironment, DefaultErrorHandlingPolicies.exitOnFirstError(), new CompilerOptions(javaProject.getOptions(true)), (ICompilerRequestor)collector, (IProblemFactory)ProblemFactory.getProblemFactory(Locale.getDefault()));
        newCompiler.compile(sourceUnits);
        return collector.bytes;
    }

    private void addModuleUpdates(IModuleDescription module, ModuleUpdater moduleUpdater, Map<String, String> classFileAttributes) {
        String modulePackageNames;
        String mainClassName = classFileAttributes.remove(String.valueOf(IAttributeNamesConstants.MODULE_MAIN_CLASS));
        if (mainClassName != null) {
            moduleUpdater.addModuleUpdate(module.getElementName(), m -> m.setMainClassName(mainClassName.toCharArray()), IUpdatableModule.UpdateKind.MODULE);
        }
        if ((modulePackageNames = classFileAttributes.remove(String.valueOf(IAttributeNamesConstants.MODULE_PACKAGES))) != null) {
            SimpleSetOfCharArray namesSet = new SimpleSetOfCharArray();
            String[] providedNames = modulePackageNames.split(",");
            int i2 = 0;
            while (i2 < providedNames.length) {
                namesSet.add(providedNames[i2].trim().toCharArray());
                ++i2;
            }
            moduleUpdater.addModuleUpdate(module.getElementName(), m -> m.setPackageNames(namesSet), IUpdatableModule.UpdateKind.MODULE);
        }
        if (!classFileAttributes.isEmpty()) {
            throw new IllegalArgumentException("Unsupported key(s): " + classFileAttributes.keySet().toString());
        }
    }

    private ClasspathMultiDirectory getSourceLocation(IJavaProject javaProject, NameEnvironment nameEnvironment, IModuleDescription module) throws JavaModelException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)module.getAncestor(3);
        IResource rootResource = root.getCorrespondingResource();
        ClasspathMultiDirectory[] classpathMultiDirectoryArray = nameEnvironment.sourceLocations;
        int n = nameEnvironment.sourceLocations.length;
        int n2 = 0;
        while (n2 < n) {
            ClasspathMultiDirectory sourceLocation = classpathMultiDirectoryArray[n2];
            if (sourceLocation.sourceFolder.equals(rootResource)) {
                return sourceLocation;
            }
            ++n2;
        }
        throw new JavaModelException(new JavaModelStatus(1006, module));
    }

    static class BytecodeCollector
    implements ICompilerRequestor {
        byte[] bytes;

        BytecodeCollector() {
        }

        @Override
        public void acceptResult(CompilationResult result) {
            assert (this.bytes == null) : "duplicate result";
            ClassFile[] classFiles = result.getClassFiles();
            assert (classFiles.length == 1);
            this.bytes = classFiles[0].getBytes();
        }
    }
}

