/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import paper.libs.org.eclipse.core.resources.IResourceRuleFactory;
import paper.libs.org.eclipse.core.resources.ResourcesPlugin;
import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.core.runtime.jobs.ISchedulingRule;
import paper.libs.org.eclipse.core.runtime.jobs.MultiRule;
import paper.libs.org.eclipse.jdt.core.IClasspathEntry;
import paper.libs.org.eclipse.jdt.core.IJavaElement;
import paper.libs.org.eclipse.jdt.core.IJavaModelStatus;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.internal.core.ChangeClasspathOperation;
import paper.libs.org.eclipse.jdt.internal.core.ClasspathChange;
import paper.libs.org.eclipse.jdt.internal.core.ClasspathEntry;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelManager;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelStatus;
import paper.libs.org.eclipse.jdt.internal.core.JavaProject;

public class SetClasspathOperation
extends ChangeClasspathOperation {
    IClasspathEntry[] newRawClasspath;
    IClasspathEntry[] referencedEntries;
    IPath newOutputLocation;
    JavaProject project;

    public SetClasspathOperation(JavaProject project, IClasspathEntry[] newRawClasspath, IPath newOutputLocation, boolean canChangeResource) {
        this(project, newRawClasspath, null, newOutputLocation, canChangeResource);
    }

    public SetClasspathOperation(JavaProject project, IClasspathEntry[] newRawClasspath, IClasspathEntry[] referencedEntries, IPath newOutputLocation, boolean canChangeResource) {
        super(new IJavaElement[]{project}, canChangeResource);
        this.project = project;
        this.newRawClasspath = newRawClasspath;
        this.referencedEntries = referencedEntries;
        this.newOutputLocation = newOutputLocation;
    }

    @Override
    protected void executeOperation() throws JavaModelException {
        this.checkCanceled();
        try {
            JavaModelManager.PerProjectInfo perProjectInfo = this.project.getPerProjectInfo();
            ClasspathChange classpathChange = perProjectInfo.setRawClasspath(this.newRawClasspath, this.referencedEntries, this.newOutputLocation, JavaModelStatus.VERIFIED_OK);
            this.classpathChanged(classpathChange, true);
            if (this.canChangeResources && perProjectInfo.writeAndCacheClasspath(this.project, this.newRawClasspath, this.newOutputLocation)) {
                SetClasspathOperation.setAttribute("hasModifiedResource", "true");
            }
        }
        finally {
            this.done();
        }
    }

    @Override
    protected ISchedulingRule getSchedulingRule() {
        if (this.canChangeResources) {
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            return new MultiRule(new ISchedulingRule[]{ruleFactory.modifyRule(this.project.getProject()), ruleFactory.modifyRule(JavaModelManager.getExternalManager().getExternalFoldersProject())});
        }
        return super.getSchedulingRule();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(20);
        buffer.append("SetClasspathOperation\n");
        buffer.append(" - classpath : ");
        buffer.append("{");
        int i2 = 0;
        while (i2 < this.newRawClasspath.length) {
            if (i2 > 0) {
                buffer.append(",");
            }
            IClasspathEntry element = this.newRawClasspath[i2];
            buffer.append(" ").append(element.toString());
            ++i2;
        }
        buffer.append("\n - output location : ");
        buffer.append(this.newOutputLocation.toString());
        return buffer.toString();
    }

    @Override
    public IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        this.project.flushClasspathProblemMarkers(false, false, true);
        return ClasspathEntry.validateClasspath(this.project, this.newRawClasspath, this.newOutputLocation);
    }
}

