/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import paper.libs.org.eclipse.jdt.core.IJavaElement;
import paper.libs.org.eclipse.jdt.core.IRegion;

public class Region
implements IRegion {
    private Node root = new Node();

    @Override
    public void add(IJavaElement element) {
        if (this.contains(element)) {
            return;
        }
        Node node = this.createNodeFor(element);
        node.clearChildren();
    }

    private Node createNodeFor(IJavaElement element) {
        if (element == null) {
            return this.root;
        }
        Node parentNode = this.createNodeFor(this.getParent(element));
        return parentNode.createChildFor(element);
    }

    @Override
    public boolean contains(IJavaElement element) {
        Node existingNode = this.findMostSpecificNodeFor(element);
        if (existingNode == this.root) {
            return false;
        }
        return existingNode.isEmpty();
    }

    private Node findMostSpecificNodeFor(IJavaElement element) {
        if (element == null) {
            return this.root;
        }
        Node parentNode = this.findMostSpecificNodeFor(this.getParent(element));
        Node child = parentNode.findChildFor(element);
        if (child == null) {
            return parentNode;
        }
        return child;
    }

    @Override
    public IJavaElement[] getElements() {
        int leaves = this.countLeafNodes();
        IJavaElement[] result = new IJavaElement[leaves];
        int insertions = this.root.gatherLeaves(result, 0);
        assert (insertions == leaves);
        return result;
    }

    private int countLeafNodes() {
        if (this.root.isEmpty()) {
            return 0;
        }
        return this.root.countLeafNodes();
    }

    private Node findExactNode(IJavaElement element) {
        if (element == null) {
            return this.root;
        }
        Node parentNode = this.findExactNode(this.getParent(element));
        if (parentNode == null) {
            return null;
        }
        return parentNode.findChildFor(element);
    }

    @Override
    public boolean remove(IJavaElement element) {
        Node node = this.findExactNode(element);
        if (node == null) {
            return false;
        }
        node.clearChildren();
        boolean returnValue = node.isEmpty();
        ArrayList<Node> ancestors = new ArrayList<Node>();
        this.findPath(ancestors, element);
        IJavaElement currentElement = element;
        int idx = ancestors.size();
        while (--idx > 0 && currentElement != null) {
            Node current = (Node)ancestors.get(idx);
            Node parent = (Node)ancestors.get(idx - 1);
            if (!current.isEmpty()) break;
            parent.removeChild(currentElement);
            currentElement = this.getParent(currentElement);
        }
        return returnValue;
    }

    protected IJavaElement getParent(IJavaElement element) {
        return element.getParent();
    }

    private void findPath(List<Node> ancestors, IJavaElement element) {
        if (element == null) {
            ancestors.add(this.root);
            return;
        }
        this.findPath(ancestors, this.getParent(element));
        Node last = ancestors.get(ancestors.size() - 1);
        Node next = last.findChildFor(element);
        if (next != null) {
            ancestors.add(next);
        }
    }

    private static final class Node {
        private Map<IJavaElement, Node> children = Collections.emptyMap();

        public void clearChildren() {
            this.children = Collections.emptyMap();
        }

        public Node createChildFor(IJavaElement element) {
            Node child;
            if (this.children.isEmpty()) {
                this.children = new HashMap<IJavaElement, Node>();
            }
            if ((child = this.children.get(element)) == null) {
                child = new Node();
                this.children.put(element, child);
            }
            return child;
        }

        public Node findChildFor(IJavaElement element) {
            return this.children.get(element);
        }

        public int countLeafNodes() {
            if (this.isEmpty()) {
                return 1;
            }
            int result = 0;
            for (Node next : this.children.values()) {
                result += next.countLeafNodes();
            }
            return result;
        }

        boolean isEmpty() {
            return this.children.isEmpty();
        }

        public int gatherLeaves(IJavaElement[] result, int i2) {
            for (Map.Entry<IJavaElement, Node> next : this.children.entrySet()) {
                Node nextNode = next.getValue();
                if (nextNode.isEmpty()) {
                    result[i2++] = next.getKey();
                    continue;
                }
                i2 = nextNode.gatherLeaves(result, i2);
            }
            return i2;
        }

        public void removeChild(IJavaElement currentElement) {
            this.children.remove(currentElement);
        }
    }
}

