/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import java.util.Arrays;
import paper.libs.org.eclipse.jdt.core.IJavaElement;
import paper.libs.org.eclipse.jdt.core.IModuleDescription;
import paper.libs.org.eclipse.jdt.internal.core.JavaElement;
import paper.libs.org.eclipse.jdt.internal.core.JavaElementInfo;

public class OpenableElementInfo
extends JavaElementInfo {
    protected volatile IJavaElement[] children = JavaElement.NO_ELEMENTS;
    protected IModuleDescription module;
    protected boolean isStructureKnown = false;
    protected Object[] nonJavaResources;

    public void addChild(IJavaElement child) {
        IJavaElement[] oldChildren = this.children;
        int length = oldChildren.length;
        if (length == 0) {
            this.children = new IJavaElement[]{child};
        } else {
            int i2 = 0;
            while (i2 < length) {
                if (oldChildren[i2].equals(child)) {
                    return;
                }
                ++i2;
            }
            IJavaElement[] newChildren = new IJavaElement[length + 1];
            System.arraycopy(oldChildren, 0, newChildren, 0, length);
            newChildren[length] = child;
            this.children = newChildren;
        }
    }

    @Override
    public IJavaElement[] getChildren() {
        return this.children;
    }

    public boolean isStructureKnown() {
        return this.isStructureKnown;
    }

    public void removeChild(IJavaElement child) {
        IJavaElement[] oldChildren = this.children;
        int i2 = 0;
        int length = oldChildren.length;
        while (i2 < length) {
            if (oldChildren[i2].equals(child)) {
                if (length == 1) {
                    this.children = JavaElement.NO_ELEMENTS;
                    break;
                }
                IJavaElement[] newChildren = new IJavaElement[length - 1];
                System.arraycopy(oldChildren, 0, newChildren, 0, i2);
                if (i2 < length - 1) {
                    System.arraycopy(oldChildren, i2 + 1, newChildren, i2, length - 1 - i2);
                }
                this.children = newChildren;
                break;
            }
            ++i2;
        }
    }

    public void setChildren(IJavaElement[] children) {
        this.children = children.length > 0 ? children : JavaElement.NO_ELEMENTS;
    }

    public void setModule(IModuleDescription module) {
        this.module = module;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        sb.append("isStructureKnown=");
        sb.append(this.isStructureKnown);
        sb.append(", ");
        if (this.module != null) {
            sb.append("module=");
            sb.append(this.module);
            sb.append(", ");
        }
        if (this.children != null) {
            sb.append("children=");
            sb.append(Arrays.toString(this.children));
            sb.append(", ");
        }
        if (this.nonJavaResources != null) {
            sb.append("nonJavaResources=");
            sb.append(Arrays.toString(this.nonJavaResources));
        }
        sb.append("]");
        return sb.toString();
    }

    public IModuleDescription getModule() {
        return this.module;
    }

    public void setIsStructureKnown(boolean newIsStructureKnown) {
        this.isStructureKnown = newIsStructureKnown;
    }

    void setNonJavaResources(Object[] resources) {
        this.nonJavaResources = resources;
    }
}

