/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import paper.libs.org.eclipse.core.resources.IContainer;
import paper.libs.org.eclipse.core.resources.IResource;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.jdt.core.IClasspathEntry;
import paper.libs.org.eclipse.jdt.core.ICompilationUnit;
import paper.libs.org.eclipse.jdt.core.IJavaElement;
import paper.libs.org.eclipse.jdt.core.IJavaProject;
import paper.libs.org.eclipse.jdt.core.IPackageFragmentRoot;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.internal.core.ClasspathEntry;
import paper.libs.org.eclipse.jdt.internal.core.DeltaProcessor;
import paper.libs.org.eclipse.jdt.internal.core.JarPackageFragmentRootInfo;
import paper.libs.org.eclipse.jdt.internal.core.JavaElement;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelManager;
import paper.libs.org.eclipse.jdt.internal.core.JavaProject;
import paper.libs.org.eclipse.jdt.internal.core.NameLookup;
import paper.libs.org.eclipse.jdt.internal.core.OpenableElementInfo;
import paper.libs.org.eclipse.jdt.internal.core.PackageFragment;
import paper.libs.org.eclipse.jdt.internal.core.PackageFragmentRoot;
import paper.libs.org.eclipse.jdt.internal.core.PackageFragmentRootInfo;
import paper.libs.org.eclipse.jdt.internal.core.util.HashSetOfArray;
import paper.libs.org.eclipse.jdt.internal.core.util.HashtableOfArrayToObject;
import paper.libs.org.eclipse.jdt.internal.core.util.Util;

class JavaProjectElementInfo
extends OpenableElementInfo {
    static final IPackageFragmentRoot[] NO_ROOTS = new IPackageFragmentRoot[0];
    ProjectCache projectCache;
    ProjectCache mainProjectCache;

    static void addSuperPackageNames(String[] pkgName, HashtableOfArrayToObject packageFragments) {
        int i2 = pkgName.length - 1;
        while (i2 > 0) {
            if (packageFragments.getKey(pkgName, i2) == null) {
                String[] stringArray = pkgName;
                pkgName = new String[i2];
                System.arraycopy(stringArray, 0, pkgName, 0, i2);
                packageFragments.put(pkgName, NO_ROOTS);
            }
            --i2;
        }
    }

    public JavaProjectElementInfo() {
        this.nonJavaResources = null;
    }

    private Object[] computeNonJavaResources(JavaProject project) {
        IPath projectPath = project.getProject().getFullPath();
        boolean srcIsProject = false;
        boolean binIsProject = false;
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = null;
        IPath projectOutput = null;
        boolean isClasspathResolved = true;
        try {
            IClasspathEntry entry = project.getClasspathEntryFor(projectPath);
            if (entry != null) {
                srcIsProject = true;
                inclusionPatterns = ((ClasspathEntry)entry).fullInclusionPatternChars();
                exclusionPatterns = ((ClasspathEntry)entry).fullExclusionPatternChars();
            }
            projectOutput = project.getOutputLocation();
            binIsProject = projectPath.equals(projectOutput);
        }
        catch (JavaModelException javaModelException) {
            isClasspathResolved = false;
        }
        Object[] resources = new IResource[5];
        int resourcesCounter = 0;
        try {
            IResource[] members = ((IContainer)project.getResource()).members();
            int length = members.length;
            if (length > 0) {
                String sourceLevel = project.getOption("paper.libs.org.eclipse.jdt.core.compiler.source", true);
                String complianceLevel = project.getOption("paper.libs.org.eclipse.jdt.core.compiler.compliance", true);
                IClasspathEntry[] classpath = project.getResolvedClasspath();
                int i2 = 0;
                while (i2 < length) {
                    IResource res = members[i2];
                    switch (res.getType()) {
                        case 1: {
                            IPath resFullPath = res.getFullPath();
                            String resName = res.getName();
                            if (isClasspathResolved && this.isClasspathEntryOrOutputLocation(resFullPath, res.getLocation(), classpath, projectOutput) || srcIsProject && Util.isValidCompilationUnitName(resName, sourceLevel, complianceLevel) && !Util.isExcluded(res, inclusionPatterns, exclusionPatterns) || binIsProject && Util.isValidClassFileName(resName, sourceLevel, complianceLevel)) break;
                            if (resources.length == resourcesCounter) {
                                Object[] objectArray = resources;
                                resources = new IResource[resourcesCounter * 2];
                                System.arraycopy(objectArray, 0, resources, 0, resourcesCounter);
                            }
                            resources[resourcesCounter++] = res;
                            break;
                        }
                        case 2: {
                            IPath resFullPath = res.getFullPath();
                            if (srcIsProject && !Util.isExcluded(res, inclusionPatterns, exclusionPatterns) && Util.isValidFolderNameForPackage(res.getName(), sourceLevel, complianceLevel) || isClasspathResolved && this.isClasspathEntryOrOutputLocation(resFullPath, res.getLocation(), classpath, projectOutput)) break;
                            if (resources.length == resourcesCounter) {
                                Object[] objectArray = resources;
                                resources = new IResource[resourcesCounter * 2];
                                System.arraycopy(objectArray, 0, resources, 0, resourcesCounter);
                            }
                            resources[resourcesCounter++] = res;
                        }
                    }
                    ++i2;
                }
            }
            if (resources.length != resourcesCounter) {
                Object[] objectArray = resources;
                resources = new IResource[resourcesCounter];
                System.arraycopy(objectArray, 0, resources, 0, resourcesCounter);
            }
        }
        catch (CoreException coreException) {
            resources = NO_NON_JAVA_RESOURCES;
            resourcesCounter = 0;
        }
        return resources;
    }

    ProjectCache getProjectCache(JavaProject project, boolean excludeTestCode) {
        ProjectCache cache;
        ProjectCache projectCache = cache = excludeTestCode ? this.mainProjectCache : this.projectCache;
        if (cache != null) {
            IPackageFragmentRoot[] iPackageFragmentRootArray = cache.allPkgFragmentRootsCache;
            int n = cache.allPkgFragmentRootsCache.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                IJavaProject rootProject = root.getJavaProject();
                if (rootProject != project && !rootProject.exists()) {
                    cache = null;
                    break;
                }
                ++n2;
            }
        }
        if (cache == null) {
            IPackageFragmentRoot[] roots;
            HashMap<IPackageFragmentRoot, IClasspathEntry> reverseMap = new HashMap<IPackageFragmentRoot, IClasspathEntry>(3);
            try {
                roots = project.getAllPackageFragmentRoots(reverseMap, excludeTestCode);
            }
            catch (JavaModelException javaModelException) {
                roots = new IPackageFragmentRoot[]{};
                reverseMap.clear();
            }
            Map<IPath, DeltaProcessor.RootInfo> rootInfos = JavaModelManager.getJavaModelManager().deltaState.roots;
            HashMap<IPackageFragmentRoot, HashSetOfArray> pkgFragmentsCaches = new HashMap<IPackageFragmentRoot, HashSetOfArray>();
            int length = roots.length;
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            int i2 = 0;
            while (i2 < length) {
                IPackageFragmentRoot root = roots[i2];
                DeltaProcessor.RootInfo rootInfo = rootInfos.get(root.getPath());
                if (rootInfo == null || rootInfo.project.equals(project)) {
                    roots[i2] = root = (IPackageFragmentRoot)manager.getExistingElement(root);
                    HashSetOfArray fragmentsCache = new HashSetOfArray();
                    this.initializePackageNames(root, fragmentsCache);
                    pkgFragmentsCaches.put(root, fragmentsCache);
                }
                ++i2;
            }
            cache = new ProjectCache(roots, reverseMap, pkgFragmentsCaches);
            if (excludeTestCode) {
                this.mainProjectCache = cache;
            } else {
                this.projectCache = cache;
            }
        }
        return cache;
    }

    Object[] getNonJavaResources(JavaProject project) {
        Object[] resources = this.nonJavaResources;
        if (resources == null) {
            resources = this.computeNonJavaResources(project);
            this.nonJavaResources = resources;
        }
        return resources;
    }

    private void initializePackageNames(IPackageFragmentRoot root, HashSetOfArray fragmentsCache) {
        IJavaElement[] frags = null;
        try {
            if (!root.isOpen()) {
                PackageFragmentRootInfo info = root.isArchive() ? new JarPackageFragmentRootInfo() : new PackageFragmentRootInfo();
                ((PackageFragmentRoot)root).computeChildren(info, ((JavaElement)((Object)root)).resource());
                frags = info.children;
            } else {
                frags = root.getChildren();
            }
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        int j = 0;
        int length = frags.length;
        while (j < length) {
            if (frags[j] instanceof PackageFragment) {
                fragmentsCache.add(((PackageFragment)frags[j]).names);
            }
            ++j;
        }
    }

    private boolean isClasspathEntryOrOutputLocation(IPath path, IPath location, IClasspathEntry[] resolvedClasspath, IPath projectOutput) {
        if (projectOutput.equals(path)) {
            return true;
        }
        int i2 = 0;
        int length = resolvedClasspath.length;
        while (i2 < length) {
            IClasspathEntry entry = resolvedClasspath[i2];
            IPath entryPath = entry.getPath();
            if (entryPath.equals(path) || entryPath.equals(location)) {
                return true;
            }
            IPath output = entry.getOutputLocation();
            if (output != null && output.equals(path)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    NameLookup newNameLookup(JavaProject project, ICompilationUnit[] workingCopies, boolean excludeTestCode) {
        ProjectCache cache = this.getProjectCache(project, excludeTestCode);
        HashtableOfArrayToObject allPkgFragmentsCache = cache.allPkgFragmentsCache;
        if (allPkgFragmentsCache == null) {
            Map<IPath, DeltaProcessor.RootInfo> rootInfos = JavaModelManager.getJavaModelManager().deltaState.roots;
            IPackageFragmentRoot[] allRoots = cache.allPkgFragmentRootsCache;
            int length = allRoots.length;
            allPkgFragmentsCache = new HashtableOfArrayToObject();
            int i2 = 0;
            while (i2 < length) {
                block13: {
                    HashSetOfArray fragmentsCache;
                    JavaProject rootProject;
                    IPackageFragmentRoot root = allRoots[i2];
                    DeltaProcessor.RootInfo rootInfo = rootInfos.get(root.getPath());
                    JavaProject javaProject = rootProject = rootInfo == null ? project : rootInfo.project;
                    if (rootProject.equals(project)) {
                        fragmentsCache = cache.pkgFragmentsCaches.get(root);
                    } else {
                        ProjectCache rootProjectCache;
                        try {
                            rootProjectCache = rootProject.getProjectCache(excludeTestCode);
                        }
                        catch (JavaModelException javaModelException) {
                            break block13;
                        }
                        fragmentsCache = rootProjectCache.pkgFragmentsCaches.get(root);
                    }
                    if (fragmentsCache == null) {
                        fragmentsCache = new HashSetOfArray();
                        this.initializePackageNames(root, fragmentsCache);
                    }
                    Object[][] set = fragmentsCache.set;
                    int j = 0;
                    int length2 = set.length;
                    while (j < length2) {
                        Object[] pkgName = (String[])set[j];
                        if (pkgName != null) {
                            Object existing = allPkgFragmentsCache.get(pkgName);
                            if (existing == null || existing == NO_ROOTS) {
                                allPkgFragmentsCache.put(pkgName, root);
                                JavaProjectElementInfo.addSuperPackageNames((String[])pkgName, allPkgFragmentsCache);
                            } else if (existing instanceof PackageFragmentRoot) {
                                allPkgFragmentsCache.put(pkgName, new IPackageFragmentRoot[]{(PackageFragmentRoot)existing, root});
                            } else {
                                IPackageFragmentRoot[] roots = (IPackageFragmentRoot[])existing;
                                int rootLength = roots.length;
                                IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                                roots = new IPackageFragmentRoot[rootLength + 1];
                                System.arraycopy(iPackageFragmentRootArray, 0, roots, 0, rootLength);
                                roots[rootLength] = root;
                                allPkgFragmentsCache.put(pkgName, roots);
                            }
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            cache.allPkgFragmentsCache = allPkgFragmentsCache;
        }
        return new NameLookup(project, cache.allPkgFragmentRootsCache, cache.allPkgFragmentsCache, workingCopies, cache.rootToResolvedEntries);
    }

    void resetCaches() {
        this.projectCache = null;
        this.mainProjectCache = null;
    }

    static class ProjectCache {
        public IPackageFragmentRoot[] allPkgFragmentRootsCache;
        public HashtableOfArrayToObject allPkgFragmentsCache;
        public Map<IPackageFragmentRoot, HashSetOfArray> pkgFragmentsCaches;
        public Map<IPackageFragmentRoot, IClasspathEntry> rootToResolvedEntries;

        ProjectCache(IPackageFragmentRoot[] allPkgFragmentRootsCache, Map<IPackageFragmentRoot, IClasspathEntry> rootToResolvedEntries, Map<IPackageFragmentRoot, HashSetOfArray> pkgFragmentsCaches) {
            this.allPkgFragmentRootsCache = allPkgFragmentRootsCache;
            this.rootToResolvedEntries = rootToResolvedEntries;
            this.pkgFragmentsCaches = pkgFragmentsCaches;
        }
    }
}

