/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import paper.libs.org.eclipse.core.resources.IBuildConfiguration;
import paper.libs.org.eclipse.core.resources.IDynamicReferenceProvider;
import paper.libs.org.eclipse.core.resources.IProject;
import paper.libs.org.eclipse.core.resources.IWorkspaceRoot;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.jdt.core.IJavaProject;
import paper.libs.org.eclipse.jdt.core.JavaCore;
import paper.libs.org.eclipse.jdt.internal.core.JavaProject;

public class DynamicProjectReferences
implements IDynamicReferenceProvider {
    @Override
    public List<IProject> getDependentProjects(IBuildConfiguration buildConfiguration) throws CoreException {
        IProject input = buildConfiguration.getProject();
        IJavaProject javaProject = JavaCore.create(input);
        if (javaProject instanceof JavaProject) {
            JavaProject project = (JavaProject)javaProject;
            String[] required = project.projectPrerequisites(project.getResolvedClasspath());
            IWorkspaceRoot wksRoot = input.getWorkspace().getRoot();
            return Arrays.stream(required).sorted().map(name2 -> wksRoot.getProject((String)name2)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

