/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import paper.libs.org.eclipse.core.resources.IResource;
import paper.libs.org.eclipse.jdt.core.IJavaElement;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.internal.core.CompilationUnit;
import paper.libs.org.eclipse.jdt.internal.core.JavaElementDelta;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelManager;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelOperation;
import paper.libs.org.eclipse.jdt.internal.core.JavaProject;

public class DiscardWorkingCopyOperation
extends JavaModelOperation {
    public DiscardWorkingCopyOperation(IJavaElement workingCopy) {
        super(new IJavaElement[]{workingCopy});
    }

    @Override
    protected void executeOperation() throws JavaModelException {
        CompilationUnit workingCopy = this.getWorkingCopy();
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int useCount = manager.discardPerWorkingCopyInfo(workingCopy);
        if (useCount == 0) {
            JavaProject javaProject = workingCopy.getJavaProject();
            if (" ".equals(javaProject.getElementName())) {
                manager.removePerProjectInfo(javaProject, true);
                manager.containerRemove(javaProject);
            }
            if (!workingCopy.isPrimary()) {
                JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
                delta.removed(workingCopy);
                this.addDelta(delta);
                this.removeReconcileDelta(workingCopy);
            } else {
                IResource resource = workingCopy.getResource();
                if (resource != null) {
                    if (resource.isAccessible()) {
                        JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
                        delta.changed(workingCopy, 65536);
                        this.addDelta(delta);
                    } else {
                        JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
                        delta.removed(workingCopy, 65536);
                        this.addDelta(delta);
                    }
                }
            }
        }
    }

    protected CompilationUnit getWorkingCopy() {
        return (CompilationUnit)this.getElementToProcess();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

