/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import paper.libs.org.eclipse.jdt.core.IAnnotation;
import paper.libs.org.eclipse.jdt.core.IClassFile;
import paper.libs.org.eclipse.jdt.core.IMember;
import paper.libs.org.eclipse.jdt.core.IMemberValuePair;
import paper.libs.org.eclipse.jdt.core.ISourceRange;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.core.SourceRange;
import paper.libs.org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import paper.libs.org.eclipse.jdt.internal.compiler.env.IBinaryElementValuePair;
import paper.libs.org.eclipse.jdt.internal.core.AnnotationInfo;
import paper.libs.org.eclipse.jdt.internal.core.JavaElement;
import paper.libs.org.eclipse.jdt.internal.core.MemberValuePair;
import paper.libs.org.eclipse.jdt.internal.core.SourceMapper;
import paper.libs.org.eclipse.jdt.internal.core.SourceRefElement;
import paper.libs.org.eclipse.jdt.internal.core.util.Util;

public class Annotation
extends SourceRefElement
implements IAnnotation {
    public static final IAnnotation[] NO_ANNOTATIONS = new IAnnotation[0];
    public static final IMemberValuePair[] NO_MEMBER_VALUE_PAIRS = new IMemberValuePair[0];
    protected String name;
    protected String memberValuePairName;

    public Annotation(JavaElement parent, String name2) {
        this(parent, name2, null);
    }

    public Annotation(JavaElement parent, String name2, String memberValuePairName) {
        super(parent);
        this.name = name2.intern();
        this.memberValuePairName = memberValuePairName;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Annotation)) {
            return false;
        }
        Annotation other = (Annotation)o;
        if (this.memberValuePairName == null ? other.memberValuePairName != null : !this.memberValuePairName.equals(other.memberValuePairName)) {
            return false;
        }
        return super.equals(o);
    }

    public IMember getDeclaringMember() {
        return (IMember)((Object)this.getParent());
    }

    @Override
    public String getElementName() {
        return this.name;
    }

    @Override
    public int getElementType() {
        return 16;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '}';
    }

    @Override
    public IMemberValuePair[] getMemberValuePairs() throws JavaModelException {
        Object info = this.getElementInfo();
        if (info instanceof AnnotationInfo) {
            return ((AnnotationInfo)info).members;
        }
        IBinaryElementValuePair[] binaryAnnotations = ((IBinaryAnnotation)info).getElementValuePairs();
        int length = binaryAnnotations.length;
        IMemberValuePair[] result = new IMemberValuePair[length];
        int i2 = 0;
        while (i2 < length) {
            IBinaryElementValuePair binaryAnnotation = binaryAnnotations[i2];
            MemberValuePair memberValuePair = new MemberValuePair(new String(binaryAnnotation.getName()));
            memberValuePair.value = Util.getAnnotationMemberValue(this, memberValuePair, binaryAnnotation.getValue());
            result[i2] = memberValuePair;
            ++i2;
        }
        return result;
    }

    @Override
    public ISourceRange getNameRange() throws JavaModelException {
        IClassFile classFile;
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null && (classFile = this.getClassFile()) != null) {
            classFile.getBuffer();
            return mapper.getNameRange(this);
        }
        Object info = this.getElementInfo();
        if (info instanceof AnnotationInfo) {
            AnnotationInfo annotationInfo = (AnnotationInfo)info;
            return new SourceRange(annotationInfo.nameStart, annotationInfo.nameEnd - annotationInfo.nameStart + 1);
        }
        return null;
    }

    @Override
    public ISourceRange getSourceRange() throws JavaModelException {
        IClassFile classFile;
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null && (classFile = this.getClassFile()) != null) {
            classFile.getBuffer();
            return mapper.getSourceRange(this);
        }
        return super.getSourceRange();
    }

    @Override
    public IClassFile getClassFile() {
        return this.getParent().getClassFile();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.memberValuePairName == null ? 0 : this.memberValuePairName.hashCode());
        result = 31 * result + this.name.hashCode();
        return result;
    }

    @Override
    protected void toStringName(StringBuffer buffer) {
        buffer.append('@');
        buffer.append(this.getElementName());
    }
}

