/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.compiler.lookup;

import java.util.HashMap;
import java.util.stream.Stream;
import paper.libs.org.eclipse.jdt.core.compiler.CharOperation;
import paper.libs.org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import paper.libs.org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import paper.libs.org.eclipse.jdt.internal.compiler.env.IModule;
import paper.libs.org.eclipse.jdt.internal.compiler.env.IModuleAwareNameEnvironment;
import paper.libs.org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.Binding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.PlainPackageBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class BinaryModuleBinding
extends ModuleBinding {
    private IModule.IPackageExport[] unresolvedExports;
    private IModule.IPackageExport[] unresolvedOpens;
    private char[][] unresolvedUses;
    private IModule.IService[] unresolvedProvides;

    public static ModuleBinding create(IModule module, LookupEnvironment existingEnvironment) {
        if (module.isAutomatic()) {
            return new AutomaticModuleBinding(module, existingEnvironment);
        }
        return new BinaryModuleBinding((IBinaryModule)module, existingEnvironment);
    }

    private BinaryModuleBinding(IBinaryModule module, LookupEnvironment existingEnvironment) {
        super(module.name(), existingEnvironment);
        existingEnvironment.root.knownModules.put(this.moduleName, this);
        this.cachePartsFrom(module);
    }

    void cachePartsFrom(IBinaryModule module) {
        if (module.isOpen()) {
            this.modifiers |= 0x20;
        }
        this.tagBits |= module.getTagBits();
        IModule.IModuleReference[] requiresReferences = module.requires();
        this.requires = new ModuleBinding[requiresReferences.length];
        this.requiresTransitive = new ModuleBinding[requiresReferences.length];
        int count = 0;
        int transitiveCount = 0;
        int i2 = 0;
        while (i2 < requiresReferences.length) {
            ModuleBinding requiredModule = this.environment.getModule(requiresReferences[i2].name());
            if (requiredModule != null) {
                this.requires[count++] = requiredModule;
                if (requiresReferences[i2].isTransitive()) {
                    this.requiresTransitive[transitiveCount++] = requiredModule;
                }
            }
            ++i2;
        }
        if (count < this.requires.length) {
            this.requires = new ModuleBinding[count];
            System.arraycopy(this.requires, 0, this.requires, 0, count);
        }
        if (transitiveCount < this.requiresTransitive.length) {
            this.requiresTransitive = new ModuleBinding[transitiveCount];
            System.arraycopy(this.requiresTransitive, 0, this.requiresTransitive, 0, transitiveCount);
        }
        this.unresolvedExports = module.exports();
        this.unresolvedOpens = module.opens();
        this.unresolvedUses = module.uses();
        this.unresolvedProvides = module.provides();
        if (this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
            this.scanForNullDefaultAnnotation(module);
        }
        if ((this.tagBits & 0x400000000000L) != 0L || this.environment.globalOptions.storeAnnotations) {
            this.setAnnotations(BinaryTypeBinding.createAnnotations(module.getAnnotations(), this.environment, null), true);
        }
    }

    private void scanForNullDefaultAnnotation(IBinaryModule binaryModule) {
        char[][] nonNullByDefaultAnnotationName = this.environment.getNonNullByDefaultAnnotationName();
        if (nonNullByDefaultAnnotationName == null) {
            return;
        }
        IBinaryAnnotation[] annotations = binaryModule.getAnnotations();
        if (annotations != null) {
            int nullness = 0;
            int length = annotations.length;
            int i2 = 0;
            while (i2 < length) {
                int typeBit;
                char[] annotationTypeName = annotations[i2].getTypeName();
                if (annotationTypeName[0] == 'L' && (typeBit = this.environment.getNullAnnotationBit(BinaryTypeBinding.signature2qualifiedTypeName(annotationTypeName))) == 128) {
                    nullness |= BinaryTypeBinding.getNonNullByDefaultValue(annotations[i2], this.environment);
                }
                ++i2;
            }
            this.defaultNullness = nullness;
        }
    }

    @Override
    public PlainPackageBinding[] getExports() {
        if (this.exportedPackages == null && this.unresolvedExports != null) {
            this.resolvePackages();
        }
        return super.getExports();
    }

    @Override
    public PlainPackageBinding[] getOpens() {
        if (this.openedPackages == null && this.unresolvedOpens != null) {
            this.resolvePackages();
        }
        return super.getOpens();
    }

    private void resolvePackages() {
        PlainPackageBinding declaredPackage;
        this.exportedPackages = new PlainPackageBinding[this.unresolvedExports.length];
        int count = 0;
        int i2 = 0;
        while (i2 < this.unresolvedExports.length) {
            IModule.IPackageExport export = this.unresolvedExports[i2];
            declaredPackage = this.getOrCreateDeclaredPackage(CharOperation.splitOn('.', export.name()));
            this.exportedPackages[count++] = declaredPackage;
            declaredPackage.isExported = Boolean.TRUE;
            this.recordExportRestrictions(declaredPackage, export.targets());
            ++i2;
        }
        if (count < this.exportedPackages.length) {
            this.exportedPackages = new PlainPackageBinding[count];
            System.arraycopy(this.exportedPackages, 0, this.exportedPackages, 0, count);
        }
        this.openedPackages = new PlainPackageBinding[this.unresolvedOpens.length];
        count = 0;
        i2 = 0;
        while (i2 < this.unresolvedOpens.length) {
            IModule.IPackageExport opens = this.unresolvedOpens[i2];
            declaredPackage = this.getOrCreateDeclaredPackage(CharOperation.splitOn('.', opens.name()));
            this.openedPackages[count++] = declaredPackage;
            this.recordOpensRestrictions(declaredPackage, opens.targets());
            ++i2;
        }
        if (count < this.openedPackages.length) {
            this.openedPackages = new PlainPackageBinding[count];
            System.arraycopy(this.openedPackages, 0, this.openedPackages, 0, count);
        }
    }

    @Override
    PlainPackageBinding getDeclaredPackage(char[] flatName) {
        this.getExports();
        this.completeIfNeeded(IUpdatableModule.UpdateKind.PACKAGE);
        return super.getDeclaredPackage(flatName);
    }

    @Override
    public TypeBinding[] getUses() {
        if (this.uses == null) {
            this.uses = new TypeBinding[this.unresolvedUses.length];
            int i2 = 0;
            while (i2 < this.unresolvedUses.length) {
                this.uses[i2] = this.environment.getType(CharOperation.splitOn('.', this.unresolvedUses[i2]), this);
                ++i2;
            }
        }
        return super.getUses();
    }

    @Override
    public TypeBinding[] getServices() {
        if (this.services == null) {
            this.resolveServices();
        }
        return super.getServices();
    }

    @Override
    public TypeBinding[] getImplementations(TypeBinding binding) {
        if (this.implementations == null) {
            this.resolveServices();
        }
        return super.getImplementations(binding);
    }

    private void resolveServices() {
        this.services = new TypeBinding[this.unresolvedProvides.length];
        this.implementations = new HashMap();
        int i2 = 0;
        while (i2 < this.unresolvedProvides.length) {
            this.services[i2] = this.environment.getType(CharOperation.splitOn('.', this.unresolvedProvides[i2].name()), this);
            char[][] implNames = this.unresolvedProvides[i2].with();
            TypeBinding[] impls = new TypeBinding[implNames.length];
            int j = 0;
            while (j < implNames.length) {
                impls[j] = this.environment.getType(CharOperation.splitOn('.', implNames[j]), this);
                ++j;
            }
            this.implementations.put(this.services[i2], impls);
            ++i2;
        }
    }

    @Override
    public AnnotationBinding[] getAnnotations() {
        return this.retrieveAnnotations(this);
    }

    private static class AutomaticModuleBinding
    extends ModuleBinding {
        boolean autoNameFromManifest;
        boolean hasScannedPackages;

        public AutomaticModuleBinding(IModule module, LookupEnvironment existingEnvironment) {
            super(module.name(), existingEnvironment);
            existingEnvironment.root.knownModules.put(this.moduleName, this);
            this.isAuto = true;
            this.autoNameFromManifest = module.isAutoNameFromManifest();
            this.requires = Binding.NO_MODULES;
            this.requiresTransitive = Binding.NO_MODULES;
            this.exportedPackages = Binding.NO_PLAIN_PACKAGES;
            this.hasScannedPackages = false;
        }

        @Override
        public boolean hasUnstableAutoName() {
            return !this.autoNameFromManifest;
        }

        @Override
        public ModuleBinding[] getRequiresTransitive() {
            if (this.requiresTransitive == NO_MODULES) {
                char[][] autoModules = ((IModuleAwareNameEnvironment)this.environment.nameEnvironment).getAllAutomaticModules();
                this.requiresTransitive = (ModuleBinding[])Stream.of(autoModules).filter(name2 -> !CharOperation.equals(name2, this.moduleName)).map(name2 -> this.environment.getModule((char[])name2)).filter(m -> m != null).toArray(ModuleBinding[]::new);
            }
            return this.requiresTransitive;
        }

        @Override
        PlainPackageBinding getDeclaredPackage(char[] flatName) {
            if (!this.hasScannedPackages) {
                char[][] cArray = ((IModuleAwareNameEnvironment)this.environment.nameEnvironment).listPackages(this.nameForCUCheck());
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char[] packageName = cArray[n2];
                    this.getOrCreateDeclaredPackage(CharOperation.splitOn('.', packageName));
                    ++n2;
                }
                this.hasScannedPackages = true;
            }
            return (PlainPackageBinding)this.declaredPackages.get(flatName);
        }

        @Override
        public char[] nameForLookup() {
            return ANY_NAMED;
        }

        @Override
        public char[] nameForCUCheck() {
            return this.moduleName;
        }
    }
}

