/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.compiler.ast;

import paper.libs.org.eclipse.jdt.core.compiler.CharOperation;
import paper.libs.org.eclipse.jdt.internal.compiler.ASTVisitor;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.Expression;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import paper.libs.org.eclipse.jdt.internal.compiler.impl.Constant;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.Binding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.Scope;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class JavadocAllocationExpression
extends AllocationExpression {
    public int tagSourceStart;
    public int tagSourceEnd;
    public int tagValue;
    public int memberStart;
    public char[][] qualification;

    public JavadocAllocationExpression(int start, int end) {
        this.sourceStart = start;
        this.sourceEnd = end;
        this.bits |= 0x8000;
    }

    public JavadocAllocationExpression(long pos) {
        this((int)(pos >>> 32), (int)pos);
    }

    TypeBinding internalResolveType(Scope scope) {
        int length;
        this.constant = Constant.NotAConstant;
        this.resolvedType = this.type == null ? scope.enclosingSourceType() : (scope.kind == 3 ? this.type.resolveType((ClassScope)scope) : this.type.resolveType((BlockScope)scope, true));
        this.argumentTypes = Binding.NO_PARAMETERS;
        boolean hasTypeVarArgs = false;
        if (this.arguments != null) {
            this.argumentsHaveErrors = false;
            int length2 = this.arguments.length;
            this.argumentTypes = new TypeBinding[length2];
            int i2 = 0;
            while (i2 < length2) {
                Expression argument = this.arguments[i2];
                this.argumentTypes[i2] = scope.kind == 3 ? argument.resolveType((ClassScope)scope) : argument.resolveType((BlockScope)scope);
                if (this.argumentTypes[i2] == null) {
                    this.argumentsHaveErrors = true;
                } else if (!hasTypeVarArgs) {
                    hasTypeVarArgs = this.argumentTypes[i2].isTypeVariable();
                }
                ++i2;
            }
            if (this.argumentsHaveErrors) {
                return null;
            }
        }
        if (this.resolvedType == null) {
            return null;
        }
        this.resolvedType = scope.environment().convertToRawType(this.type.resolvedType, true);
        SourceTypeBinding enclosingType = scope.enclosingSourceType();
        if (enclosingType != null && enclosingType.isCompatibleWith(this.resolvedType)) {
            this.bits |= 0x4000;
        }
        ReferenceBinding allocationType = (ReferenceBinding)this.resolvedType;
        this.binding = scope.getConstructor(allocationType, this.argumentTypes, this);
        if (!this.binding.isValidBinding()) {
            ReferenceBinding enclosingTypeBinding = allocationType;
            MethodBinding contructorBinding = this.binding;
            while (!contructorBinding.isValidBinding() && (enclosingTypeBinding.isMemberType() || enclosingTypeBinding.isLocalType())) {
                enclosingTypeBinding = enclosingTypeBinding.enclosingType();
                contructorBinding = scope.getConstructor(enclosingTypeBinding, this.argumentTypes, this);
            }
            if (contructorBinding.isValidBinding()) {
                this.binding = contructorBinding;
            }
        }
        if (!this.binding.isValidBinding()) {
            MethodBinding methodBinding = scope.getMethod(this.resolvedType, this.resolvedType.sourceName(), this.argumentTypes, this);
            if (methodBinding.isValidBinding()) {
                this.binding = methodBinding;
            } else {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = allocationType;
                }
                scope.problemReporter().javadocInvalidConstructor(this, this.binding, scope.getDeclarationModifiers());
            }
            return this.resolvedType;
        }
        if (this.binding.isVarargs()) {
            int length3 = this.argumentTypes.length;
            if (this.binding.parameters.length != length3 || !this.argumentTypes[length3 - 1].isArrayType()) {
                ProblemMethodBinding problem = new ProblemMethodBinding(this.binding, this.binding.selector, this.argumentTypes, 1);
                scope.problemReporter().javadocInvalidConstructor(this, problem, scope.getDeclarationModifiers());
            }
        } else if (hasTypeVarArgs) {
            ProblemMethodBinding problem = new ProblemMethodBinding(this.binding, this.binding.selector, this.argumentTypes, 1);
            scope.problemReporter().javadocInvalidConstructor(this, problem, scope.getDeclarationModifiers());
        } else if (this.binding instanceof ParameterizedMethodBinding) {
            ParameterizedMethodBinding paramMethodBinding = (ParameterizedMethodBinding)this.binding;
            if (paramMethodBinding.hasSubstitutedParameters()) {
                int length4 = this.argumentTypes.length;
                int i3 = 0;
                while (i3 < length4) {
                    if (TypeBinding.notEquals(paramMethodBinding.parameters[i3], this.argumentTypes[i3]) && TypeBinding.notEquals(paramMethodBinding.parameters[i3].erasure(), this.argumentTypes[i3].erasure())) {
                        ProblemMethodBinding problem = new ProblemMethodBinding(this.binding, this.binding.selector, this.argumentTypes, 1);
                        scope.problemReporter().javadocInvalidConstructor(this, problem, scope.getDeclarationModifiers());
                        break;
                    }
                    ++i3;
                }
            }
        } else if (this.resolvedType.isMemberType() && (length = this.qualification.length) > 1) {
            ReferenceBinding enclosingTypeBinding = allocationType;
            if (this.type instanceof JavadocQualifiedTypeReference && ((JavadocQualifiedTypeReference)this.type).tokens.length != length) {
                scope.problemReporter().javadocInvalidMemberTypeQualification(this.memberStart + 1, this.sourceEnd, scope.getDeclarationModifiers());
            } else {
                int idx = length;
                while (idx > 0 && CharOperation.equals(this.qualification[--idx], enclosingTypeBinding.sourceName) && (enclosingTypeBinding = enclosingTypeBinding.enclosingType()) != null) {
                }
                if (idx > 0 || enclosingTypeBinding != null) {
                    scope.problemReporter().javadocInvalidMemberTypeQualification(this.memberStart + 1, this.sourceEnd, scope.getDeclarationModifiers());
                }
            }
        }
        if (this.isMethodUseDeprecated(this.binding, scope, true, this)) {
            scope.problemReporter().javadocDeprecatedMethod(this.binding, this, scope.getDeclarationModifiers());
        }
        return allocationType;
    }

    @Override
    public boolean isSuperAccess() {
        return (this.bits & 0x4000) != 0;
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        return this.internalResolveType(scope);
    }

    @Override
    public TypeBinding resolveType(ClassScope scope) {
        return this.internalResolveType(scope);
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            int i2;
            if (this.typeArguments != null) {
                i2 = 0;
                int typeArgumentsLength = this.typeArguments.length;
                while (i2 < typeArgumentsLength) {
                    this.typeArguments[i2].traverse(visitor, scope);
                    ++i2;
                }
            }
            if (this.type != null) {
                this.type.traverse(visitor, scope);
            }
            if (this.arguments != null) {
                i2 = 0;
                int argumentsLength = this.arguments.length;
                while (i2 < argumentsLength) {
                    this.arguments[i2].traverse(visitor, scope);
                    ++i2;
                }
            }
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public void traverse(ASTVisitor visitor, ClassScope scope) {
        if (visitor.visit(this, scope)) {
            int i2;
            if (this.typeArguments != null) {
                i2 = 0;
                int typeArgumentsLength = this.typeArguments.length;
                while (i2 < typeArgumentsLength) {
                    this.typeArguments[i2].traverse(visitor, scope);
                    ++i2;
                }
            }
            if (this.type != null) {
                this.type.traverse(visitor, scope);
            }
            if (this.arguments != null) {
                i2 = 0;
                int argumentsLength = this.arguments.length;
                while (i2 < argumentsLength) {
                    this.arguments[i2].traverse(visitor, scope);
                    ++i2;
                }
            }
        }
        visitor.endVisit(this, scope);
    }
}

