/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import paper.libs.org.eclipse.jdt.core.dom.AST;
import paper.libs.org.eclipse.jdt.core.dom.ASTMatcher;
import paper.libs.org.eclipse.jdt.core.dom.ASTNode;
import paper.libs.org.eclipse.jdt.core.dom.ASTVisitor;
import paper.libs.org.eclipse.jdt.core.dom.Annotation;
import paper.libs.org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import paper.libs.org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import paper.libs.org.eclipse.jdt.core.dom.Expression;
import paper.libs.org.eclipse.jdt.core.dom.IExtendedModifier;
import paper.libs.org.eclipse.jdt.core.dom.Modifier;
import paper.libs.org.eclipse.jdt.core.dom.PrimitiveType;
import paper.libs.org.eclipse.jdt.core.dom.SimpleName;
import paper.libs.org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import paper.libs.org.eclipse.jdt.core.dom.Type;
import paper.libs.org.eclipse.jdt.core.dom.VariableDeclaration;

public class SingleVariableDeclaration
extends VariableDeclaration {
    public static final SimplePropertyDescriptor MODIFIERS_PROPERTY = new SimplePropertyDescriptor(SingleVariableDeclaration.class, "modifiers", Integer.TYPE, true);
    public static final ChildListPropertyDescriptor MODIFIERS2_PROPERTY = new ChildListPropertyDescriptor(SingleVariableDeclaration.class, "modifiers", IExtendedModifier.class, true);
    public static final ChildPropertyDescriptor TYPE_PROPERTY = new ChildPropertyDescriptor(SingleVariableDeclaration.class, "type", Type.class, true, false);
    public static final ChildListPropertyDescriptor VARARGS_ANNOTATIONS_PROPERTY = new ChildListPropertyDescriptor(SingleVariableDeclaration.class, "varargsAnnotations", Annotation.class, true);
    public static final SimplePropertyDescriptor VARARGS_PROPERTY = new SimplePropertyDescriptor(SingleVariableDeclaration.class, "varargs", Boolean.TYPE, true);
    public static final ChildPropertyDescriptor NAME_PROPERTY = SingleVariableDeclaration.internalNamePropertyFactory(SingleVariableDeclaration.class);
    public static final SimplePropertyDescriptor EXTRA_DIMENSIONS_PROPERTY = SingleVariableDeclaration.internalExtraDimensionsPropertyFactory(SingleVariableDeclaration.class);
    public static final ChildListPropertyDescriptor EXTRA_DIMENSIONS2_PROPERTY = SingleVariableDeclaration.internalExtraDimensions2PropertyFactory(SingleVariableDeclaration.class);
    public static final ChildPropertyDescriptor INITIALIZER_PROPERTY = SingleVariableDeclaration.internalInitializerPropertyFactory(SingleVariableDeclaration.class);
    private static final List PROPERTY_DESCRIPTORS_2_0;
    private static final List PROPERTY_DESCRIPTORS_3_0;
    private static final List PROPERTY_DESCRIPTORS_8_0;
    private ASTNode.NodeList modifiers = null;
    private int modifierFlags = 0;
    private Type type = null;
    private ASTNode.NodeList varargsAnnotations = null;
    private boolean variableArity = false;

    static {
        ArrayList propertyList = new ArrayList(6);
        SingleVariableDeclaration.createPropertyList(SingleVariableDeclaration.class, propertyList);
        SingleVariableDeclaration.addProperty(MODIFIERS_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(TYPE_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(NAME_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(EXTRA_DIMENSIONS_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(INITIALIZER_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_2_0 = SingleVariableDeclaration.reapPropertyList(propertyList);
        propertyList = new ArrayList(7);
        SingleVariableDeclaration.createPropertyList(SingleVariableDeclaration.class, propertyList);
        SingleVariableDeclaration.addProperty(MODIFIERS2_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(TYPE_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(VARARGS_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(NAME_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(EXTRA_DIMENSIONS_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(INITIALIZER_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_3_0 = SingleVariableDeclaration.reapPropertyList(propertyList);
        propertyList = new ArrayList(8);
        SingleVariableDeclaration.createPropertyList(SingleVariableDeclaration.class, propertyList);
        SingleVariableDeclaration.addProperty(MODIFIERS2_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(TYPE_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(VARARGS_ANNOTATIONS_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(VARARGS_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(NAME_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(EXTRA_DIMENSIONS2_PROPERTY, propertyList);
        SingleVariableDeclaration.addProperty(INITIALIZER_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_8_0 = SingleVariableDeclaration.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        if (apiLevel == 2) {
            return PROPERTY_DESCRIPTORS_2_0;
        }
        if (apiLevel < 8) {
            return PROPERTY_DESCRIPTORS_3_0;
        }
        return PROPERTY_DESCRIPTORS_8_0;
    }

    SingleVariableDeclaration(AST ast) {
        super(ast);
        if (ast.apiLevel >= 3) {
            this.modifiers = new ASTNode.NodeList(MODIFIERS2_PROPERTY);
            if (ast.apiLevel >= 8) {
                this.varargsAnnotations = new ASTNode.NodeList(VARARGS_ANNOTATIONS_PROPERTY);
            }
        }
    }

    @Override
    final ChildPropertyDescriptor internalNameProperty() {
        return NAME_PROPERTY;
    }

    @Override
    final SimplePropertyDescriptor internalExtraDimensionsProperty() {
        return EXTRA_DIMENSIONS_PROPERTY;
    }

    @Override
    final ChildListPropertyDescriptor internalExtraDimensions2Property() {
        return EXTRA_DIMENSIONS2_PROPERTY;
    }

    @Override
    final ChildPropertyDescriptor internalInitializerProperty() {
        return INITIALIZER_PROPERTY;
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return SingleVariableDeclaration.propertyDescriptors(apiLevel);
    }

    @Override
    final int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == MODIFIERS_PROPERTY) {
            if (get) {
                return this.getModifiers();
            }
            this.setModifiers(value);
            return 0;
        }
        if (property == EXTRA_DIMENSIONS_PROPERTY) {
            if (get) {
                return this.getExtraDimensions();
            }
            this.internalSetExtraDimensions(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == VARARGS_PROPERTY) {
            if (get) {
                return this.isVarargs();
            }
            this.setVarargs(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == TYPE_PROPERTY) {
            if (get) {
                return this.getType();
            }
            this.setType((Type)child);
            return null;
        }
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((SimpleName)child);
            return null;
        }
        if (property == INITIALIZER_PROPERTY) {
            if (get) {
                return this.getInitializer();
            }
            this.setInitializer((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == MODIFIERS2_PROPERTY) {
            return this.modifiers();
        }
        if (property == VARARGS_ANNOTATIONS_PROPERTY) {
            return this.varargsAnnotations();
        }
        if (property == EXTRA_DIMENSIONS2_PROPERTY) {
            return this.extraDimensions();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final int getNodeType0() {
        return 44;
    }

    @Override
    ASTNode clone0(AST target) {
        SingleVariableDeclaration result = new SingleVariableDeclaration(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        if (this.ast.apiLevel == 2) {
            result.setModifiers(this.getModifiers());
        } else {
            result.modifiers().addAll(ASTNode.copySubtrees(target, this.modifiers()));
            result.setVarargs(this.isVarargs());
        }
        result.setType((Type)this.getType().clone(target));
        if (this.ast.apiLevel >= 8) {
            result.varargsAnnotations().addAll(ASTNode.copySubtrees(target, this.varargsAnnotations()));
        }
        result.setName((SimpleName)this.getName().clone(target));
        if (this.ast.apiLevel >= 8) {
            result.extraDimensions().addAll(ASTNode.copySubtrees(target, this.extraDimensions()));
        } else {
            result.internalSetExtraDimensions(this.getExtraDimensions());
        }
        result.setInitializer((Expression)ASTNode.copySubtree(target, this.getInitializer()));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.ast.apiLevel >= 3) {
                this.acceptChildren(visitor, this.modifiers);
            }
            this.acceptChild(visitor, this.getType());
            if (this.ast.apiLevel >= 8 && this.isVarargs()) {
                this.acceptChildren(visitor, this.varargsAnnotations);
            }
            this.acceptChild(visitor, this.getName());
            if (this.ast.apiLevel >= 8) {
                this.acceptChildren(visitor, this.extraDimensions);
            }
            this.acceptChild(visitor, this.getInitializer());
        }
        visitor.endVisit(this);
    }

    public List modifiers() {
        if (this.modifiers == null) {
            this.unsupportedIn2();
        }
        return this.modifiers;
    }

    public int getModifiers() {
        if (this.modifiers == null) {
            return this.modifierFlags;
        }
        int computedModifierFlags = 0;
        for (Object x : this.modifiers()) {
            if (!(x instanceof Modifier)) continue;
            computedModifierFlags |= ((Modifier)x).getKeyword().toFlagValue();
        }
        return computedModifierFlags;
    }

    public void setModifiers(int modifiers) {
        this.internalSetModifiers(modifiers);
    }

    final void internalSetModifiers(int pmodifiers) {
        this.supportedOnlyIn2();
        this.preValueChange(MODIFIERS_PROPERTY);
        this.modifierFlags = pmodifiers;
        this.postValueChange(MODIFIERS_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getType() {
        if (this.type == null) {
            SingleVariableDeclaration singleVariableDeclaration = this;
            synchronized (singleVariableDeclaration) {
                if (this.type == null) {
                    this.preLazyInit();
                    this.type = this.ast.newPrimitiveType(PrimitiveType.INT);
                    this.postLazyInit(this.type, TYPE_PROPERTY);
                }
            }
        }
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        Type oldChild = this.type;
        this.preReplaceChild(oldChild, type, TYPE_PROPERTY);
        this.type = type;
        this.postReplaceChild(oldChild, type, TYPE_PROPERTY);
    }

    public boolean isVarargs() {
        if (this.modifiers == null) {
            this.unsupportedIn2();
        }
        return this.variableArity;
    }

    public void setVarargs(boolean variableArity) {
        if (this.modifiers == null) {
            this.unsupportedIn2();
        }
        this.preValueChange(VARARGS_PROPERTY);
        this.variableArity = variableArity;
        this.postValueChange(VARARGS_PROPERTY);
    }

    public List varargsAnnotations() {
        if (this.varargsAnnotations == null) {
            this.unsupportedIn2_3_4();
        }
        return this.varargsAnnotations;
    }

    @Override
    int memSize() {
        return 76;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.modifiers == null ? 0 : this.modifiers.listSize()) + (this.type == null ? 0 : this.getType().treeSize()) + (this.varargsAnnotations == null ? 0 : this.varargsAnnotations.listSize()) + (this.variableName == null ? 0 : this.getName().treeSize()) + (this.extraDimensions == null ? 0 : this.extraDimensions.listSize()) + (this.optionalInitializer == null ? 0 : this.getInitializer().treeSize());
    }
}

