/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import paper.libs.org.eclipse.core.resources.IWorkspace;
import paper.libs.org.eclipse.core.resources.ResourcesPlugin;
import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.core.runtime.IStatus;
import paper.libs.org.eclipse.core.runtime.Status;
import paper.libs.org.eclipse.jdt.core.IClasspathEntry;
import paper.libs.org.eclipse.jdt.core.IJavaModelStatus;
import paper.libs.org.eclipse.jdt.core.IJavaProject;
import paper.libs.org.eclipse.jdt.core.compiler.CharOperation;
import paper.libs.org.eclipse.jdt.core.compiler.InvalidInputException;
import paper.libs.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import paper.libs.org.eclipse.jdt.internal.compiler.parser.Scanner;
import paper.libs.org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import paper.libs.org.eclipse.jdt.internal.compiler.util.Util;
import paper.libs.org.eclipse.jdt.internal.core.ClasspathEntry;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelStatus;
import paper.libs.org.eclipse.jdt.internal.core.util.Messages;

public final class JavaConventions {
    private static final char DOT = '.';
    private static final Pattern DOT_DOT = Pattern.compile("(\\.)(\\1)+");
    private static final Pattern PREFIX_JAVA = Pattern.compile("java$");
    private static final Scanner SCANNER = new Scanner(false, true, false, 0x2F0000L, null, null, true);
    private static Map<String, Set<String>> restrictedIdentifiersMap;
    private static Map<String, Set<String>> restrictedIdentifierPreviewMap;
    private static List<String> javaVersions;
    private static String VAR_ID;
    private static String YIELD_ID;
    private static String RECORD_ID;

    static {
        VAR_ID = "var";
        YIELD_ID = "yield";
        RECORD_ID = "record";
        javaVersions = new ArrayList<String>();
        javaVersions.add(0, "10");
        javaVersions.add(1, "11");
        javaVersions.add(2, "12");
        javaVersions.add(3, "13");
        javaVersions.add(4, "14");
        restrictedIdentifiersMap = new HashMap<String, Set<String>>();
        HashSet<String> set = new HashSet<String>();
        set.add(new String(VAR_ID));
        restrictedIdentifiersMap.put("10", set);
        set = new HashSet();
        set.add(new String(YIELD_ID));
        restrictedIdentifiersMap.put("14", set);
        restrictedIdentifierPreviewMap = new HashMap<String, Set<String>>();
        set = new HashSet();
        set.add(new String(RECORD_ID));
        restrictedIdentifierPreviewMap.put("14", set);
    }

    private JavaConventions() {
    }

    public static boolean isOverlappingRoots(IPath rootPath1, IPath rootPath2) {
        if (rootPath1 == null || rootPath2 == null) {
            return false;
        }
        return rootPath1.isPrefixOf(rootPath2) || rootPath2.isPrefixOf(rootPath1);
    }

    private static synchronized char[] scannedIdentifier(String id, String sourceLevel, String complianceLevel) {
        return JavaConventions.scannedIdentifier(id, sourceLevel, complianceLevel, null, true);
    }

    private static synchronized char[] scannedIdentifier(String id, String sourceLevel, String complianceLevel, String previewEnabled, boolean allowRestrictedKeyWords) {
        block7: {
            if (id == null) {
                return null;
            }
            JavaConventions.SCANNER.sourceLevel = sourceLevel == null ? 0x2F0000L : CompilerOptions.versionToJdkLevel(sourceLevel);
            JavaConventions.SCANNER.complianceLevel = complianceLevel == null ? 0x2F0000L : CompilerOptions.versionToJdkLevel(complianceLevel);
            JavaConventions.SCANNER.previewEnabled = previewEnabled == null ? false : "enabled".equals(previewEnabled);
            try {
                SCANNER.setSource(id.toCharArray());
                int token = SCANNER.scanIdentifier();
                if (token == 22) break block7;
                return null;
            }
            catch (InvalidInputException invalidInputException) {
                return null;
            }
        }
        if (JavaConventions.SCANNER.currentPosition == JavaConventions.SCANNER.eofPosition) {
            try {
                char[] src = SCANNER.getCurrentIdentifierSource();
                src = JavaConventions.scanForRestrictedKeyWords(src, sourceLevel, complianceLevel, JavaConventions.SCANNER.previewEnabled, allowRestrictedKeyWords);
                return src;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }
        return null;
    }

    private static char[] scanForRestrictedKeyWords(char[] id, String sourceLevel, String complianceLevel, boolean previewEnabled, boolean allowRestrictedKeyWords) {
        if (allowRestrictedKeyWords) {
            return id;
        }
        int index = javaVersions.indexOf(sourceLevel);
        String searchId = new String(id);
        int i2 = index;
        while (i2 >= 0) {
            String level = javaVersions.get(i2);
            if (level != null) {
                Set<String> prIds;
                Set<String> rIds = restrictedIdentifiersMap.get(level);
                if (rIds != null && rIds.contains(searchId)) {
                    return null;
                }
                if (previewEnabled && (prIds = restrictedIdentifierPreviewMap.get(level)) != null && prIds.contains(searchId)) {
                    return null;
                }
            }
            --i2;
        }
        return id;
    }

    public static IStatus validateCompilationUnitName(String name2) {
        return JavaConventions.validateCompilationUnitName(name2, "1.3", "1.3");
    }

    public static IStatus validateCompilationUnitName(String name2, String sourceLevel, String complianceLevel) {
        IStatus status;
        if (name2 == null) {
            return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_unit_nullName, null);
        }
        if (!paper.libs.org.eclipse.jdt.internal.core.util.Util.isJavaLikeFileName(name2)) {
            return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_unit_notJavaName, null);
        }
        int index = name2.lastIndexOf(46);
        if (index == -1) {
            return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_unit_notJavaName, null);
        }
        String identifier = name2.substring(0, index);
        if (!(CharOperation.equals(identifier.toCharArray(), TypeConstants.PACKAGE_INFO_NAME) || CharOperation.equals(identifier.toCharArray(), TypeConstants.MODULE_INFO_NAME) || (status = JavaConventions.validateIdentifier(identifier, sourceLevel, complianceLevel)).isOK())) {
            return status;
        }
        status = ResourcesPlugin.getWorkspace().validateName(name2, 1);
        if (!status.isOK()) {
            return status;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static IStatus validateClassFileName(String name2) {
        return JavaConventions.validateClassFileName(name2, "1.3", "1.3");
    }

    public static IStatus validateClassFileName(String name2, String sourceLevel, String complianceLevel) {
        IStatus status;
        if (name2 == null) {
            return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_classFile_nullName, null);
        }
        if (!Util.isClassFileName(name2)) {
            return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_classFile_notClassFileName, null);
        }
        int index = name2.lastIndexOf(46);
        if (index == -1) {
            return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_classFile_notClassFileName, null);
        }
        String identifier = name2.substring(0, index);
        if (!(CharOperation.equals(identifier.toCharArray(), TypeConstants.PACKAGE_INFO_NAME) || CharOperation.equals(identifier.toCharArray(), TypeConstants.MODULE_INFO_NAME) || (status = JavaConventions.validateIdentifier(identifier, sourceLevel, complianceLevel)).isOK())) {
            return status;
        }
        status = ResourcesPlugin.getWorkspace().validateName(name2, 1);
        if (!status.isOK()) {
            return status;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static IStatus validateFieldName(String name2) {
        return JavaConventions.validateIdentifier(name2, "1.3", "1.3");
    }

    public static IStatus validateFieldName(String name2, String sourceLevel, String complianceLevel) {
        return JavaConventions.validateIdentifier(name2, sourceLevel, complianceLevel);
    }

    public static IStatus validateIdentifier(String id) {
        return JavaConventions.validateIdentifier(id, "1.3", "1.3");
    }

    public static IStatus validateIdentifier(String id, String sourceLevel, String complianceLevel) {
        if (JavaConventions.scannedIdentifier(id, sourceLevel, complianceLevel) != null) {
            return JavaModelStatus.VERIFIED_OK;
        }
        return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.bind(Messages.convention_illegalIdentifier, id), null);
    }

    public static IStatus validateImportDeclaration(String name2) {
        return JavaConventions.validateImportDeclaration(name2, "1.3", "1.3");
    }

    public static IStatus validateImportDeclaration(String name2, String sourceLevel, String complianceLevel) {
        if (name2 == null || name2.length() == 0) {
            return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_import_nullImport, null);
        }
        if (name2.charAt(name2.length() - 1) == '*') {
            if (name2.charAt(name2.length() - 2) == '.') {
                return JavaConventions.validatePackageName(name2.substring(0, name2.length() - 2), sourceLevel, complianceLevel);
            }
            return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_import_unqualifiedImport, null);
        }
        return JavaConventions.validatePackageName(name2, sourceLevel, complianceLevel);
    }

    public static IStatus validateJavaTypeName(String name2) {
        return JavaConventions.validateJavaTypeName(name2, "1.3", "1.3");
    }

    public static IStatus validateJavaTypeName(String name2, String sourceLevel, String complianceLevel) {
        return JavaConventions.internalValidateJavaTypeName(name2, sourceLevel, complianceLevel, null);
    }

    public static IStatus validateJavaTypeName(String name2, String sourceLevel, String complianceLevel, String previewEnabled) {
        return JavaConventions.internalValidateJavaTypeName(name2, sourceLevel, complianceLevel, previewEnabled);
    }

    private static IStatus internalValidateJavaTypeName(String name2, String sourceLevel, String complianceLevel, String previewEnabled) {
        char[] scannedID;
        if (name2 == null) {
            return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_type_nullName, null);
        }
        String trimmed = name2.trim();
        if (!name2.equals(trimmed)) {
            return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_type_nameWithBlanks, null);
        }
        int index = name2.lastIndexOf(46);
        if (index == -1) {
            scannedID = JavaConventions.scannedIdentifier(name2, sourceLevel, complianceLevel, previewEnabled, false);
        } else {
            String pkg = name2.substring(0, index).trim();
            IStatus status = JavaConventions.validatePackageName(pkg, sourceLevel, complianceLevel);
            if (!status.isOK()) {
                return status;
            }
            String type = name2.substring(index + 1).trim();
            scannedID = JavaConventions.scannedIdentifier(type, sourceLevel, complianceLevel, previewEnabled, false);
        }
        if (scannedID != null) {
            IStatus status = ResourcesPlugin.getWorkspace().validateName(new String(scannedID), 1);
            if (!status.isOK()) {
                return status;
            }
            if (CharOperation.contains('$', scannedID)) {
                return new Status(2, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_type_dollarName, null);
            }
            if (scannedID.length > 0 && ScannerHelper.isLowerCase(scannedID[0])) {
                return new Status(2, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_type_lowercaseName, null);
            }
            return JavaModelStatus.VERIFIED_OK;
        }
        return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.bind(Messages.convention_type_invalidName, name2), null);
    }

    public static IStatus validateMethodName(String name2) {
        return JavaConventions.validateMethodName(name2, "1.3", "1.3");
    }

    public static IStatus validateMethodName(String name2, String sourceLevel, String complianceLevel) {
        return JavaConventions.validateIdentifier(name2, sourceLevel, complianceLevel);
    }

    public static IStatus validatePackageName(String name2) {
        return JavaConventions.validatePackageName(name2, "1.3", "1.3");
    }

    public static IStatus validatePackageName(String name2, String sourceLevel, String complianceLevel) {
        if (name2 == null) {
            return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_package_nullName, null);
        }
        int length = name2.length();
        if (length == 0) {
            return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_package_emptyName, null);
        }
        if (name2.charAt(0) == '.' || name2.charAt(length - 1) == '.') {
            return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_package_dotName, null);
        }
        if (CharOperation.isWhitespace(name2.charAt(0)) || CharOperation.isWhitespace(name2.charAt(name2.length() - 1))) {
            return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_package_nameWithBlanks, null);
        }
        if (DOT_DOT.matcher(name2).find()) {
            return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_package_consecutiveDotsName, null);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        StringTokenizer st = new StringTokenizer(name2, ".");
        boolean firstToken = true;
        Status warningStatus = null;
        while (st.hasMoreTokens()) {
            String typeName = st.nextToken();
            char[] scannedID = JavaConventions.scannedIdentifier(typeName = typeName.trim(), sourceLevel, complianceLevel);
            if (scannedID == null) {
                return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.bind(Messages.convention_illegalIdentifier, typeName), null);
            }
            IStatus status = workspace.validateName(new String(scannedID), 2);
            if (!status.isOK()) {
                return status;
            }
            if (firstToken && scannedID.length > 0 && ScannerHelper.isUpperCase(scannedID[0]) && warningStatus == null) {
                warningStatus = new Status(2, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_package_uppercaseName, null);
            }
            firstToken = false;
        }
        if (warningStatus != null) {
            return warningStatus;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static IStatus validateModuleName(String name2, String sourceLevel, String complianceLevel) {
        if (name2 == null) {
            return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_module_nullName, null);
        }
        int length = name2.length();
        if (length == 0) {
            return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_module_emptyName, null);
        }
        if (name2.charAt(0) == '.' || name2.charAt(length - 1) == '.') {
            return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_module_dotName, null);
        }
        if (CharOperation.isWhitespace(name2.charAt(0)) || CharOperation.isWhitespace(name2.charAt(name2.length() - 1))) {
            return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_module_nameWithBlanks, null);
        }
        if (DOT_DOT.matcher(name2).find()) {
            return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_module_consecutiveDotsName, null);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        StringTokenizer st = new StringTokenizer(name2, ".");
        boolean firstToken = true;
        Status warningStatus = null;
        while (st.hasMoreTokens()) {
            IStatus status;
            String segment = st.nextToken();
            char[] scannedID = JavaConventions.scannedIdentifier(segment = segment.trim(), sourceLevel, complianceLevel);
            if (scannedID == null) {
                return new Status(4, "paper.libs.org.eclipse.jdt.core", -1, Messages.bind(Messages.convention_illegalIdentifier, segment), null);
            }
            if (firstToken && PREFIX_JAVA.matcher(segment).find()) {
                warningStatus = new Status(2, "paper.libs.org.eclipse.jdt.core", -1, Messages.bind(Messages.convention_module_javaName), null);
            }
            if (!(status = workspace.validateName(new String(scannedID), 2)).isOK()) {
                return status;
            }
            if (firstToken && scannedID.length > 0 && ScannerHelper.isUpperCase(scannedID[0]) && warningStatus == null) {
                warningStatus = new Status(2, "paper.libs.org.eclipse.jdt.core", -1, Messages.convention_module_uppercaseName, null);
            }
            firstToken = false;
        }
        if (warningStatus != null) {
            return warningStatus;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static IJavaModelStatus validateClasspath(IJavaProject javaProject, IClasspathEntry[] rawClasspath, IPath projectOutputLocation) {
        return ClasspathEntry.validateClasspath(javaProject, rawClasspath, projectOutputLocation);
    }

    public static IJavaModelStatus validateClasspathEntry(IJavaProject project, IClasspathEntry entry, boolean checkSourceAttachment) {
        return ClasspathEntry.validateClasspathEntry(project, entry, checkSourceAttachment, false);
    }

    public static IStatus validateTypeVariableName(String name2) {
        return JavaConventions.validateIdentifier(name2, "1.3", "1.3");
    }

    public static IStatus validateTypeVariableName(String name2, String sourceLevel, String complianceLevel) {
        return JavaConventions.validateIdentifier(name2, sourceLevel, complianceLevel);
    }
}

