/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.runtime.jobs;

import java.util.ArrayList;
import java.util.Arrays;
import paper.libs.org.eclipse.core.runtime.jobs.ISchedulingRule;

public class MultiRule
implements ISchedulingRule {
    private ISchedulingRule[] rules;

    public static ISchedulingRule combine(ISchedulingRule[] ruleArray) {
        ISchedulingRule result = null;
        ISchedulingRule[] iSchedulingRuleArray = ruleArray;
        int n = ruleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISchedulingRule element = iSchedulingRuleArray[n2];
            if (element != null) {
                result = result == null ? element : MultiRule.combine(result, element);
            }
            ++n2;
        }
        return result;
    }

    public static ISchedulingRule combine(ISchedulingRule rule1, ISchedulingRule rule2) {
        if (rule1 == rule2) {
            return rule1;
        }
        if (rule1 == null) {
            return rule2;
        }
        if (rule2 == null) {
            return rule1;
        }
        if (rule1.contains(rule2)) {
            return rule1;
        }
        if (rule2.contains(rule1)) {
            return rule2;
        }
        MultiRule result = new MultiRule();
        result.rules = new ISchedulingRule[]{rule1, rule2};
        if (rule1 instanceof MultiRule || rule2 instanceof MultiRule) {
            result.rules = MultiRule.flatten(result.rules);
        }
        return result;
    }

    private static ISchedulingRule[] flatten(ISchedulingRule[] nestedRules) {
        ArrayList<ISchedulingRule> myRules = new ArrayList<ISchedulingRule>(nestedRules.length);
        ISchedulingRule[] iSchedulingRuleArray = nestedRules;
        int n = nestedRules.length;
        int n2 = 0;
        while (n2 < n) {
            ISchedulingRule nestedRule = iSchedulingRuleArray[n2];
            if (nestedRule instanceof MultiRule) {
                ISchedulingRule[] children = ((MultiRule)nestedRule).getChildren();
                myRules.addAll(Arrays.asList(children));
            } else {
                myRules.add(nestedRule);
            }
            ++n2;
        }
        return myRules.toArray(new ISchedulingRule[myRules.size()]);
    }

    public MultiRule(ISchedulingRule[] nestedRules) {
        this.rules = MultiRule.flatten(nestedRules);
    }

    private MultiRule() {
    }

    public ISchedulingRule[] getChildren() {
        return (ISchedulingRule[])this.rules.clone();
    }

    @Override
    public boolean contains(ISchedulingRule rule) {
        if (this == rule) {
            return true;
        }
        if (rule instanceof MultiRule) {
            ISchedulingRule[] otherRules;
            ISchedulingRule[] iSchedulingRuleArray = otherRules = ((MultiRule)rule).getChildren();
            int n = otherRules.length;
            int n2 = 0;
            while (n2 < n) {
                ISchedulingRule otherRule = iSchedulingRuleArray[n2];
                boolean found = false;
                int mine = 0;
                while (!found && mine < this.rules.length) {
                    found = this.rules[mine].contains(otherRule);
                    ++mine;
                }
                if (!found) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        ISchedulingRule[] iSchedulingRuleArray = this.rules;
        int n = this.rules.length;
        int n3 = 0;
        while (n3 < n) {
            ISchedulingRule rule2 = iSchedulingRuleArray[n3];
            if (rule2.contains(rule)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public boolean isConflicting(ISchedulingRule rule) {
        if (this == rule) {
            return true;
        }
        if (rule instanceof MultiRule) {
            ISchedulingRule[] otherRules;
            ISchedulingRule[] iSchedulingRuleArray = otherRules = ((MultiRule)rule).getChildren();
            int n = otherRules.length;
            int n2 = 0;
            while (n2 < n) {
                ISchedulingRule otherRule = iSchedulingRuleArray[n2];
                ISchedulingRule[] iSchedulingRuleArray2 = this.rules;
                int n3 = this.rules.length;
                int n4 = 0;
                while (n4 < n3) {
                    ISchedulingRule rule2 = iSchedulingRuleArray2[n4];
                    if (rule2.isConflicting(otherRule)) {
                        return true;
                    }
                    ++n4;
                }
                ++n2;
            }
        } else {
            ISchedulingRule[] iSchedulingRuleArray = this.rules;
            int n = this.rules.length;
            int n5 = 0;
            while (n5 < n) {
                ISchedulingRule rule3 = iSchedulingRuleArray[n5];
                if (rule3.isConflicting(rule)) {
                    return true;
                }
                ++n5;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("MultiRule[");
        int last = this.rules.length - 1;
        int i2 = 0;
        while (i2 < this.rules.length) {
            buffer.append(this.rules[i2]);
            if (i2 != last) {
                buffer.append(',');
            }
            ++i2;
        }
        buffer.append(']');
        return buffer.toString();
    }
}

