/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.registry;

import paper.libs.org.eclipse.core.internal.registry.KeyedElement;

public class KeyedHashSet {
    protected static final int MINIMUM_SIZE = 7;
    private final int capacity;
    protected int elementCount = 0;
    protected KeyedElement[] elements;
    protected final boolean replace;

    public KeyedHashSet() {
        this(7, true);
    }

    public KeyedHashSet(int capacity) {
        this(capacity, true);
    }

    public KeyedHashSet(int capacity, boolean replace) {
        this.elements = new KeyedElement[Math.max(7, capacity * 2)];
        this.replace = replace;
        this.capacity = capacity;
    }

    public boolean add(KeyedElement element) {
        int hash2;
        int i2 = hash2 = this.hash(element);
        while (i2 < this.elements.length) {
            if (this.elements[i2] == null) {
                this.elements[i2] = element;
                ++this.elementCount;
                if (this.shouldGrow()) {
                    this.expand();
                }
                return true;
            }
            if (this.elements[i2].compare(element)) {
                if (this.replace) {
                    this.elements[i2] = element;
                }
                return this.replace;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < hash2 - 1) {
            if (this.elements[i2] == null) {
                this.elements[i2] = element;
                ++this.elementCount;
                if (this.shouldGrow()) {
                    this.expand();
                }
                return true;
            }
            if (this.elements[i2].compare(element)) {
                if (this.replace) {
                    this.elements[i2] = element;
                }
                return this.replace;
            }
            ++i2;
        }
        this.expand();
        return this.add(element);
    }

    public void clear() {
        this.elements = new KeyedElement[Math.max(7, this.capacity * 2)];
        this.elementCount = 0;
    }

    public KeyedElement[] elements() {
        return (KeyedElement[])this.elements(new KeyedElement[this.elementCount]);
    }

    public Object[] elements(Object[] result) {
        int j = 0;
        KeyedElement[] keyedElementArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            KeyedElement element = keyedElementArray[n2];
            if (element != null) {
                result[j++] = element;
            }
            ++n2;
        }
        return result;
    }

    protected void expand() {
        KeyedElement[] oldElements = this.elements;
        this.elements = new KeyedElement[this.elements.length * 2];
        int maxArrayIndex = this.elements.length - 1;
        KeyedElement[] keyedElementArray = oldElements;
        int n = oldElements.length;
        int n2 = 0;
        while (n2 < n) {
            KeyedElement element = keyedElementArray[n2];
            if (element != null) {
                int hash2 = this.hash(element);
                while (this.elements[hash2] != null) {
                    if (++hash2 <= maxArrayIndex) continue;
                    hash2 = 0;
                }
                this.elements[hash2] = element;
            }
            ++n2;
        }
    }

    public KeyedElement get(KeyedElement key) {
        KeyedElement element;
        int hash2;
        if (this.elementCount == 0) {
            return null;
        }
        int i2 = hash2 = this.hash(key);
        while (i2 < this.elements.length) {
            element = this.elements[i2];
            if (element == null) {
                return null;
            }
            if (element.compare(key)) {
                return element;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < hash2 - 1) {
            element = this.elements[i2];
            if (element == null) {
                return null;
            }
            if (element.compare(key)) {
                return element;
            }
            ++i2;
        }
        return null;
    }

    public KeyedElement getByKey(Object key) {
        KeyedElement element;
        int hash2;
        if (this.elementCount == 0) {
            return null;
        }
        int i2 = hash2 = this.keyHash(key);
        while (i2 < this.elements.length) {
            element = this.elements[i2];
            if (element == null) {
                return null;
            }
            if (element.getKey().equals(key)) {
                return element;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < hash2 - 1) {
            element = this.elements[i2];
            if (element == null) {
                return null;
            }
            if (element.getKey().equals(key)) {
                return element;
            }
            ++i2;
        }
        return null;
    }

    private int hash(KeyedElement element) {
        return (element.getKeyHashCode() & Integer.MAX_VALUE) % this.elements.length;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    private int keyHash(Object key) {
        return (key.hashCode() & Integer.MAX_VALUE) % this.elements.length;
    }

    protected void rehashTo(int anIndex) {
        int target = anIndex;
        int index = anIndex + 1;
        if (index >= this.elements.length) {
            index = 0;
        }
        KeyedElement element = this.elements[index];
        while (element != null) {
            boolean match;
            int hashIndex = this.hash(element);
            if (index < target) {
                match = hashIndex <= target && hashIndex > index;
            } else {
                boolean bl = match = hashIndex <= target || hashIndex > index;
            }
            if (match) {
                this.elements[target] = element;
                target = index;
            }
            if (++index >= this.elements.length) {
                index = 0;
            }
            element = this.elements[index];
        }
        this.elements[target] = null;
    }

    public boolean remove(KeyedElement toRemove) {
        KeyedElement element;
        int hash2;
        if (this.elementCount == 0) {
            return false;
        }
        int i2 = hash2 = this.hash(toRemove);
        while (i2 < this.elements.length) {
            element = this.elements[i2];
            if (element == null) {
                return false;
            }
            if (element.compare(toRemove)) {
                this.rehashTo(i2);
                --this.elementCount;
                return true;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < hash2 - 1) {
            element = this.elements[i2];
            if (element == null) {
                return false;
            }
            if (element.compare(toRemove)) {
                this.rehashTo(i2);
                --this.elementCount;
                return true;
            }
            ++i2;
        }
        return false;
    }

    public boolean removeByKey(Object key) {
        KeyedElement element;
        int hash2;
        if (this.elementCount == 0) {
            return false;
        }
        int i2 = hash2 = this.keyHash(key);
        while (i2 < this.elements.length) {
            element = this.elements[i2];
            if (element == null) {
                return false;
            }
            if (element.getKey().equals(key)) {
                this.rehashTo(i2);
                --this.elementCount;
                return true;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < hash2 - 1) {
            element = this.elements[i2];
            if (element == null) {
                return false;
            }
            if (element.getKey().equals(key)) {
                this.rehashTo(i2);
                --this.elementCount;
                return true;
            }
            ++i2;
        }
        return true;
    }

    private boolean shouldGrow() {
        return (double)this.elementCount > (double)this.elements.length * 0.75;
    }

    public int size() {
        return this.elementCount;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(100);
        result.append("{");
        boolean first = true;
        KeyedElement[] keyedElementArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            KeyedElement element = keyedElementArray[n2];
            if (element != null) {
                if (first) {
                    first = false;
                } else {
                    result.append(", ");
                }
                result.append(element);
            }
            ++n2;
        }
        result.append("}");
        return result.toString();
    }
}

