/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.preferences.legacy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import paper.libs.org.eclipse.core.internal.preferences.DefaultPreferences;
import paper.libs.org.eclipse.core.internal.preferences.EclipsePreferences;
import paper.libs.org.eclipse.core.internal.preferences.PreferencesService;
import paper.libs.org.eclipse.core.internal.runtime.RuntimeLog;
import paper.libs.org.eclipse.core.runtime.Preferences;
import paper.libs.org.eclipse.core.runtime.Status;
import paper.libs.org.eclipse.core.runtime.preferences.IEclipsePreferences;
import paper.libs.org.osgi.service.prefs.BackingStoreException;

@Deprecated
public class PreferenceForwarder
extends Preferences
implements IEclipsePreferences.IPreferenceChangeListener,
IEclipsePreferences.INodeChangeListener {
    private static final byte[] BYTE_ARRAY_DEFAULT_DEFAULT = new byte[0];
    private IEclipsePreferences pluginRoot = (IEclipsePreferences)PreferencesService.getDefault().getRootNode().node("instance");
    private DefaultPreferences defaultsRoot = (DefaultPreferences)PreferencesService.getDefault().getRootNode().node("default");
    private String pluginID;
    private Object plugin;
    private boolean notify = true;

    public PreferenceForwarder(String pluginID) {
        this(null, pluginID);
    }

    public PreferenceForwarder(Object plugin, String pluginID) {
        this.plugin = plugin;
        this.pluginID = pluginID;
    }

    @Override
    public synchronized void added(IEclipsePreferences.NodeChangeEvent event) {
        if (this.listeners.size() > 0 && this.pluginID.equals(event.getChild().name())) {
            try {
                EclipsePreferences prefs = (EclipsePreferences)event.getChild();
                prefs.addPreferenceChangeListener(this);
            }
            catch (ClassCastException e) {
                throw new RuntimeException("Plug-in preferences must be instances of EclipsePreferences: " + e.getMessage());
            }
        }
    }

    @Override
    public synchronized void removed(IEclipsePreferences.NodeChangeEvent event) {
    }

    @Override
    public synchronized void addPropertyChangeListener(Preferences.IPropertyChangeListener listener) {
        if (this.listeners.size() == 0) {
            EclipsePreferences prefs = this.getPluginPreferences(false);
            if (prefs != null) {
                prefs.addPreferenceChangeListener(this);
            }
            this.pluginRoot.addNodeChangeListener(this);
        }
        this.listeners.add(listener);
    }

    @Override
    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (!this.notify) {
            return;
        }
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        String key = event.getKey();
        if (newValue == null) {
            newValue = this.getDefault(key, oldValue);
        } else if (oldValue == null) {
            oldValue = this.getDefault(key, newValue);
        }
        this.firePropertyChangeEvent(key, oldValue, newValue);
    }

    private EclipsePreferences getPluginPreferences(boolean create) {
        try {
            if (!create && !this.pluginRoot.nodeExists(this.pluginID)) {
                return null;
            }
        }
        catch (BackingStoreException backingStoreException) {
            return null;
        }
        try {
            return (EclipsePreferences)this.pluginRoot.node(this.pluginID);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Plug-in preferences must be instances of EclipsePreferences: " + e.getMessage());
        }
    }

    private IEclipsePreferences getDefaultPreferences() {
        return this.defaultsRoot.node(this.pluginID, this.plugin);
    }

    @Override
    public synchronized void removePropertyChangeListener(Preferences.IPropertyChangeListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.size() == 0) {
            EclipsePreferences prefs = this.getPluginPreferences(false);
            if (prefs != null) {
                prefs.removePreferenceChangeListener(this);
            }
            this.pluginRoot.removeNodeChangeListener(this);
        }
    }

    private Object getDefault(String key, Object obj) {
        IEclipsePreferences defaults = this.getDefaultPreferences();
        if (obj instanceof String) {
            return defaults.get(key, "");
        }
        if (obj instanceof Integer) {
            return defaults.getInt(key, 0);
        }
        if (obj instanceof Double) {
            return defaults.getDouble(key, 0.0);
        }
        if (obj instanceof Float) {
            return Float.valueOf(defaults.getFloat(key, 0.0f));
        }
        if (obj instanceof Long) {
            return defaults.getLong(key, 0L);
        }
        if (obj instanceof byte[]) {
            return defaults.getByteArray(key, BYTE_ARRAY_DEFAULT_DEFAULT);
        }
        if (obj instanceof Boolean) {
            return defaults.getBoolean(key, false) ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    @Override
    public boolean contains(String name2) {
        if (name2 == null) {
            return false;
        }
        String value = this.getPluginPreferences(true).get(name2, null);
        if (value != null) {
            return true;
        }
        return this.getDefaultPreferences().get(name2, null) != null;
    }

    @Override
    public boolean getBoolean(String name2) {
        return this.getPluginPreferences(true).getBoolean(name2, this.getDefaultPreferences().getBoolean(name2, false));
    }

    @Override
    public void setValue(String name2, boolean value) {
        Boolean newValue;
        Boolean oldValue = this.getBoolean(name2) ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl = newValue = value ? Boolean.TRUE : Boolean.FALSE;
        if (newValue == oldValue) {
            return;
        }
        try {
            this.notify = false;
            if (this.getDefaultBoolean(name2) == value) {
                this.getPluginPreferences(true).remove(name2);
            } else {
                this.getPluginPreferences(true).putBoolean(name2, value);
            }
            this.firePropertyChangeEvent(name2, oldValue, newValue);
        }
        finally {
            this.notify = true;
        }
    }

    @Override
    public boolean getDefaultBoolean(String name2) {
        return this.getDefaultPreferences().getBoolean(name2, false);
    }

    @Override
    public void setDefault(String name2, boolean value) {
        this.getDefaultPreferences().putBoolean(name2, value);
    }

    @Override
    public double getDouble(String name2) {
        return this.getPluginPreferences(true).getDouble(name2, this.getDefaultPreferences().getDouble(name2, 0.0));
    }

    @Override
    public void setValue(String name2, double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException();
        }
        double doubleValue = this.getDouble(name2);
        if (value == doubleValue) {
            return;
        }
        Double oldValue = doubleValue;
        Double newValue = value;
        try {
            this.notify = false;
            if (this.getDefaultDouble(name2) == value) {
                this.getPluginPreferences(true).remove(name2);
            } else {
                this.getPluginPreferences(true).putDouble(name2, value);
            }
            this.firePropertyChangeEvent(name2, oldValue, newValue);
        }
        finally {
            this.notify = true;
        }
    }

    @Override
    public double getDefaultDouble(String name2) {
        return this.getDefaultPreferences().getDouble(name2, 0.0);
    }

    @Override
    public void setDefault(String name2, double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException();
        }
        this.getDefaultPreferences().putDouble(name2, value);
    }

    @Override
    public float getFloat(String name2) {
        return this.getPluginPreferences(true).getFloat(name2, this.getDefaultPreferences().getFloat(name2, 0.0f));
    }

    @Override
    public void setValue(String name2, float value) {
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException();
        }
        float floatValue = this.getFloat(name2);
        if (value == floatValue) {
            return;
        }
        Float oldValue = Float.valueOf(floatValue);
        Float newValue = Float.valueOf(value);
        try {
            this.notify = false;
            if (this.getDefaultFloat(name2) == value) {
                this.getPluginPreferences(true).remove(name2);
            } else {
                this.getPluginPreferences(true).putFloat(name2, value);
            }
            this.firePropertyChangeEvent(name2, oldValue, newValue);
        }
        finally {
            this.notify = true;
        }
    }

    @Override
    public float getDefaultFloat(String name2) {
        return this.getDefaultPreferences().getFloat(name2, 0.0f);
    }

    @Override
    public void setDefault(String name2, float value) {
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException();
        }
        this.getDefaultPreferences().putFloat(name2, value);
    }

    @Override
    public int getInt(String name2) {
        return this.getPluginPreferences(true).getInt(name2, this.getDefaultPreferences().getInt(name2, 0));
    }

    @Override
    public void setValue(String name2, int value) {
        int intValue = this.getInt(name2);
        if (value == intValue) {
            return;
        }
        Integer oldValue = intValue;
        Integer newValue = value;
        try {
            this.notify = false;
            if (this.getDefaultInt(name2) == value) {
                this.getPluginPreferences(true).remove(name2);
            } else {
                this.getPluginPreferences(true).putInt(name2, value);
            }
            this.firePropertyChangeEvent(name2, oldValue, newValue);
        }
        finally {
            this.notify = true;
        }
    }

    @Override
    public int getDefaultInt(String name2) {
        return this.getDefaultPreferences().getInt(name2, 0);
    }

    @Override
    public void setDefault(String name2, int value) {
        this.getDefaultPreferences().putInt(name2, value);
    }

    @Override
    public long getLong(String name2) {
        return this.getPluginPreferences(true).getLong(name2, this.getDefaultPreferences().getLong(name2, 0L));
    }

    @Override
    public void setValue(String name2, long value) {
        long longValue = this.getLong(name2);
        if (value == longValue) {
            return;
        }
        Long oldValue = longValue;
        Long newValue = value;
        try {
            this.notify = false;
            if (this.getDefaultLong(name2) == value) {
                this.getPluginPreferences(true).remove(name2);
            } else {
                this.getPluginPreferences(true).putLong(name2, value);
            }
            this.firePropertyChangeEvent(name2, oldValue, newValue);
        }
        finally {
            this.notify = true;
        }
    }

    @Override
    public long getDefaultLong(String name2) {
        return this.getDefaultPreferences().getLong(name2, 0L);
    }

    @Override
    public void setDefault(String name2, long value) {
        this.getDefaultPreferences().putLong(name2, value);
    }

    @Override
    public String getString(String name2) {
        return this.getPluginPreferences(true).get(name2, this.getDefaultPreferences().get(name2, ""));
    }

    @Override
    public void setValue(String name2, String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        String oldValue = this.getString(name2);
        if (value.equals(oldValue)) {
            return;
        }
        try {
            this.notify = false;
            if (this.getDefaultString(name2).equals(value)) {
                this.getPluginPreferences(true).remove(name2);
            } else {
                this.getPluginPreferences(true).put(name2, value);
            }
            this.firePropertyChangeEvent(name2, oldValue, value);
        }
        finally {
            this.notify = true;
        }
    }

    @Override
    public String getDefaultString(String name2) {
        return this.getDefaultPreferences().get(name2, "");
    }

    @Override
    public void setDefault(String name2, String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.getDefaultPreferences().put(name2, value);
    }

    @Override
    public boolean isDefault(String name2) {
        if (name2 == null) {
            return false;
        }
        return this.getPluginPreferences(true).get(name2, null) == null;
    }

    @Override
    public void setToDefault(String name2) {
        EclipsePreferences preferences = this.getPluginPreferences(true);
        String oldValue = preferences.get(name2, null);
        if (oldValue != null) {
            preferences.remove(name2);
        }
    }

    @Override
    public String[] propertyNames() {
        return this.getPluginPreferences(true).keys();
    }

    @Override
    public String[] defaultPropertyNames() {
        try {
            return this.getDefaultPreferences().keys();
        }
        catch (BackingStoreException e) {
            this.logError(e.getMessage(), e);
            return new String[0];
        }
    }

    @Override
    public boolean needsSaving() {
        return this.getPluginPreferences(true).isDirty();
    }

    public void flush() throws BackingStoreException {
        EclipsePreferences node = this.getPluginPreferences(false);
        if (node != null) {
            node.flush();
        }
    }

    private void logError(String message, Exception e) {
        Status status = new Status(4, "paper.libs.org.eclipse.equinox.preferences", 4, message, (Throwable)e);
        RuntimeLog.log(status);
    }

    @Override
    public void load(InputStream in) throws IOException {
        Properties result = new Properties();
        result.load(in);
        this.convertFromProperties(result);
        try {
            this.flush();
        }
        catch (BackingStoreException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void store(OutputStream out, String header) throws IOException {
        Properties result = this.convertToProperties();
        result.store(out, header);
        try {
            this.flush();
        }
        catch (BackingStoreException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void convertFromProperties(Properties props) {
        EclipsePreferences preferences = this.getPluginPreferences(true);
        for (Object object : props.keySet()) {
            String key = (String)object;
            String value = props.getProperty(key);
            if (value == null) continue;
            preferences.put(key, value);
        }
    }

    public String toString() {
        return "PreferenceForwarder(" + this.pluginID + ")";
    }

    private Properties convertToProperties() {
        String[] keys;
        Properties result = new Properties();
        String[] stringArray = keys = this.propertyNames();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String value = this.getString(key);
            if (!"".equals(value)) {
                result.put(key, value);
            }
            ++n2;
        }
        return result;
    }
}

