/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.preferences;

import java.util.TreeSet;
import paper.libs.org.eclipse.core.internal.preferences.OSGiPreferencesServiceImpl;
import paper.libs.org.eclipse.core.runtime.preferences.ConfigurationScope;
import paper.libs.org.osgi.framework.Bundle;
import paper.libs.org.osgi.framework.BundleContext;
import paper.libs.org.osgi.framework.BundleEvent;
import paper.libs.org.osgi.framework.BundleListener;
import paper.libs.org.osgi.framework.ServiceFactory;
import paper.libs.org.osgi.framework.ServiceRegistration;
import paper.libs.org.osgi.service.prefs.BackingStoreException;
import paper.libs.org.osgi.service.prefs.Preferences;
import paper.libs.org.osgi.service.prefs.PreferencesService;

public class OSGiPreferencesServiceManager
implements ServiceFactory<PreferencesService>,
BundleListener {
    private static final String ORG_ECLIPSE_CORE_INTERNAL_PREFERENCES_OSGI = "paper.libs.org.eclipse.core.internal.preferences.osgi";
    private Preferences prefBundles;

    public OSGiPreferencesServiceManager(BundleContext context) {
        context.addBundleListener(this);
        this.prefBundles = ConfigurationScope.INSTANCE.getNode(ORG_ECLIPSE_CORE_INTERNAL_PREFERENCES_OSGI);
        try {
            String[] prefsBundles;
            Bundle[] allBundles = context.getBundles();
            TreeSet<String> bundleQualifiers = new TreeSet<String>();
            Bundle[] bundleArray = allBundles;
            int n = allBundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle allBundle = bundleArray[n2];
                bundleQualifiers.add(this.getQualifier(allBundle));
                ++n2;
            }
            String[] stringArray = prefsBundles = this.prefBundles.keys();
            int n3 = prefsBundles.length;
            n = 0;
            while (n < n3) {
                String prefsBundle = stringArray[n];
                if (!bundleQualifiers.contains(prefsBundle)) {
                    this.removePrefs(prefsBundle);
                }
                ++n;
            }
        }
        catch (BackingStoreException backingStoreException) {}
    }

    @Override
    public PreferencesService getService(Bundle bundle, ServiceRegistration<PreferencesService> registration) {
        String qualifier = this.getQualifier(bundle);
        Preferences bundlesNode = this.getBundlesNode();
        bundlesNode.put(qualifier, "");
        try {
            bundlesNode.flush();
        }
        catch (BackingStoreException backingStoreException) {}
        return new OSGiPreferencesServiceImpl(ConfigurationScope.INSTANCE.getNode(this.getQualifier(bundle)));
    }

    private String getQualifier(Bundle bundle) {
        String qualifier = "paper.libs.org.eclipse.core.runtime.preferences.OSGiPreferences." + bundle.getBundleId();
        return qualifier;
    }

    @Override
    public void ungetService(Bundle bundle, ServiceRegistration<PreferencesService> registration, PreferencesService service) {
        try {
            ConfigurationScope.INSTANCE.getNode(this.getQualifier(bundle)).flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    @Override
    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16) {
            try {
                this.removePrefs(this.getQualifier(event.getBundle()));
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    protected void removePrefs(String qualifier) throws BackingStoreException {
        ConfigurationScope.INSTANCE.getNode(qualifier).removeNode();
        Preferences bundlesNode = this.getBundlesNode();
        bundlesNode.remove(qualifier);
        bundlesNode.flush();
    }

    private Preferences getBundlesNode() {
        try {
            if (this.prefBundles == null || !this.prefBundles.nodeExists("")) {
                this.prefBundles = ConfigurationScope.INSTANCE.getNode(ORG_ECLIPSE_CORE_INTERNAL_PREFERENCES_OSGI);
            }
            return this.prefBundles;
        }
        catch (BackingStoreException backingStoreException) {
            return null;
        }
    }
}

