/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.expressions;

import org.w3c.dom.Element;
import paper.libs.org.eclipse.core.expressions.EvaluationResult;
import paper.libs.org.eclipse.core.expressions.Expression;
import paper.libs.org.eclipse.core.expressions.ExpressionInfo;
import paper.libs.org.eclipse.core.expressions.IEvaluationContext;
import paper.libs.org.eclipse.core.internal.expressions.Expressions;
import paper.libs.org.eclipse.core.runtime.Assert;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IConfigurationElement;

public class SystemTestExpression
extends Expression {
    private String fProperty;
    private String fExpectedValue;
    private static final String ATT_PROPERTY = "property";
    private static final int HASH_INITIAL = SystemTestExpression.class.getName().hashCode();

    public SystemTestExpression(IConfigurationElement element) throws CoreException {
        this.fProperty = element.getAttribute(ATT_PROPERTY);
        Expressions.checkAttribute(ATT_PROPERTY, this.fProperty);
        this.fExpectedValue = element.getAttribute("value");
        Expressions.checkAttribute("value", this.fExpectedValue);
    }

    public SystemTestExpression(Element element) throws CoreException {
        this.fProperty = element.getAttribute(ATT_PROPERTY);
        Expressions.checkAttribute(ATT_PROPERTY, this.fProperty.isEmpty() ? null : this.fProperty);
        this.fExpectedValue = element.getAttribute("value");
        Expressions.checkAttribute("value", this.fExpectedValue.isEmpty() ? null : this.fExpectedValue);
    }

    public SystemTestExpression(String property, String expectedValue) {
        Assert.isNotNull(property);
        Assert.isNotNull(expectedValue);
        this.fProperty = property;
        this.fExpectedValue = expectedValue;
    }

    @Override
    public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
        String str = System.getProperty(this.fProperty);
        if (str == null) {
            return EvaluationResult.FALSE;
        }
        return EvaluationResult.valueOf(str.equals(this.fExpectedValue));
    }

    @Override
    public void collectExpressionInfo(ExpressionInfo info) {
        info.markSystemPropertyAccessed();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SystemTestExpression)) {
            return false;
        }
        SystemTestExpression that = (SystemTestExpression)object;
        return this.fProperty.equals(that.fProperty) && this.fExpectedValue.equals(that.fExpectedValue);
    }

    @Override
    protected int computeHashCode() {
        return HASH_INITIAL * 89 + this.fExpectedValue.hashCode() * 89 + this.fProperty.hashCode();
    }

    public String toString() {
        return "<systemTest property=\"" + this.fProperty + "\" value=\"" + this.fExpectedValue + "\"";
    }
}

