/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.dtree;

import paper.libs.org.eclipse.core.internal.dtree.AbstractDataTreeNode;
import paper.libs.org.eclipse.core.internal.dtree.DataTreeNode;
import paper.libs.org.eclipse.core.internal.dtree.DeltaDataTree;
import paper.libs.org.eclipse.core.internal.dtree.IComparator;
import paper.libs.org.eclipse.core.internal.dtree.NoDataDeltaNode;
import paper.libs.org.eclipse.core.internal.dtree.NodeComparison;
import paper.libs.org.eclipse.core.runtime.IPath;

public class DataDeltaNode
extends DataTreeNode {
    DataDeltaNode(String name2, Object data) {
        super(name2, data);
    }

    DataDeltaNode(String name2, Object data, AbstractDataTreeNode[] children) {
        super(name2, data, children);
    }

    @Override
    AbstractDataTreeNode asBackwardDelta(DeltaDataTree myTree, DeltaDataTree parentTree, IPath key) {
        AbstractDataTreeNode[] newChildren;
        if (this.children.length == 0) {
            newChildren = NO_CHILDREN;
        } else {
            newChildren = new AbstractDataTreeNode[this.children.length];
            int i2 = this.children.length;
            while (--i2 >= 0) {
                newChildren[i2] = this.children[i2].asBackwardDelta(myTree, parentTree, key.append(this.children[i2].getName()));
            }
        }
        return new DataDeltaNode(this.name, parentTree.getData(key), newChildren);
    }

    @Override
    AbstractDataTreeNode compareWithParent(IPath key, DeltaDataTree parent, IComparator comparator2) {
        AbstractDataTreeNode[] comparedChildren = DataDeltaNode.compareWithParent(this.children, key, parent, comparator2);
        Object oldData = parent.getData(key);
        Object newData = this.data;
        int userComparison = 0;
        if (key != parent.rootKey()) {
            userComparison = comparator2.compare(oldData, newData);
        }
        return new DataTreeNode(key.lastSegment(), new NodeComparison(oldData, newData, 4, userComparison), comparedChildren);
    }

    @Override
    AbstractDataTreeNode copy() {
        AbstractDataTreeNode[] childrenCopy;
        if (this.children.length == 0) {
            childrenCopy = NO_CHILDREN;
        } else {
            childrenCopy = new AbstractDataTreeNode[this.children.length];
            System.arraycopy(this.children, 0, childrenCopy, 0, this.children.length);
        }
        return new DataDeltaNode(this.name, this.data, childrenCopy);
    }

    @Override
    boolean isDelta() {
        return true;
    }

    @Override
    AbstractDataTreeNode simplifyWithParent(IPath key, DeltaDataTree parent, IComparator comparer) {
        AbstractDataTreeNode[] simplifiedChildren = DataDeltaNode.simplifyWithParent(this.children, key, parent, comparer);
        if (!key.isRoot() && comparer.compare(parent.getData(key), this.data) == 0) {
            return new NoDataDeltaNode(this.name, simplifiedChildren);
        }
        return new DataDeltaNode(this.name, this.data, simplifiedChildren);
    }

    @Override
    public String toString() {
        return "a DataDeltaNode(" + this.getName() + ") with " + this.getChildren().length + " children.";
    }

    @Override
    int type() {
        return 1;
    }
}

