/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.expressions;

import java.util.HashMap;
import java.util.Map;
import paper.libs.org.eclipse.core.expressions.IEvaluationContext;
import paper.libs.org.eclipse.core.expressions.IVariableResolver;
import paper.libs.org.eclipse.core.runtime.Assert;
import paper.libs.org.eclipse.core.runtime.CoreException;

public class EvaluationContext
implements IEvaluationContext {
    private IEvaluationContext fParent;
    private Object fDefaultVariable;
    private Map<String, Object> fVariables;
    private IVariableResolver[] fVariableResolvers;
    private Boolean fAllowPluginActivation;

    public EvaluationContext(IEvaluationContext parent, Object defaultVariable) {
        Assert.isNotNull(defaultVariable);
        this.fParent = parent;
        this.fDefaultVariable = defaultVariable;
    }

    public EvaluationContext(IEvaluationContext parent, Object defaultVariable, IVariableResolver[] resolvers) {
        Assert.isNotNull(defaultVariable);
        Assert.isNotNull(resolvers);
        this.fParent = parent;
        this.fDefaultVariable = defaultVariable;
        this.fVariableResolvers = resolvers;
    }

    @Override
    public IEvaluationContext getParent() {
        return this.fParent;
    }

    @Override
    public IEvaluationContext getRoot() {
        if (this.fParent == null) {
            return this;
        }
        return this.fParent.getRoot();
    }

    @Override
    public Object getDefaultVariable() {
        return this.fDefaultVariable;
    }

    @Override
    public void setAllowPluginActivation(boolean value) {
        this.fAllowPluginActivation = value ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean getAllowPluginActivation() {
        if (this.fAllowPluginActivation == null) {
            if (this.fParent != null) {
                return this.fParent.getAllowPluginActivation();
            }
            return false;
        }
        return this.fAllowPluginActivation;
    }

    @Override
    public void addVariable(String name2, Object value) {
        Assert.isNotNull(name2);
        Assert.isNotNull(value);
        if (this.fVariables == null) {
            this.fVariables = new HashMap<String, Object>();
        }
        this.fVariables.put(name2, value);
    }

    @Override
    public Object removeVariable(String name2) {
        Assert.isNotNull(name2);
        if (this.fVariables == null) {
            return null;
        }
        return this.fVariables.remove(name2);
    }

    @Override
    public Object getVariable(String name2) {
        Assert.isNotNull(name2);
        Object result = null;
        if (this.fVariables != null) {
            result = this.fVariables.get(name2);
        }
        if (result != null) {
            return result;
        }
        if (this.fParent != null) {
            return this.fParent.getVariable(name2);
        }
        return null;
    }

    @Override
    public Object resolveVariable(String name2, Object[] args) throws CoreException {
        if (this.fVariableResolvers != null && this.fVariableResolvers.length > 0) {
            IVariableResolver[] iVariableResolverArray = this.fVariableResolvers;
            int n = this.fVariableResolvers.length;
            int n2 = 0;
            while (n2 < n) {
                IVariableResolver resolver = iVariableResolverArray[n2];
                Object variable = resolver.resolve(name2, args);
                if (variable != null) {
                    return variable;
                }
                ++n2;
            }
        }
        if (this.fParent != null) {
            return this.fParent.resolveVariable(name2, args);
        }
        return null;
    }
}

