/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.mercury.extra;

import java.util.Objects;
import paper.libs.org.cadixdev.at.AccessChange;
import paper.libs.org.cadixdev.at.AccessTransform;
import paper.libs.org.cadixdev.at.AccessTransformSet;
import paper.libs.org.cadixdev.at.ModifierChange;
import paper.libs.org.cadixdev.bombe.analysis.InheritanceProvider;
import paper.libs.org.cadixdev.bombe.type.signature.MethodSignature;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;
import paper.libs.org.cadixdev.mercury.SourceContext;
import paper.libs.org.cadixdev.mercury.SourceProcessor;
import paper.libs.org.cadixdev.mercury.analysis.MercuryInheritanceProvider;
import paper.libs.org.cadixdev.mercury.util.BombeBindings;
import paper.libs.org.cadixdev.mercury.util.GracefulCheck;
import paper.libs.org.eclipse.jdt.core.dom.ASTNode;
import paper.libs.org.eclipse.jdt.core.dom.ASTVisitor;
import paper.libs.org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.IBinding;
import paper.libs.org.eclipse.jdt.core.dom.IMethodBinding;
import paper.libs.org.eclipse.jdt.core.dom.ITypeBinding;
import paper.libs.org.eclipse.jdt.core.dom.IVariableBinding;
import paper.libs.org.eclipse.jdt.core.dom.Modifier;
import paper.libs.org.eclipse.jdt.core.dom.SimpleName;

public final class AccessAnalyzerProcessor
implements SourceProcessor {
    private final AccessTransformSet ats;
    private final MappingSet mappings;

    public static AccessAnalyzerProcessor create(AccessTransformSet ats2, MappingSet mappings) {
        return new AccessAnalyzerProcessor(ats2, mappings);
    }

    private AccessAnalyzerProcessor(AccessTransformSet ats2, MappingSet mappings) {
        this.ats = Objects.requireNonNull(ats2, "ats");
        this.mappings = Objects.requireNonNull(mappings, "mappings");
    }

    @Override
    public int getFlags() {
        return 1;
    }

    @Override
    public void process(SourceContext context) {
        context.getCompilationUnit().accept(new Visitor(context, this.ats, this.mappings));
    }

    private static class Visitor
    extends ASTVisitor {
        private static final AccessTransform TRANSFORM = AccessTransform.of(AccessChange.PUBLIC, ModifierChange.NONE);
        private final SourceContext context;
        private final AccessTransformSet ats;
        private final MappingSet mappings;
        private final InheritanceProvider inheritanceProvider;
        private String newPackage;

        private Visitor(SourceContext context, AccessTransformSet ats2, MappingSet mappings) {
            this.context = context;
            this.ats = ats2;
            this.mappings = mappings;
            this.inheritanceProvider = MercuryInheritanceProvider.get(context.getMercury());
            this.newPackage = this.mappings.getTopLevelClassMapping(context.getQualifiedPrimaryType()).map(primary -> primary.getDeobfuscatedPackage().replace('/', '.')).orElse(context.getPackageName());
        }

        private static ITypeBinding resolveBinding(ASTNode node) {
            if (node instanceof AbstractTypeDeclaration) {
                return ((AbstractTypeDeclaration)node).resolveBinding();
            }
            if (node.getNodeType() == 1) {
                return ((AnonymousClassDeclaration)node).resolveBinding();
            }
            return null;
        }

        private static boolean inheritsBinding(ASTNode node, ITypeBinding declaringClass) {
            while (node != null) {
                ITypeBinding parentBinding = Visitor.resolveBinding(node);
                if (parentBinding != null && parentBinding.isAssignmentCompatible(declaringClass)) {
                    return true;
                }
                node = node.getParent();
            }
            return false;
        }

        private boolean needsTransform(SimpleName node, IBinding binding, ITypeBinding declaringClass) {
            String packageName;
            if (declaringClass == null || GracefulCheck.checkGracefully(this.context, declaringClass)) {
                return false;
            }
            int modifiers = binding.getModifiers();
            if (Modifier.isProtected(modifiers) ? Visitor.inheritsBinding(node, declaringClass) : !BombeBindings.isPackagePrivate(modifiers)) {
                return false;
            }
            String binaryName = declaringClass.getBinaryName();
            if (binaryName == null) {
                throw new IllegalStateException("Binary name for binding " + declaringClass.getQualifiedName() + " is null. Did you forget to add a library to the classpath?");
            }
            ClassMapping mapping = this.mappings.getClassMapping(binaryName).orElse(null);
            if (mapping != null) {
                mapping.complete(this.inheritanceProvider, declaringClass);
                packageName = mapping.getDeobfuscatedPackage().replace('/', '.');
            } else {
                packageName = declaringClass.getPackage().getName();
            }
            return !packageName.equals(this.newPackage);
        }

        private void analyze(SimpleName node, ITypeBinding binding) {
            if (binding.isLocal()) {
                return;
            }
            if (this.needsTransform(node, binding, binding)) {
                this.ats.getOrCreateClass(binding.getBinaryName()).merge(TRANSFORM);
            }
        }

        private void analyze(SimpleName node, IMethodBinding binding) {
            ITypeBinding declaringClass = binding.getDeclaringClass();
            if (this.needsTransform(node, binding, declaringClass)) {
                MethodSignature signature = BombeBindings.convertSignature(binding);
                this.ats.getOrCreateClass(declaringClass.getBinaryName()).mergeMethod(signature, TRANSFORM);
            }
        }

        private void analyze(SimpleName node, IVariableBinding binding) {
            if (!binding.isField()) {
                return;
            }
            ITypeBinding declaringClass = binding.getDeclaringClass();
            if (this.needsTransform(node, binding, declaringClass)) {
                this.ats.getOrCreateClass(declaringClass.getBinaryName()).mergeField(binding.getName(), TRANSFORM);
            }
        }

        @Override
        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (binding == null) {
                return true;
            }
            switch (binding.getKind()) {
                case 2: {
                    this.analyze(node, ((ITypeBinding)binding).getErasure());
                    break;
                }
                case 4: {
                    this.analyze(node, ((IMethodBinding)binding).getMethodDeclaration());
                    break;
                }
                case 3: {
                    this.analyze(node, ((IVariableBinding)binding).getVariableDeclaration());
                }
            }
            return true;
        }
    }
}

