/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.mercury;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import paper.libs.org.cadixdev.mercury.Mercury;
import paper.libs.org.cadixdev.mercury.SourceContext;
import paper.libs.org.cadixdev.mercury.SourceProcessor;
import paper.libs.org.cadixdev.mercury.jdt.rewrite.imports.ImportRewrite;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.jdt.core.dom.CompilationUnit;
import paper.libs.org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import paper.libs.org.eclipse.jface.text.Document;
import paper.libs.org.eclipse.text.edits.MultiTextEdit;
import paper.libs.org.eclipse.text.edits.TextEdit;

public final class RewriteContext
extends SourceContext {
    private TextEdit edit;
    private ASTRewrite rewrite;
    private ImportRewrite importRewrite;

    RewriteContext(Mercury mercury, Path sourceFile, CompilationUnit compilationUnit, String primaryType) {
        super(mercury, sourceFile, compilationUnit, primaryType);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName != null ? packageName : "";
    }

    public void setPrimaryType(String primaryType) {
        this.primaryType = Objects.requireNonNull(primaryType, "primaryType");
    }

    public Optional<ASTRewrite> getASTRewrite() {
        return Optional.ofNullable(this.rewrite);
    }

    public ASTRewrite createASTRewrite() {
        if (this.rewrite == null) {
            this.rewrite = ASTRewrite.create(this.getCompilationUnit().getAST());
        }
        return this.rewrite;
    }

    public ImportRewrite createImportRewrite() {
        if (this.importRewrite == null) {
            this.importRewrite = ImportRewrite.create(this.getCompilationUnit(), true);
        }
        return this.importRewrite;
    }

    public void addEdit(TextEdit edit) {
        if (this.edit == null) {
            this.edit = new MultiTextEdit();
        }
        this.edit.addChild(Objects.requireNonNull(edit, "edit"));
    }

    private TextEdit rewrite() throws CoreException, IOException {
        if (this.rewrite == null && this.importRewrite == null && this.edit == null) {
            return null;
        }
        TextEdit edit = null;
        if (this.rewrite != null) {
            edit = this.rewrite.rewriteAST(this.loadDocument(), null);
        }
        if (this.importRewrite != null) {
            edit = RewriteContext.combineEdit(edit, this.importRewrite.rewriteImports(this.loadDocument(), null));
        }
        return RewriteContext.combineEdit(edit, this.edit);
    }

    private static TextEdit combineEdit(TextEdit before, TextEdit edit) {
        if (before == null) {
            return edit;
        }
        if (edit != null) {
            if (edit instanceof MultiTextEdit) {
                MultiTextEdit multiTextEdit = (MultiTextEdit)edit;
                before.addChildren(multiTextEdit.removeChildren());
            } else {
                before.addChild(edit);
            }
        }
        return before;
    }

    @Override
    void process(List<SourceProcessor> processors) throws Exception {
        super.process(processors);
        Path outputDir = this.getMercury().getOutputDir();
        String path = this.primaryType + ".java";
        if (!this.packageName.isEmpty()) {
            StringJoiner joiner = new StringJoiner(outputDir.getFileSystem().getSeparator());
            for (String part : this.packageName.split("\\.")) {
                joiner.add(part);
            }
            joiner.add(path);
            path = joiner.toString();
        }
        Path outputFile = outputDir.resolve(path);
        Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
        TextEdit edit = this.rewrite();
        if (edit == null) {
            Files.copy(this.getSourceFile(), outputFile, StandardCopyOption.REPLACE_EXISTING);
            return;
        }
        Document document = this.loadDocument();
        edit.apply(document, 0);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(outputFile, new OpenOption[0]), this.getMercury().getEncoding());){
            writer.write(document.get());
        }
    }
}

