/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.at.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import paper.libs.org.cadixdev.at.AccessTransformSet;

public interface AccessTransformFormat {
    default public AccessTransformSet read(Reader reader) throws IOException {
        AccessTransformSet set = AccessTransformSet.create();
        this.read(reader, set);
        return set;
    }

    public void read(Reader var1, AccessTransformSet var2) throws IOException;

    default public AccessTransformSet read(Path path) throws IOException {
        AccessTransformSet set = AccessTransformSet.create();
        this.read(path, set);
        return set;
    }

    default public void read(Path path, AccessTransformSet set) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            this.read(reader, set);
        }
    }

    public void write(Writer var1, AccessTransformSet var2) throws IOException;

    default public void write(Path path, AccessTransformSet set) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            this.write(writer, set);
        }
    }
}

