/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.model.data.types;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import paper.libs.com.google.errorprone.annotations.Immutable;
import paper.libs.dev.denwav.hypo.model.data.types.JvmType;

@Immutable
public final class ArrayType
implements JvmType {
    @NotNull
    private final JvmType baseType;
    private final int dimension;

    public ArrayType(@NotNull JvmType baseType, int dimension) {
        if (dimension <= 0) {
            throw new IllegalArgumentException("Invalid array dimension: " + dimension);
        }
        if (baseType instanceof ArrayType) {
            throw new IllegalArgumentException("Invalid array base type: " + baseType.getClass().getName());
        }
        this.baseType = baseType;
        this.dimension = dimension;
    }

    @NotNull
    public JvmType baseType() {
        return this.baseType;
    }

    public int dimension() {
        return this.dimension;
    }

    private void internalPrefix(@NotNull StringBuilder sb) {
        for (int i2 = 0; i2 < this.dimension; ++i2) {
            sb.append('[');
        }
    }

    private void readableSuffix(@NotNull StringBuilder sb) {
        for (int i2 = 0; i2 < this.dimension; ++i2) {
            sb.append("[]");
        }
    }

    @Override
    public void asReadableName(@NotNull StringBuilder sb) {
        this.baseType.asReadableName(sb);
        this.readableSuffix(sb);
    }

    @Override
    public void asInternalName(@NotNull StringBuilder sb) {
        this.internalPrefix(sb);
        this.baseType.asInternalName(sb);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayType)) {
            return false;
        }
        ArrayType arrayType = (ArrayType)o;
        return this.dimension == arrayType.dimension && this.baseType.equals(arrayType.baseType);
    }

    public int hashCode() {
        return Objects.hash(this.baseType, this.dimension);
    }

    public String toString() {
        return this.asReadableName();
    }
}

