/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.model.data;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paper.libs.com.google.errorprone.annotations.concurrent.LazyInit;
import paper.libs.dev.denwav.hypo.model.HypoModelUtil;

public final class LazyValue<T, X extends Throwable> {
    @LazyInit
    @Nullable
    private T value = null;
    @Nullable
    private Generator<T, X> generator;

    private LazyValue(@NotNull Generator<T, X> generator) {
        this.generator = generator;
    }

    @NotNull
    public static <T, X extends Throwable> LazyValue<T, X> of(@NotNull Generator<T, X> generator) {
        return new LazyValue<T, X>(generator);
    }

    @Nullable
    public T get() {
        try {
            return this.getOrThrow();
        }
        catch (Throwable e) {
            throw HypoModelUtil.rethrow(e);
        }
    }

    @NotNull
    public T getNotNull() {
        return Objects.requireNonNull(this.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getOrThrow() throws X {
        T val = this.value;
        if (val != null) {
            return val;
        }
        LazyValue lazyValue = this;
        synchronized (lazyValue) {
            val = this.value;
            if (val != null) {
                return val;
            }
            Generator<T, X> gen = this.generator;
            if (gen == null) {
                return null;
            }
            this.value = val = gen.get();
            this.generator = null;
            return val;
        }
    }

    @NotNull
    public T getOrThrowNotNull() throws X {
        return Objects.requireNonNull(this.getOrThrow());
    }

    @FunctionalInterface
    public static interface Generator<T, X extends Throwable> {
        public T get() throws X;
    }
}

