/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.asm;

import org.jetbrains.annotations.NotNull;
import paper.libs.dev.denwav.hypo.model.data.Visibility;
import paper.libs.dev.denwav.hypo.model.data.types.ArrayType;
import paper.libs.dev.denwav.hypo.model.data.types.ClassType;
import paper.libs.dev.denwav.hypo.model.data.types.JvmType;
import paper.libs.dev.denwav.hypo.model.data.types.PrimitiveType;
import paper.libs.org.objectweb.asm.Type;

public final class HypoAsmUtil {
    @NotNull
    public static Visibility accessToVisibility(int access) {
        if ((access & 1) != 0) {
            return Visibility.PUBLIC;
        }
        if ((access & 4) != 0) {
            return Visibility.PROTECTED;
        }
        if ((access & 2) != 0) {
            return Visibility.PRIVATE;
        }
        return Visibility.PACKAGE;
    }

    @NotNull
    public static JvmType toJvmType(@NotNull Type type) {
        if (type == Type.CHAR_TYPE) {
            return PrimitiveType.CHAR;
        }
        if (type == Type.BYTE_TYPE) {
            return PrimitiveType.BYTE;
        }
        if (type == Type.SHORT_TYPE) {
            return PrimitiveType.SHORT;
        }
        if (type == Type.INT_TYPE) {
            return PrimitiveType.INT;
        }
        if (type == Type.LONG_TYPE) {
            return PrimitiveType.LONG;
        }
        if (type == Type.FLOAT_TYPE) {
            return PrimitiveType.FLOAT;
        }
        if (type == Type.DOUBLE_TYPE) {
            return PrimitiveType.DOUBLE;
        }
        if (type == Type.BOOLEAN_TYPE) {
            return PrimitiveType.BOOLEAN;
        }
        if (type == Type.VOID_TYPE) {
            return PrimitiveType.VOID;
        }
        String desc = type.getDescriptor();
        if (desc.startsWith("[")) {
            return new ArrayType(HypoAsmUtil.toJvmType(type.getElementType()), type.getDimensions());
        }
        return new ClassType(desc);
    }
}

