/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.UselessOutputStream;
import io.papermc.paperweight.util.UtilsKt;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Charsets;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\u001aS\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\r\"\u00020\u000b\u00a2\u0006\u0002\u0010\u000e\u001aM\u0010\u0000\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\r\"\u00020\u000b\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"runJar", "", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/jvm/toolchain/JavaLauncher;", "classpath", "Lorg/gradle/api/file/FileCollection;", "workingDir", "", "logFile", "jvmArgs", "", "", "args", "", "(Lorg/gradle/api/provider/Provider;Lorg/gradle/api/file/FileCollection;Ljava/lang/Object;Ljava/lang/Object;Ljava/util/List;[Ljava/lang/String;)V", "(Lorg/gradle/jvm/toolchain/JavaLauncher;Lorg/gradle/api/file/FileCollection;Ljava/lang/Object;Ljava/lang/Object;Ljava/util/List;[Ljava/lang/String;)V", "paperweight-lib"})
public final class Jar_runnerKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void runJar(@NotNull JavaLauncher $this$runJar, @NotNull FileCollection classpath, @NotNull Object workingDir, @Nullable Object logFile, @NotNull List<String> jvmArgs, String ... args) {
        OutputStream outputStream;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)$this$runJar, (String)"$this$runJar");
        Intrinsics.checkNotNullParameter((Object)classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter(jvmArgs, (String)"jvmArgs");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object mainClass = null;
        for (File file : classpath.getFiles()) {
            Object object;
            Closeable closeable = new JarFile(file);
            boolean bl = false;
            boolean bl2 = false;
            objectArray = null;
            try {
                Object jarFile = (JarFile)closeable;
                boolean bl3 = false;
                Manifest manifest = ((JarFile)jarFile).getManifest();
                Intrinsics.checkNotNullExpressionValue((Object)manifest, (String)"jarFile.manifest");
                jarFile = manifest.getMainAttributes().getValue("Main-Class");
                object = jarFile;
            }
            catch (Throwable jarFile) {
                objectArray = jarFile;
                throw jarFile;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)objectArray);
            }
            if (object == null) {
                continue;
            }
            mainClass = object;
            break;
        }
        if (mainClass == null) {
            throw (Throwable)new PaperweightException("Could not determine main class name for " + classpath.getAsPath());
        }
        Path dir = UtilsKt.convertToPath(workingDir);
        if (logFile instanceof OutputStream) {
            outputStream = (OutputStream)logFile;
        } else if (logFile != null) {
            Path log = UtilsKt.convertToPath(logFile);
            Path path = log.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"log.parent");
            Object object = path;
            objectArray = new FileAttribute[]{};
            boolean jarFile = false;
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(objectArray, objectArray.length)), (String)"Files.createDirectories(this, *attributes)");
            object = log;
            objectArray = new OpenOption[]{};
            jarFile = false;
            OutputStream outputStream2 = Files.newOutputStream((Path)object, (OpenOption[])Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"Files.newOutputStream(this, *options)");
            object = outputStream2;
            int n = 8192;
            jarFile = false;
            outputStream = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n);
        } else {
            outputStream = UselessOutputStream.INSTANCE;
        }
        OutputStream output = outputStream;
        SpreadBuilder spreadBuilder = new SpreadBuilder(6);
        RegularFile regularFile = $this$runJar.getExecutablePath();
        Intrinsics.checkNotNullExpressionValue((Object)regularFile, (String)"this.executablePath");
        Path path = FileKt.getPath((FileSystemLocation)regularFile);
        boolean bl = false;
        spreadBuilder.add((Object)((Object)path.toAbsolutePath()).toString());
        Object $this$toTypedArray$iv = jvmArgs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        spreadBuilder.addSpread((Object)stringArray);
        spreadBuilder.add((Object)"-classpath");
        spreadBuilder.add((Object)classpath.getAsPath());
        spreadBuilder.add(mainClass);
        spreadBuilder.addSpread((Object)args);
        ProcessBuilder processBuilder = FileKt.directory(new ProcessBuilder((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()])), dir);
        $this$toTypedArray$iv = output;
        Charset charset = Charsets.UTF_8;
        boolean bl4 = false;
        $this$toTypedArray$iv = new OutputStreamWriter((OutputStream)$this$toTypedArray$iv, charset);
        boolean bl5 = false;
        bl4 = false;
        Object it = $this$toTypedArray$iv;
        boolean bl6 = false;
        Appendable appendable = (Appendable)it;
        StringBuilder stringBuilder = new StringBuilder().append("Command: ");
        List<String> list = processBuilder.command();
        Intrinsics.checkNotNullExpressionValue(list, (String)"processBuilder.command()");
        CharSequence charSequence = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)).toString();
        boolean bl7 = false;
        Appendable appendable2 = appendable.append(charSequence);
        Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(value)");
        Appendable appendable3 = appendable2;
        boolean bl8 = false;
        Intrinsics.checkNotNullExpressionValue((Object)appendable3.append('\n'), (String)"append('\\n')");
        ((OutputStreamWriter)it).flush();
        Process process = processBuilder.start();
        Closeable closeable = output;
        bl4 = false;
        boolean bl9 = false;
        Throwable throwable = null;
        try {
            OutputStream it2 = (OutputStream)closeable;
            boolean bl10 = false;
            Process process2 = process;
            Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
            InputStream inputStream = process2.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
            UtilsKt.redirect(inputStream, it2);
            InputStream inputStream2 = process.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"process.errorStream");
            UtilsKt.redirect(inputStream2, it2);
            int e = process.waitFor();
            if (e != 0) {
                throw (Throwable)new PaperweightException("Execution of " + classpath.getAsPath() + " failed with exit code " + e);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void runJar$default(JavaLauncher javaLauncher, FileCollection fileCollection, Object object, Object object2, List list, String[] stringArray, int n, Object object3) {
        if ((n & 8) != 0) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        Jar_runnerKt.runJar(javaLauncher, fileCollection, object, object2, (List<String>)list, stringArray);
    }

    public static final void runJar(@NotNull Provider<JavaLauncher> $this$runJar, @NotNull FileCollection classpath, @NotNull Object workingDir, @Nullable Object logFile, @NotNull List<String> jvmArgs, String ... args) {
        Intrinsics.checkNotNullParameter($this$runJar, (String)"$this$runJar");
        Intrinsics.checkNotNullParameter((Object)classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter(jvmArgs, (String)"jvmArgs");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object object = $this$runJar.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get()");
        Jar_runnerKt.runJar((JavaLauncher)object, classpath, workingDir, logFile, jvmArgs, Arrays.copyOf(args, args.length));
    }

    public static /* synthetic */ void runJar$default(Provider provider, FileCollection fileCollection, Object object, Object object2, List list, String[] stringArray, int n, Object object3) {
        if ((n & 8) != 0) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        Jar_runnerKt.runJar((Provider<JavaLauncher>)provider, fileCollection, object, object2, (List<String>)list, stringArray);
    }
}

