/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.userdev.internal.setup;

import io.papermc.paperweight.DownloadService;
import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.tasks.ApplyAccessTransformKt;
import io.papermc.paperweight.tasks.FixJarTaskKt;
import io.papermc.paperweight.tasks.GenerateDevBundle;
import io.papermc.paperweight.tasks.GenerateMappingsKt;
import io.papermc.paperweight.tasks.RunForgeFlowerKt;
import io.papermc.paperweight.tasks.ServerBundler;
import io.papermc.paperweight.tasks.TinyRemapper;
import io.papermc.paperweight.userdev.internal.setup.ApplyDevBundlePatchesKt;
import io.papermc.paperweight.userdev.internal.setup.ApplyPaperclipPatchKt;
import io.papermc.paperweight.userdev.internal.setup.ExtractDevBundleKt;
import io.papermc.paperweight.userdev.internal.setup.UserdevSetup;
import io.papermc.paperweight.util.DependenciesKt;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.Filter_jarKt;
import io.papermc.paperweight.util.Ivy_repositoryKt;
import io.papermc.paperweight.util.UtilsKt;
import io.papermc.paperweight.util.constants.ConstantsKt;
import io.papermc.paperweight.util.data.ManifestVersion;
import io.papermc.paperweight.util.data.MinecraftManifest;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.markers.KMutableList;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.RepositoryContentDescriptor;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.kotlin.dsl.NamedDomainObjectCollectionExtensionsKt;
import org.gradle.kotlin.dsl.ProjectExtensionsKt;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paper.libs.com.github.salomonbrys.kotson.ElementKt;
import paper.libs.com.github.salomonbrys.kotson.GsonBuilderKt;
import paper.libs.com.google.gson.Gson;
import paper.libs.com.google.gson.JsonElement;
import paper.libs.com.google.gson.JsonObject;
import paper.libs.com.google.gson.reflect.TypeToken;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u000f\b&\u0018\u0000 W2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006WXYZ[\\B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u000e\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020*2\u0006\u0010+\u001a\u00020,J<\u00101\u001a\u0002022\u0012\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020504\"\u0002052\u0019\b\u0002\u00106\u001a\u0013\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020*07\u00a2\u0006\u0002\b9H\u0002\u00a2\u0006\u0002\u0010:J\u000e\u0010;\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u0010\u0010<\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J0\u0010=\u001a\b\u0012\u0004\u0012\u00020*0>2\u0006\u0010?\u001a\u00020$2\u0006\u0010@\u001a\u00020$2\u0006\u0010A\u001a\u00020\u00052\b\b\u0002\u0010B\u001a\u00020\u000bH\u0002J\u0016\u0010C\u001a\b\u0012\u0004\u0012\u00020D0>2\u0006\u0010E\u001a\u00020\u000bH\u0002J\b\u0010F\u001a\u00020*H\u0002J\b\u0010G\u001a\u00020*H\u0002J\b\u0010H\u001a\u00020*H\u0002J\b\u0010I\u001a\u00020*H\u0002J\u0010\u0010J\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010K\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J!\u0010L\u001a\u00020$2\u0012\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020504\"\u000205H\u0002\u00a2\u0006\u0002\u0010MJ\u0016\u0010L\u001a\u00020$2\f\u00103\u001a\b\u0012\u0004\u0012\u0002050NH\u0002J\u0010\u0010O\u001a\u00020$2\u0006\u0010P\u001a\u00020\u0005H\u0002J\u0016\u0010Q\u001a\u00020$2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00050NH\u0002J\b\u0010S\u001a\u00020$H\u0002J\u0010\u0010T\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010U\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010V\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\bR\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \u0018*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\bR\u000e\u0010!\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup;", "Lorg/gradle/api/services/BuildService;", "Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup$Parameters;", "()V", "accessTransformedServerJar", "Ljava/nio/file/Path;", "cache", "getCache", "()Ljava/nio/file/Path;", "decompiledMinecraftServerJar", "devBundleChanged", "", "devBundleConfig", "Lio/papermc/paperweight/tasks/GenerateDevBundle$DevBundleConfig;", "getDevBundleConfig", "()Lio/papermc/paperweight/tasks/GenerateDevBundle$DevBundleConfig;", "extractDevBundle", "Lkotlin/Pair;", "extractedBundle", "getExtractedBundle", "filteredVanillaServerJar", "fixedMinecraftServerJar", "mappedMinecraftServerJar", "minecraftLibraryJars", "kotlin.jvm.PlatformType", "minecraftVersionManifest", "Lpaper/libs/com/google/gson/JsonObject;", "getMinecraftVersionManifest", "()Lcom/google/gson/JsonObject;", "minecraftVersionManifest$delegate", "Lkotlin/Lazy;", "mojangMappedPaperJar", "getMojangMappedPaperJar", "mojangPlusYarnMappings", "mojangServerMappings", "paperweightHash", "", "patchedSourcesJar", "serverBundlerJar", "setupCompleted", "vanillaServerJar", "accessTransformMinecraftServerJar", "", "context", "Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup$Context;", "addIvyRepository", "project", "Lorg/gradle/api/Project;", "applyMojangMappedPaperclipPatch", "buildHashFunction", "Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup$HashFunction;", "things", "", "", "op", "Lkotlin/Function1;", "Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup$HashFunctionBuilder;", "Lkotlin/ExtensionFunctionType;", "([Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup$HashFunction;", "createOrUpdateIvyRepository", "decompileMinecraftServerJar", "download", "Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup$DownloadResult;", "downloadName", "remote", "destination", "forceDownload", "downloadMinecraftManifest", "Lio/papermc/paperweight/util/data/MinecraftManifest;", "force", "downloadMojangServerMappings", "downloadVanillaServerJar", "extractFromServerBundler", "filterVanillaServerJar", "fixMinecraftServerJar", "generateMappings", "hash", "([Ljava/lang/Object;)Ljava/lang/String;", "", "hashDirectory", "dir", "hashFiles", "files", "hashPaperweightJar", "patchDecompiledSources", "remapMinecraftServerJar", "setupMinecraftVersionManifest", "Companion", "Context", "DownloadResult", "HashFunction", "HashFunctionBuilder", "Parameters", "paperweight-userdev"})
public abstract class UserdevSetup
implements BuildService<Parameters> {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final String paperweightHash = this.hashPaperweightJar();
    @NotNull
    private final Path extractedBundle;
    private final Pair<Boolean, GenerateDevBundle.DevBundleConfig> extractDevBundle;
    private final boolean devBundleChanged;
    @NotNull
    private final GenerateDevBundle.DevBundleConfig devBundleConfig;
    private final Lazy minecraftVersionManifest$delegate;
    private final Path serverBundlerJar;
    private final Path vanillaServerJar;
    private final Path minecraftLibraryJars;
    private final Path filteredVanillaServerJar;
    private final Path mojangServerMappings;
    private final Path mojangPlusYarnMappings;
    private final Path mappedMinecraftServerJar;
    private final Path fixedMinecraftServerJar;
    private final Path accessTransformedServerJar;
    private final Path decompiledMinecraftServerJar;
    private final Path patchedSourcesJar;
    @NotNull
    private final Path mojangMappedPaperJar;
    private boolean setupCompleted;
    private static final Logger LOGGER;
    @NotNull
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(UserdevSetup.class, "minecraftVersionManifest", "getMinecraftVersionManifest()Lcom/google/gson/JsonObject;", 0))};
        Companion = new Companion(null);
        Logger logger = Logging.getLogger(UserdevSetup.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logging.getLogger(UserdevSetup::class.java)");
        LOGGER = logger;
    }

    private final Path getCache() {
        return FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((Parameters)this.getParameters()).getCache()));
    }

    @NotNull
    public final Path getExtractedBundle() {
        return this.extractedBundle;
    }

    @NotNull
    public final GenerateDevBundle.DevBundleConfig getDevBundleConfig() {
        return this.devBundleConfig;
    }

    private final DownloadResult<MinecraftManifest> downloadMinecraftManifest(boolean force) {
        Path path = this.getCache().resolve("paperweight/data/McManifest.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"cache.resolve(MC_MANIFEST)");
        return this.download("minecraft manifest", "https://launchermeta.mojang.com/mc/game/version_manifest.json", path, force).mapData(downloadMinecraftManifest.1.INSTANCE);
    }

    private final JsonObject getMinecraftVersionManifest() {
        Lazy lazy = this.minecraftVersionManifest$delegate;
        UserdevSetup userdevSetup2 = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (JsonObject)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final JsonObject setupMinecraftVersionManifest() {
        Object t;
        void $this$fromJson$iv;
        Object object;
        Object var22_21;
        Gson $this$firstOrNull$iv;
        UserdevSetup userdevSetup2;
        String string;
        block19: {
            Object v1;
            Iterator element$iv2;
            DownloadResult<MinecraftManifest> minecraftManifest = this.downloadMinecraftManifest(this.devBundleChanged);
            if (!minecraftManifest.getDidDownload()) {
                boolean bl;
                block18: {
                    Iterable $this$none$iv = minecraftManifest.getData().getVersions();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Iterator element$iv2 : $this$none$iv) {
                            ManifestVersion it = (ManifestVersion)((Object)element$iv2);
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.devBundleConfig.getMinecraftVersion())) continue;
                            bl = false;
                            break block18;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    minecraftManifest = this.downloadMinecraftManifest(true);
                }
            }
            Iterable $i$f$none = minecraftManifest.getData().getVersions();
            string = "minecraft version manifest";
            userdevSetup2 = this;
            boolean $i$f$firstOrNull = false;
            element$iv2 = $this$firstOrNull$iv.iterator();
            while (element$iv2.hasNext()) {
                Object element$iv3 = element$iv2.next();
                ManifestVersion it = (ManifestVersion)element$iv3;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.devBundleConfig.getMinecraftVersion())) continue;
                v1 = element$iv3;
                break block19;
            }
            v1 = var22_21 = null;
        }
        if ((object = (ManifestVersion)var22_21) == null || (object = ((ManifestVersion)object).getUrl()) == null) {
            throw (Throwable)new PaperweightException("Could not find Minecraft version '" + this.devBundleConfig.getMinecraftVersion() + "' in the downloaded manifest.");
        }
        Path path = this.getCache().resolve("paperweight/data/McVersion.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"cache.resolve(VERSION_JSON)");
        DownloadResult minecraftVersionManifestJson = UserdevSetup.download$default(userdevSetup2, string, (String)object, path, false, 8, null);
        $this$firstOrNull$iv = UtilsKt.getGson();
        Path any$iv = minecraftVersionManifestJson.getPath();
        boolean $i$f$fromJson = false;
        Path path2 = any$iv;
        if (path2 instanceof String) {
            Type type;
            void $receiver$iv$iv = $this$fromJson$iv;
            String string2 = (String)((Object)any$iv);
            void var9_22 = $receiver$iv$iv;
            Type type2 = new TypeToken<JsonObject>(){}.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {} .type");
            Type type$iv$iv$iv = type2;
            if (type$iv$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv)) {
                Type type3 = ((ParameterizedType)type$iv$iv$iv).getRawType();
                type = type3;
                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type.rawType");
            } else {
                type = GsonBuilderKt.removeTypeWildcards(type$iv$iv$iv);
            }
            Type type4 = type;
            Object t2 = var9_22.fromJson(string2, type4);
            t = t2;
            Intrinsics.checkExpressionValueIsNotNull(t2, (String)"fromJson(json, typeToken<T>())");
        } else {
            Object object2 = UtilsKt.convertToPath(any$iv);
            Charset charset = Charsets.UTF_8;
            OpenOption[] type$iv$iv$iv = new OpenOption[]{};
            int n = 8192;
            boolean bl = false;
            object2 = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object2, Arrays.copyOf(type$iv$iv$iv, type$iv$iv$iv.length)), charset), n);
            boolean bl3 = false;
            n = 0;
            Throwable throwable = null;
            try {
                Type type;
                BufferedReader it$iv = (BufferedReader)object2;
                boolean bl4 = false;
                void $receiver$iv$iv = $this$fromJson$iv;
                Reader reader = it$iv;
                void var14_33 = $receiver$iv$iv;
                Type type5 = new TypeToken<JsonObject>(){}.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"object : TypeToken<T>() {} .type");
                Type type$iv$iv$iv2 = type5;
                if (type$iv$iv$iv2 instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv2)) {
                    Type type6 = ((ParameterizedType)type$iv$iv$iv2).getRawType();
                    type = type6;
                    Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"type.rawType");
                } else {
                    type = GsonBuilderKt.removeTypeWildcards(type$iv$iv$iv2);
                }
                Type type7 = type;
                Object t3 = var14_33.fromJson(reader, type7);
                Intrinsics.checkExpressionValueIsNotNull(t3, (String)"fromJson(json, typeToken<T>())");
                Object t4 = t3;
                t = t4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
        return (JsonObject)t;
    }

    private final void downloadVanillaServerJar() {
        JsonElement jsonElement = this.getMinecraftVersionManifest().get("downloads");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"minecraftVersionManifest[\"downloads\"]");
        UserdevSetup.download$default(this, "vanilla minecraft server jar", ElementKt.getString(ElementKt.get(ElementKt.get(jsonElement, "server"), "url")), this.serverBundlerJar, false, 8, null);
    }

    private final void extractFromServerBundler() {
        Path hashFile;
        this.downloadVanillaServerJar();
        HashFunction hashFunction2 = this.buildHashFunction(new Object[]{this.serverBundlerJar, this.vanillaServerJar}, (Function1<? super HashFunctionBuilder, Unit>)((Function1)new Function1<HashFunctionBuilder, Unit>(this){
            final /* synthetic */ UserdevSetup this$0;

            public final void invoke(@NotNull HashFunctionBuilder $this$buildHashFunction) {
                Intrinsics.checkNotNullParameter((Object)$this$buildHashFunction, (String)"$receiver");
                Path path = UserdevSetup.access$getMinecraftLibraryJars$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"minecraftLibraryJars");
                $this$buildHashFunction.add(FileKt.filesMatchingRecursive(path, "*.jar"));
            }
            {
                this.this$0 = userdevSetup2;
                super(1);
            }
        }));
        Path path = hashFile = this.getCache().resolve(ConstantsKt.paperSetupOutput("extractFromServerBundler", "hashes"));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"hashFile");
        if (hashFunction2.upToDate(path)) {
            return;
        }
        LOGGER.lifecycle(":extracting libraries and server from downloaded jar");
        Path path2 = this.minecraftLibraryJars;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"minecraftLibraryJars");
        ServerBundler.INSTANCE.extractFromBundler(this.serverBundlerJar, this.vanillaServerJar, path2, null, null, null, null);
        hashFunction2.writeHash(hashFile);
    }

    private final void filterVanillaServerJar() {
        boolean upToDate;
        this.extractFromServerBundler();
        Path filteredJar = this.filteredVanillaServerJar;
        Path hashFile = filteredJar.resolveSibling(PathsKt.getNameWithoutExtension((Path)filteredJar) + ".hashes");
        Function0 hash2 = (Function0)new Function0<String>(this){
            final /* synthetic */ UserdevSetup this$0;

            @NotNull
            public final String invoke() {
                return UserdevSetup.access$hash(this.this$0, UserdevSetup.access$getVanillaServerJar$p(this.this$0), UserdevSetup.access$getFilteredVanillaServerJar$p(this.this$0), this.this$0.getDevBundleConfig().getBuildData().getVanillaJarIncludes());
            }
            {
                this.this$0 = userdevSetup2;
                super(0);
            }
        };
        Path path = hashFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"hashFile");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean bl = false;
        boolean bl2 = upToDate = Files.isRegularFile(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && Intrinsics.areEqual((Object)PathsKt.readText$default((Path)hashFile, null, (int)1, null), (Object)((String)hash2.invoke()));
        if (upToDate) {
            return;
        }
        LOGGER.lifecycle(":filtering vanilla server jar");
        Filter_jarKt.filterJar$default(this.vanillaServerJar, filteredJar, this.devBundleConfig.getBuildData().getVanillaJarIncludes(), null, 8, null);
        PathsKt.writeText$default((Path)hashFile, (CharSequence)((CharSequence)hash2.invoke()), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    private final void downloadMojangServerMappings() {
        JsonElement jsonElement = this.getMinecraftVersionManifest().get("downloads");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"minecraftVersionManifest[\"downloads\"]");
        UserdevSetup.download$default(this, "mojang server mappings", ElementKt.getString(ElementKt.get(ElementKt.get(jsonElement, "server_mappings"), "url")), this.mojangServerMappings, false, 8, null);
    }

    private final void generateMappings(Context context) {
        boolean upToDate;
        this.extractFromServerBundler();
        this.downloadMojangServerMappings();
        this.filterVanillaServerJar();
        Path mappingsFile = this.mojangPlusYarnMappings;
        Path hashFile = this.getCache().resolve(ConstantsKt.paperSetupOutput("generateMappings", "hashes"));
        Function0 hash2 = (Function0)new Function0<String>(this){
            final /* synthetic */ UserdevSetup this$0;

            @NotNull
            public final String invoke() {
                Object[] objectArray = new Object[3];
                Path path = UserdevSetup.access$getMinecraftLibraryJars$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"minecraftLibraryJars");
                objectArray[0] = FileKt.filesMatchingRecursive(path, "*.jar");
                objectArray[1] = UserdevSetup.access$getMojangServerMappings$p(this.this$0);
                objectArray[2] = UserdevSetup.access$getFilteredVanillaServerJar$p(this.this$0);
                return UserdevSetup.access$hash(this.this$0, objectArray);
            }
            {
                this.this$0 = userdevSetup2;
                super(0);
            }
        };
        Path path = hashFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"hashFile");
        Path path2 = path;
        Object[] objectArray = new LinkOption[]{};
        boolean bl = false;
        boolean bl2 = upToDate = Files.isRegularFile(path2, Arrays.copyOf(objectArray, objectArray.length)) && Intrinsics.areEqual((Object)PathsKt.readText$default((Path)hashFile, null, (int)1, null), (Object)((String)hash2.invoke()));
        if (upToDate) {
            return;
        }
        LOGGER.lifecycle(":generating mappings");
        Path path3 = this.minecraftLibraryJars;
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"minecraftLibraryJars");
        List<Path> list = FileKt.filesMatchingRecursive(path3, "*.jar");
        Provider provider = context.getProject().getConfigurations().named("paramMappings").map((Transformer)generateMappings.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"context.project.configur\u2026IG).map { it.singleFile }");
        GenerateMappingsKt.generateMappings$default(this.filteredVanillaServerJar, list, this.mojangServerMappings, UtilsKt.convertToPath(provider), mappingsFile, context.getWorkerExecutor(), context.getDefaultJavaLauncher(), null, 128, null).await();
        Path path4 = hashFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"hashFile.parent");
        path2 = path4;
        objectArray = new FileAttribute[]{};
        bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, (FileAttribute[])Arrays.copyOf(objectArray, objectArray.length)), (String)"Files.createDirectories(this, *attributes)");
        PathsKt.writeText$default((Path)hashFile, (CharSequence)((CharSequence)hash2.invoke()), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    private final void remapMinecraftServerJar(Context context) {
        boolean upToDate;
        this.generateMappings(context);
        Path output = this.mappedMinecraftServerJar;
        Path logFile = output.resolveSibling(PathsKt.getNameWithoutExtension((Path)output) + ".log");
        Path hashFile = output.resolveSibling(PathsKt.getNameWithoutExtension((Path)output) + ".hashes");
        Function0 hash2 = (Function0)new Function0<String>(this, output){
            final /* synthetic */ UserdevSetup this$0;
            final /* synthetic */ Path $output;

            @NotNull
            public final String invoke() {
                Object[] objectArray = new Object[5];
                Path path = UserdevSetup.access$getMinecraftLibraryJars$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"minecraftLibraryJars");
                objectArray[0] = FileKt.filesMatchingRecursive(path, "*.jar");
                objectArray[1] = UserdevSetup.access$getMojangPlusYarnMappings$p(this.this$0);
                objectArray[2] = UserdevSetup.access$getFilteredVanillaServerJar$p(this.this$0);
                objectArray[3] = this.this$0.getDevBundleConfig().getBuildData().getMinecraftRemapArgs();
                objectArray[4] = this.$output;
                return UserdevSetup.access$hash(this.this$0, objectArray);
            }
            {
                this.this$0 = userdevSetup2;
                this.$output = path;
                super(0);
            }
        };
        Path path = hashFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"hashFile");
        Path path2 = path;
        Object[] objectArray = new LinkOption[]{};
        boolean bl = false;
        boolean bl2 = upToDate = Files.isRegularFile(path2, Arrays.copyOf(objectArray, objectArray.length)) && Intrinsics.areEqual((Object)PathsKt.readText$default((Path)hashFile, null, (int)1, null), (Object)((String)hash2.invoke()));
        if (upToDate) {
            return;
        }
        LOGGER.lifecycle(":remapping minecraft server jar");
        List<String> list = this.devBundleConfig.getBuildData().getMinecraftRemapArgs();
        Path path3 = logFile;
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"logFile");
        Path path4 = this.minecraftLibraryJars;
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"minecraftLibraryJars");
        List<Path> list2 = FileKt.filesMatchingRecursive(path4, "*.jar");
        Object object = context.getProject().getConfigurations().named("remapper").get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.project.configur\u2026ed(REMAPPER_CONFIG).get()");
        TinyRemapper.run$default(TinyRemapper.INSTANCE, list, path3, this.filteredVanillaServerJar, this.mojangPlusYarnMappings, "official", "mojang+yarn", list2, (FileCollection)object, output, context.getDefaultJavaLauncher(), this.getCache(), null, 2048, null);
        Path path5 = hashFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"hashFile.parent");
        path2 = path5;
        objectArray = new FileAttribute[]{};
        bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, (FileAttribute[])Arrays.copyOf(objectArray, objectArray.length)), (String)"Files.createDirectories(this, *attributes)");
        PathsKt.writeText$default((Path)hashFile, (CharSequence)((CharSequence)hash2.invoke()), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    private final void fixMinecraftServerJar(Context context) {
        boolean upToDate;
        this.remapMinecraftServerJar(context);
        Path hashFile = this.fixedMinecraftServerJar.resolveSibling(PathsKt.getNameWithoutExtension((Path)this.fixedMinecraftServerJar) + ".hashes");
        Function0 hash2 = (Function0)new Function0<String>(this){
            final /* synthetic */ UserdevSetup this$0;

            @NotNull
            public final String invoke() {
                return UserdevSetup.access$hash(this.this$0, UserdevSetup.access$getVanillaServerJar$p(this.this$0), UserdevSetup.access$getMappedMinecraftServerJar$p(this.this$0), UserdevSetup.access$getFixedMinecraftServerJar$p(this.this$0));
            }
            {
                this.this$0 = userdevSetup2;
                super(0);
            }
        };
        Path path = hashFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"hashFile");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean bl = false;
        boolean bl2 = upToDate = Files.isRegularFile(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && Intrinsics.areEqual((Object)PathsKt.readText$default((Path)hashFile, null, (int)1, null), (Object)((String)hash2.invoke()));
        if (upToDate) {
            return;
        }
        LOGGER.lifecycle(":fixing minecraft server jar");
        FixJarTaskKt.fixJar$default(context.getWorkerExecutor(), null, context.getDefaultJavaLauncher(), this.vanillaServerJar, this.mappedMinecraftServerJar, this.fixedMinecraftServerJar, 2, null).await();
        PathsKt.writeText$default((Path)hashFile, (CharSequence)((CharSequence)hash2.invoke()), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    private final void accessTransformMinecraftServerJar(Context context) {
        boolean upToDate;
        this.fixMinecraftServerJar(context);
        Path at = this.extractedBundle.resolve(this.devBundleConfig.getBuildData().getAccessTransformFile());
        Path hashFile = this.accessTransformedServerJar.resolveSibling(PathsKt.getNameWithoutExtension((Path)this.accessTransformedServerJar) + ".hashes");
        Function0 hash2 = (Function0)new Function0<String>(this, at){
            final /* synthetic */ UserdevSetup this$0;
            final /* synthetic */ Path $at;

            @NotNull
            public final String invoke() {
                Object[] objectArray = new Object[3];
                objectArray[0] = UserdevSetup.access$getFixedMinecraftServerJar$p(this.this$0);
                Path path = this.$at;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"at");
                objectArray[1] = path;
                objectArray[2] = UserdevSetup.access$getAccessTransformedServerJar$p(this.this$0);
                return UserdevSetup.access$hash(this.this$0, objectArray);
            }
            {
                this.this$0 = userdevSetup2;
                this.$at = path;
                super(0);
            }
        };
        Path path = hashFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"hashFile");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean bl = false;
        boolean bl2 = upToDate = Files.isRegularFile(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && Intrinsics.areEqual((Object)PathsKt.readText$default((Path)hashFile, null, (int)1, null), (Object)((String)hash2.invoke()));
        if (upToDate) {
            return;
        }
        LOGGER.lifecycle(":access transforming minecraft server jar");
        Path path3 = at;
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"at");
        ApplyAccessTransformKt.applyAccessTransform$default(this.fixedMinecraftServerJar, this.accessTransformedServerJar, path3, null, context.getWorkerExecutor(), context.getDefaultJavaLauncher(), 8, null).await();
        PathsKt.writeText$default((Path)hashFile, (CharSequence)((CharSequence)hash2.invoke()), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    private final void decompileMinecraftServerJar(Context context) {
        boolean upToDate;
        this.accessTransformMinecraftServerJar(context);
        Path output = this.decompiledMinecraftServerJar;
        Path logFile = output.resolveSibling(PathsKt.getNameWithoutExtension((Path)output) + ".log");
        Path hashFile = output.resolveSibling(PathsKt.getNameWithoutExtension((Path)output) + ".hashes");
        Function0 hash2 = (Function0)new Function0<String>(this, output){
            final /* synthetic */ UserdevSetup this$0;
            final /* synthetic */ Path $output;

            @NotNull
            public final String invoke() {
                Object[] objectArray = new Object[4];
                Path path = UserdevSetup.access$getMinecraftLibraryJars$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"minecraftLibraryJars");
                objectArray[0] = FileKt.filesMatchingRecursive(path, "*.jar");
                objectArray[1] = UserdevSetup.access$getAccessTransformedServerJar$p(this.this$0);
                objectArray[2] = this.this$0.getDevBundleConfig().getDecompile().getArgs();
                objectArray[3] = this.$output;
                return UserdevSetup.access$hash(this.this$0, objectArray);
            }
            {
                this.this$0 = userdevSetup2;
                this.$output = path;
                super(0);
            }
        };
        Path path = hashFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"hashFile");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean bl = false;
        boolean bl2 = upToDate = Files.isRegularFile(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && Intrinsics.areEqual((Object)PathsKt.readText$default((Path)hashFile, null, (int)1, null), (Object)((String)hash2.invoke()));
        if (upToDate) {
            return;
        }
        LOGGER.lifecycle(":decompiling transformed minecraft server jar");
        List<String> list = this.devBundleConfig.getDecompile().getArgs();
        Path path3 = logFile;
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"logFile");
        Path path4 = this.getCache();
        Object object = context.getProject().getConfigurations().named("decompiler").get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.project.configur\u2026(DECOMPILER_CONFIG).get()");
        FileCollection fileCollection = (FileCollection)object;
        Path path5 = this.minecraftLibraryJars;
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"minecraftLibraryJars");
        RunForgeFlowerKt.runForgeFlower$default(list, path3, path4, fileCollection, this.accessTransformedServerJar, FileKt.filesMatchingRecursive(path5, "*.jar"), output, context.getDefaultJavaLauncher(), null, 256, null);
        PathsKt.writeText$default((Path)hashFile, (CharSequence)((CharSequence)hash2.invoke()), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    private final void patchDecompiledSources(Context context) {
        boolean upToDate;
        this.decompileMinecraftServerJar(context);
        Path patches = this.extractedBundle.resolve(this.devBundleConfig.getPatchDir());
        Path output = this.patchedSourcesJar;
        Path hashFile = output.resolveSibling(PathsKt.getNameWithoutExtension((Path)output) + ".hashes");
        Function0 hash2 = (Function0)new Function0<String>(this, output, patches){
            final /* synthetic */ UserdevSetup this$0;
            final /* synthetic */ Path $output;
            final /* synthetic */ Path $patches;

            @NotNull
            public final String invoke() {
                Object[] objectArray = new Object[3];
                objectArray[0] = this.$output;
                objectArray[1] = UserdevSetup.access$getDecompiledMinecraftServerJar$p(this.this$0);
                Path path = this.$patches;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"patches");
                objectArray[2] = UserdevSetup.access$hashDirectory(this.this$0, path);
                return UserdevSetup.access$hash(this.this$0, objectArray);
            }
            {
                this.this$0 = userdevSetup2;
                this.$output = path;
                this.$patches = path2;
                super(0);
            }
        };
        Path path = hashFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"hashFile");
        Path path2 = path;
        Object[] objectArray = new LinkOption[]{};
        boolean bl = false;
        boolean bl2 = upToDate = Files.isRegularFile(path2, Arrays.copyOf(objectArray, objectArray.length)) && Intrinsics.areEqual((Object)PathsKt.readText$default((Path)hashFile, null, (int)1, null), (Object)((String)hash2.invoke()));
        if (upToDate) {
            return;
        }
        LOGGER.lifecycle(":applying patches to decompiled jar");
        Path path3 = patches;
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"patches");
        ApplyDevBundlePatchesKt.applyDevBundlePatches(this.decompiledMinecraftServerJar, path3, output);
        Path path4 = hashFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"hashFile.parent");
        path2 = path4;
        objectArray = new FileAttribute[]{};
        bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, (FileAttribute[])Arrays.copyOf(objectArray, objectArray.length)), (String)"Files.createDirectories(this, *attributes)");
        PathsKt.writeText$default((Path)hashFile, (CharSequence)((CharSequence)hash2.invoke()), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    @NotNull
    public final Path getMojangMappedPaperJar() {
        return this.mojangMappedPaperJar;
    }

    public final synchronized void applyMojangMappedPaperclipPatch(@NotNull Context context) {
        boolean upToDate;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Path paperclip = this.extractedBundle.resolve(this.devBundleConfig.getBuildData().getMojangMappedPaperclipFile());
        Path output = this.mojangMappedPaperJar;
        Path logFile = output.resolveSibling(PathsKt.getNameWithoutExtension((Path)output) + ".log");
        Path hashFile = output.resolveSibling(PathsKt.getNameWithoutExtension((Path)output) + ".hashes");
        Function0 hash2 = (Function0)new Function0<String>(this, paperclip){
            final /* synthetic */ UserdevSetup this$0;
            final /* synthetic */ Path $paperclip;

            @NotNull
            public final String invoke() {
                Object[] objectArray = new Object[2];
                Path path = this.$paperclip;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"paperclip");
                objectArray[0] = path;
                objectArray[1] = this.this$0.getMojangMappedPaperJar();
                return UserdevSetup.access$hash(this.this$0, objectArray);
            }
            {
                this.this$0 = userdevSetup2;
                this.$paperclip = path;
                super(0);
            }
        };
        Path path = hashFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"hashFile");
        Path path2 = path;
        Object[] objectArray = new LinkOption[]{};
        boolean bl = false;
        boolean bl2 = upToDate = Files.isRegularFile(path2, Arrays.copyOf(objectArray, objectArray.length)) && Intrinsics.areEqual((Object)PathsKt.readText$default((Path)hashFile, null, (int)1, null), (Object)((String)hash2.invoke()));
        if (upToDate) {
            return;
        }
        LOGGER.lifecycle(":applying mojang mapped paperclip patch");
        Project project = context.getProject();
        JavaLauncher javaLauncher = context.getDefaultJavaLauncher();
        Path path3 = paperclip;
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"paperclip");
        Path path4 = logFile;
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"logFile");
        ApplyPaperclipPatchKt.patchPaperclip(project, javaLauncher, path3, output, path4);
        Path path5 = hashFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"hashFile.parent");
        path2 = path5;
        objectArray = new FileAttribute[]{};
        bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, (FileAttribute[])Arrays.copyOf(objectArray, objectArray.length)), (String)"Files.createDirectories(this, *attributes)");
        PathsKt.writeText$default((Path)hashFile, (CharSequence)((CharSequence)hash2.invoke()), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    public final synchronized void createOrUpdateIvyRepository(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.setupCompleted) {
            return;
        }
        this.patchDecompiledSources(context);
        this.applyMojangMappedPaperclipPatch(context);
        Path path = this.getCache().resolve("paperweight/ivyRepository");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"cache.resolve(IVY_REPOSITORY)");
        boolean didInstall = Ivy_repositoryKt.installToIvyRepo(path, this.devBundleConfig.getMappedServerCoordinates(), CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.toList((Iterable)this.devBundleConfig.getBuildData().getCompileDependencies()), (Object)this.devBundleConfig.getApiCoordinates()), (Object)this.devBundleConfig.getMojangApiCoordinates()), this.patchedSourcesJar, this.mojangMappedPaperJar);
        if (didInstall) {
            LOGGER.lifecycle(":installed server artifacts to cache");
            LOGGER.lifecycle(":done setting up paperweight userdev workspace");
        }
        this.setupCompleted = true;
    }

    public final void addIvyRepository(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectExtensionsKt.repositories((Project)project, (Function1)((Function1)new Function1<RepositoryHandler, Unit>(this){
            final /* synthetic */ UserdevSetup this$0;

            public final void invoke(@NotNull RepositoryHandler $this$repositories) {
                Intrinsics.checkNotNullParameter((Object)$this$repositories, (String)"$receiver");
                Path path = UserdevSetup.access$getCache$p(this.this$0).resolve("paperweight/ivyRepository");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"cache.resolve(IVY_REPOSITORY)");
                Ivy_repositoryKt.setupIvyRepository($this$repositories, path, (Function1<? super IvyArtifactRepository, Unit>)((Function1)new Function1<IvyArtifactRepository, Unit>(this){
                    final /* synthetic */ addIvyRepository.1 this$0;

                    public final void invoke(@NotNull IvyArtifactRepository $this$setupIvyRepository) {
                        Intrinsics.checkNotNullParameter((Object)$this$setupIvyRepository, (String)"$receiver");
                        $this$setupIvyRepository.content(new Action(this){
                            final /* synthetic */ addIvyRepository.1 this$0;

                            public final void execute(@NotNull RepositoryContentDescriptor $this$content) {
                                Intrinsics.checkNotNullParameter((Object)$this$content, (String)"$receiver");
                                DependenciesKt.includeFromDependencyNotation($this$content, this.this$0.this$0.this$0.getDevBundleConfig().getMappedServerCoordinates());
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = userdevSetup2;
                super(1);
            }
        }));
    }

    private final String hash(Object ... things) {
        return this.hash(ArraysKt.toList((Object[])things));
    }

    private final String hash(List<? extends Object> things) {
        boolean bl = false;
        ArrayList<Object> strings = new ArrayList<Object>();
        boolean bl2 = false;
        ArrayList<Object> paths = new ArrayList<Object>();
        for (Object object : things) {
            Object object2 = object;
            if (object2 instanceof String) {
                strings.add(object);
                continue;
            }
            if (object2 instanceof Path) {
                paths.add(object);
                continue;
            }
            if (object2 instanceof Iterable) {
                strings.add(this.hash(CollectionsKt.filterNotNull((Iterable)((Iterable)object))));
                continue;
            }
            String string = "Unknown type: " + object.getClass().getName();
            boolean bl3 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.hashFiles((List<? extends Path>)paths) + (strings.isEmpty() ? "" : "\n" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)strings), (CharSequence)"\n", null, null, (int)0, null, (Function1)hash.1.INSTANCE, (int)30, null));
    }

    private final String hashFiles(List<? extends Path> files) {
        Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)files), (Function1)hashFiles.1.INSTANCE);
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        return SequencesKt.joinToString$default((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Path it = (Path)a;
                boolean bl2 = false;
                Path path = it;
                boolean bl3 = false;
                it = (Path)b;
                Comparable comparable = (Comparable)((Object)((Object)path).toString());
                bl2 = false;
                path = it;
                bl3 = false;
                String string = ((Object)path).toString();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
            }
        }), (CharSequence)"\n", null, null, (int)0, null, (Function1)hashFiles.3.INSTANCE, (int)30, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String hashDirectory(Path dir) {
        String string;
        AutoCloseable autoCloseable = Files.walk(dir, new FileVisitOption[0]);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl3 = false;
            List list = stream.filter(hashDirectory.1.1.INSTANCE).collect(Collectors.toList());
            Intrinsics.checkNotNullExpressionValue(list, (String)"stream.filter { it.isReg\u2026lect(Collectors.toList())");
            string = this.hashFiles(list);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private final DownloadResult<Unit> download(String downloadName, String remote, Path destination, boolean forceDownload) {
        hashFile = destination.resolveSibling(PathsKt.getName((Path)destination) + ".hashes");
        if (forceDownload) ** GOTO lbl-1000
        v0 = hashFile;
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"hashFile");
        var7_6 = v0;
        var8_7 = new LinkOption[]{};
        var9_8 = false;
        if (Files.isRegularFile(var7_6, Arrays.copyOf(var8_7, var8_7.length)) && Intrinsics.areEqual((Object)PathsKt.readText$default((Path)hashFile, null, (int)1, null), (Object)this.hash(new Object[]{remote, destination}))) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = upToDate = false;
        }
        if (upToDate) {
            return new DownloadResult<Unit>(destination, false, Unit.INSTANCE);
        }
        UserdevSetup.LOGGER.lifecycle(":downloading " + downloadName);
        v2 = destination.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"destination.parent");
        var7_6 = v2;
        var8_7 = new FileAttribute[]{};
        var9_8 = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(var7_6, (FileAttribute[])Arrays.copyOf(var8_7, var8_7.length)), (String)"Files.createDirectories(this, *attributes)");
        ((DownloadService)((Parameters)this.getParameters()).getDownloadService().get()).download(remote, (Object)destination);
        v3 = hashFile;
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"hashFile");
        PathsKt.writeText$default((Path)v3, (CharSequence)this.hash(new Object[]{remote, destination}), null, (OpenOption[])new OpenOption[0], (int)2, null);
        return new DownloadResult<Unit>(destination, true, Unit.INSTANCE);
    }

    static /* synthetic */ DownloadResult download$default(UserdevSetup userdevSetup2, String string, String string2, Path path, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: download");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return userdevSetup2.download(string, string2, path, bl);
    }

    private final HashFunction buildHashFunction(Object[] things, Function1<? super HashFunctionBuilder, Unit> op) {
        return new HashFunction(this, op, things){
            final /* synthetic */ UserdevSetup this$0;
            final /* synthetic */ Function1 $op;
            final /* synthetic */ Object[] $things;

            @NotNull
            public final String invoke() {
                HashFunctionBuilder builder = HashFunctionBuilder.Companion.create();
                this.$op.invoke((Object)builder);
                if (builder.getIncludePaperweightHash()) {
                    builder.add(UserdevSetup.access$getPaperweightHash$p(this.this$0));
                }
                builder.addAll(Arrays.copyOf(this.$things, this.$things.length));
                return UserdevSetup.access$hash(this.this$0, builder);
            }
            {
                this.this$0 = userdevSetup2;
                this.$op = function1;
                this.$things = objectArray;
            }
        };
    }

    static /* synthetic */ HashFunction buildHashFunction$default(UserdevSetup userdevSetup2, Object[] objectArray, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildHashFunction");
        }
        if ((n & 2) != 0) {
            function1 = buildHashFunction.1.INSTANCE;
        }
        return userdevSetup2.buildHashFunction(objectArray, (Function1<? super HashFunctionBuilder, Unit>)function1);
    }

    private final String hashPaperweightJar() {
        ProtectionDomain protectionDomain = UserdevSetup.class.getProtectionDomain();
        Intrinsics.checkNotNullExpressionValue((Object)protectionDomain, (String)"UserdevSetup::class.java.protectionDomain");
        CodeSource codeSource = protectionDomain.getCodeSource();
        Intrinsics.checkNotNullExpressionValue((Object)codeSource, (String)"UserdevSetup::class.java\u2026otectionDomain.codeSource");
        Path userdevShadowJar = Paths.get(codeSource.getLocation().toURI());
        Object[] objectArray = new Object[1];
        Path path = userdevShadowJar;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"userdevShadowJar");
        objectArray[0] = path;
        return this.hash(objectArray);
    }

    public UserdevSetup() {
        Path path = this.getCache().resolve(ConstantsKt.paperSetupOutput("extractDevBundle", "dir"));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"cache.resolve(paperSetup\u2026xtractDevBundle\", \"dir\"))");
        this.extractedBundle = path;
        this.extractDevBundle = ExtractDevBundleKt.extractDevBundle(this.extractedBundle, FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((Parameters)this.getParameters()).getBundleZip())));
        this.devBundleChanged = (Boolean)this.extractDevBundle.getFirst();
        this.devBundleConfig = (GenerateDevBundle.DevBundleConfig)this.extractDevBundle.getSecond();
        this.minecraftVersionManifest$delegate = (Lazy)NamedDomainObjectCollectionExtensionsKt.provideDelegate((Object)LazyKt.lazy((Function0)((Function0)new Function0<JsonObject>(this){
            final /* synthetic */ UserdevSetup this$0;

            @NotNull
            public final JsonObject invoke() {
                return UserdevSetup.access$setupMinecraftVersionManifest(this.this$0);
            }
            {
                this.this$0 = userdevSetup2;
                super(0);
            }
        })), (Object)this, (KProperty)$$delegatedProperties[0]);
        Path path2 = this.getCache().resolve(ConstantsKt.paperSetupOutput("downloadServerJar", "jar"));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"cache.resolve(paperSetup\u2026wnloadServerJar\", \"jar\"))");
        this.serverBundlerJar = path2;
        Path path3 = this.getCache().resolve(ConstantsKt.paperSetupOutput("vanillaServerJar", "jar"));
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"cache.resolve(paperSetup\u2026anillaServerJar\", \"jar\"))");
        this.vanillaServerJar = path3;
        this.minecraftLibraryJars = this.getCache().resolve("paperweight/jars/minecraft");
        Path path4 = this.getCache().resolve(ConstantsKt.paperSetupOutput("filterJar", "jar"));
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"cache.resolve(paperSetup\u2026tput(\"filterJar\", \"jar\"))");
        this.filteredVanillaServerJar = path4;
        Path path5 = this.getCache().resolve("paperweight/mappings/server_mappings.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"cache.resolve(SERVER_MAPPINGS)");
        this.mojangServerMappings = path5;
        Path path6 = this.getCache().resolve("paperweight/mappings/official-mojang+yarn.tiny");
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"cache.resolve(MOJANG_YARN_MAPPINGS)");
        this.mojangPlusYarnMappings = path6;
        Path path7 = this.getCache().resolve(ConstantsKt.paperSetupOutput("mappedMinecraftServerJar", "jar"));
        Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"cache.resolve(paperSetup\u2026ecraftServerJar\", \"jar\"))");
        this.mappedMinecraftServerJar = path7;
        Path path8 = this.getCache().resolve(ConstantsKt.paperSetupOutput("fixedMinecraftServerJar", "jar"));
        Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"cache.resolve(paperSetup\u2026ecraftServerJar\", \"jar\"))");
        this.fixedMinecraftServerJar = path8;
        Path path9 = this.getCache().resolve(ConstantsKt.paperSetupOutput("accessTransformedServerJar", "jar"));
        Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"cache.resolve(paperSetup\u2026formedServerJar\", \"jar\"))");
        this.accessTransformedServerJar = path9;
        Path path10 = this.getCache().resolve(ConstantsKt.paperSetupOutput("decompileMinecraftServerJar", "jar"));
        Intrinsics.checkNotNullExpressionValue((Object)path10, (String)"cache.resolve(paperSetup\u2026ecraftServerJar\", \"jar\"))");
        this.decompiledMinecraftServerJar = path10;
        Path path11 = this.getCache().resolve(ConstantsKt.paperSetupOutput("patchedSourcesJar", "jar"));
        Intrinsics.checkNotNullExpressionValue((Object)path11, (String)"cache.resolve(paperSetup\u2026tchedSourcesJar\", \"jar\"))");
        this.patchedSourcesJar = path11;
        Path path12 = this.getCache().resolve(ConstantsKt.paperSetupOutput("applyMojangMappedPaperclipPatch", "jar"));
        Intrinsics.checkNotNullExpressionValue((Object)path12, (String)"cache.resolve(paperSetup\u2026dPaperclipPatch\", \"jar\"))");
        this.mojangMappedPaperJar = path12;
    }

    public static final /* synthetic */ Path access$getMinecraftLibraryJars$p(UserdevSetup $this) {
        return $this.minecraftLibraryJars;
    }

    public static final /* synthetic */ String access$hash(UserdevSetup $this, Object ... things) {
        return $this.hash(things);
    }

    public static final /* synthetic */ Path access$getVanillaServerJar$p(UserdevSetup $this) {
        return $this.vanillaServerJar;
    }

    public static final /* synthetic */ Path access$getFilteredVanillaServerJar$p(UserdevSetup $this) {
        return $this.filteredVanillaServerJar;
    }

    public static final /* synthetic */ Path access$getMojangServerMappings$p(UserdevSetup $this) {
        return $this.mojangServerMappings;
    }

    public static final /* synthetic */ Path access$getMojangPlusYarnMappings$p(UserdevSetup $this) {
        return $this.mojangPlusYarnMappings;
    }

    public static final /* synthetic */ Path access$getMappedMinecraftServerJar$p(UserdevSetup $this) {
        return $this.mappedMinecraftServerJar;
    }

    public static final /* synthetic */ Path access$getFixedMinecraftServerJar$p(UserdevSetup $this) {
        return $this.fixedMinecraftServerJar;
    }

    public static final /* synthetic */ Path access$getAccessTransformedServerJar$p(UserdevSetup $this) {
        return $this.accessTransformedServerJar;
    }

    public static final /* synthetic */ Path access$getDecompiledMinecraftServerJar$p(UserdevSetup $this) {
        return $this.decompiledMinecraftServerJar;
    }

    public static final /* synthetic */ String access$hashDirectory(UserdevSetup $this, Path dir) {
        return $this.hashDirectory(dir);
    }

    public static final /* synthetic */ Path access$getCache$p(UserdevSetup $this) {
        return $this.getCache();
    }

    public static final /* synthetic */ String access$getPaperweightHash$p(UserdevSetup $this) {
        return $this.paperweightHash;
    }

    public static final /* synthetic */ String access$hash(UserdevSetup $this, List things) {
        return $this.hash(things);
    }

    public static final /* synthetic */ JsonObject access$setupMinecraftVersionManifest(UserdevSetup $this) {
        return $this.setupMinecraftVersionManifest();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup$Context;", "", "project", "Lorg/gradle/api/Project;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "javaToolchainService", "Lorg/gradle/jvm/toolchain/JavaToolchainService;", "(Lorg/gradle/api/Project;Lorg/gradle/workers/WorkerExecutor;Lorg/gradle/jvm/toolchain/JavaToolchainService;)V", "defaultJavaLauncher", "Lorg/gradle/jvm/toolchain/JavaLauncher;", "getDefaultJavaLauncher", "()Lorg/gradle/jvm/toolchain/JavaLauncher;", "getJavaToolchainService", "()Lorg/gradle/jvm/toolchain/JavaToolchainService;", "getProject", "()Lorg/gradle/api/Project;", "getWorkerExecutor", "()Lorg/gradle/workers/WorkerExecutor;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "paperweight-userdev"})
    public static final class Context {
        @NotNull
        private final Project project;
        @NotNull
        private final WorkerExecutor workerExecutor;
        @NotNull
        private final JavaToolchainService javaToolchainService;

        @NotNull
        public final JavaLauncher getDefaultJavaLauncher() {
            Object object = UtilsKt.defaultJavaLauncher(this.javaToolchainService, this.project).get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"javaToolchainService.def\u2026vaLauncher(project).get()");
            return (JavaLauncher)object;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final WorkerExecutor getWorkerExecutor() {
            return this.workerExecutor;
        }

        @NotNull
        public final JavaToolchainService getJavaToolchainService() {
            return this.javaToolchainService;
        }

        public Context(@NotNull Project project, @NotNull WorkerExecutor workerExecutor, @NotNull JavaToolchainService javaToolchainService) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
            Intrinsics.checkNotNullParameter((Object)javaToolchainService, (String)"javaToolchainService");
            this.project = project;
            this.workerExecutor = workerExecutor;
            this.javaToolchainService = javaToolchainService;
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final WorkerExecutor component2() {
            return this.workerExecutor;
        }

        @NotNull
        public final JavaToolchainService component3() {
            return this.javaToolchainService;
        }

        @NotNull
        public final Context copy(@NotNull Project project, @NotNull WorkerExecutor workerExecutor, @NotNull JavaToolchainService javaToolchainService) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
            Intrinsics.checkNotNullParameter((Object)javaToolchainService, (String)"javaToolchainService");
            return new Context(project, workerExecutor, javaToolchainService);
        }

        public static /* synthetic */ Context copy$default(Context context, Project project, WorkerExecutor workerExecutor, JavaToolchainService javaToolchainService, int n, Object object) {
            if ((n & 1) != 0) {
                project = context.project;
            }
            if ((n & 2) != 0) {
                workerExecutor = context.workerExecutor;
            }
            if ((n & 4) != 0) {
                javaToolchainService = context.javaToolchainService;
            }
            return context.copy(project, workerExecutor, javaToolchainService);
        }

        @NotNull
        public String toString() {
            return "Context(project=" + this.project + ", workerExecutor=" + this.workerExecutor + ", javaToolchainService=" + this.javaToolchainService + ")";
        }

        public int hashCode() {
            Project project = this.project;
            WorkerExecutor workerExecutor = this.workerExecutor;
            JavaToolchainService javaToolchainService = this.javaToolchainService;
            return ((project != null ? project.hashCode() : 0) * 31 + (workerExecutor != null ? workerExecutor.hashCode() : 0)) * 31 + (javaToolchainService != null ? javaToolchainService.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Context)) break block3;
                    Context context = (Context)object;
                    if (!Intrinsics.areEqual((Object)this.project, (Object)context.project) || !Intrinsics.areEqual((Object)this.workerExecutor, (Object)context.workerExecutor) || !Intrinsics.areEqual((Object)this.javaToolchainService, (Object)context.javaToolchainService)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "bundleZip", "Lorg/gradle/api/file/RegularFileProperty;", "getBundleZip", "()Lorg/gradle/api/file/RegularFileProperty;", "cache", "getCache", "downloadService", "Lorg/gradle/api/provider/Property;", "Lio/papermc/paperweight/DownloadService;", "getDownloadService", "()Lorg/gradle/api/provider/Property;", "paperweight-userdev"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public RegularFileProperty getBundleZip();

        @NotNull
        public RegularFileProperty getCache();

        @NotNull
        public Property<DownloadService> getDownloadService();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\u000e\u0010\u0012\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ2\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J,\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u0000\"\u0004\b\u0001\u0010\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u0002H\u001a0\u001cJ\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0013\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup$DownloadResult;", "D", "", "path", "Ljava/nio/file/Path;", "didDownload", "", "data", "(Ljava/nio/file/Path;ZLjava/lang/Object;)V", "getData", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getDidDownload", "()Z", "getPath", "()Ljava/nio/file/Path;", "component1", "component2", "component3", "copy", "(Ljava/nio/file/Path;ZLjava/lang/Object;)Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup$DownloadResult;", "equals", "other", "hashCode", "", "mapData", "N", "mapper", "Lkotlin/Function1;", "toString", "", "paperweight-userdev"})
    private static final class DownloadResult<D> {
        @NotNull
        private final Path path;
        private final boolean didDownload;
        private final D data;

        @NotNull
        public final <N> DownloadResult<N> mapData(@NotNull Function1<? super DownloadResult<D>, ? extends N> mapper) {
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            return new DownloadResult<Object>(this.path, this.didDownload, mapper.invoke((Object)this));
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        public final boolean getDidDownload() {
            return this.didDownload;
        }

        public final D getData() {
            return this.data;
        }

        public DownloadResult(@NotNull Path path, boolean didDownload, D data) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.path = path;
            this.didDownload = didDownload;
            this.data = data;
        }

        @NotNull
        public final Path component1() {
            return this.path;
        }

        public final boolean component2() {
            return this.didDownload;
        }

        public final D component3() {
            return this.data;
        }

        @NotNull
        public final DownloadResult<D> copy(@NotNull Path path, boolean didDownload, D data) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new DownloadResult<D>(path, didDownload, data);
        }

        public static /* synthetic */ DownloadResult copy$default(DownloadResult downloadResult, Path path, boolean bl, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                path = downloadResult.path;
            }
            if ((n & 2) != 0) {
                bl = downloadResult.didDownload;
            }
            if ((n & 4) != 0) {
                object = downloadResult.data;
            }
            return downloadResult.copy(path, bl, object);
        }

        @NotNull
        public String toString() {
            return "DownloadResult(path=" + this.path + ", didDownload=" + this.didDownload + ", data=" + this.data + ")";
        }

        public int hashCode() {
            Path path = this.path;
            int n = (path != null ? ((Object)path).hashCode() : 0) * 31;
            int n2 = this.didDownload ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            D d = this.data;
            return (n + n2) * 31 + (d != null ? d.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DownloadResult)) break block3;
                    DownloadResult downloadResult = (DownloadResult)object;
                    if (!Intrinsics.areEqual((Object)this.path, (Object)downloadResult.path) || this.didDownload != downloadResult.didDownload || !Intrinsics.areEqual(this.data, downloadResult.data)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\bb\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\r\u000eJ!\u0010\t\u001a\u00020\u00042\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000b\"\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\fR\u0018\u0010\u0003\u001a\u00020\u0004X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup$HashFunctionBuilder;", "", "", "includePaperweightHash", "", "getIncludePaperweightHash", "()Z", "setIncludePaperweightHash", "(Z)V", "addAll", "things", "", "([Ljava/lang/Object;)Z", "Companion", "HashFunctionBuilderImpl", "paperweight-userdev"})
    private static interface HashFunctionBuilder
    extends List<Object>,
    KMutableList {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean getIncludePaperweightHash();

        public void setIncludePaperweightHash(boolean var1);

        default public boolean addAll(Object ... things) {
            Intrinsics.checkNotNullParameter((Object)things, (String)"things");
            return this.addAll(ArraysKt.toList((Object[])things));
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0003H\u0096\u0001J\u0019\u0010\u000e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0096\u0001J\u001f\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0096\u0001J\u0017\u0010\u0012\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0096\u0001J\t\u0010\u0015\u001a\u00020\u0010H\u0096\u0001J\u0011\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0003H\u0096\u0003J\u0017\u0010\u0017\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0096\u0001J\u0011\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000bH\u0096\u0003J\u0011\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0096\u0001J\t\u0010\u001a\u001a\u00020\u0005H\u0096\u0001J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001cH\u0096\u0003J\u0011\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0096\u0001J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0096\u0001J\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001f2\u0006\u0010\u0011\u001a\u00020\u000bH\u0096\u0001J\u0011\u0010 \u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0003H\u0096\u0001J\u0017\u0010!\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0096\u0001J\u0011\u0010\"\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000bH\u0096\u0001J\u0017\u0010#\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0096\u0001J\u0019\u0010$\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0096\u0003J\u001f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000bH\u0096\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006R\u0012\u0010\n\u001a\u00020\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006("}, d2={"Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup$HashFunctionBuilder$HashFunctionBuilderImpl;", "Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup$HashFunctionBuilder;", "", "", "includePaperweightHash", "", "(Z)V", "getIncludePaperweightHash", "()Z", "setIncludePaperweightHash", "size", "", "getSize", "()I", "add", "element", "", "index", "addAll", "elements", "", "clear", "contains", "containsAll", "get", "indexOf", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "remove", "removeAll", "removeAt", "retainAll", "set", "subList", "fromIndex", "toIndex", "paperweight-userdev"})
        private static final class HashFunctionBuilderImpl
        implements HashFunctionBuilder,
        List<Object>,
        KMutableList {
            private boolean includePaperweightHash;
            private final /* synthetic */ ArrayList<Object> $$delegate_0;

            @Override
            public boolean getIncludePaperweightHash() {
                return this.includePaperweightHash;
            }

            @Override
            public void setIncludePaperweightHash(boolean bl) {
                this.includePaperweightHash = bl;
            }

            public HashFunctionBuilderImpl(boolean includePaperweightHash) {
                this.$$delegate_0 = new ArrayList();
                this.includePaperweightHash = includePaperweightHash;
            }

            public /* synthetic */ HashFunctionBuilderImpl(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = true;
                }
                this(bl);
            }

            public HashFunctionBuilderImpl() {
                this(false, 1, null);
            }

            public int getSize() {
                return this.$$delegate_0.size();
            }

            @Override
            public boolean add(@NotNull Object element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return this.$$delegate_0.add(element);
            }

            @Override
            public void add(int index, @NotNull Object element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                this.$$delegate_0.add(index, element);
            }

            @Override
            public boolean addAll(int index, @NotNull Collection<? extends Object> elements) {
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                return this.$$delegate_0.addAll(index, elements);
            }

            @Override
            public boolean addAll(@NotNull Collection<? extends Object> elements) {
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                return this.$$delegate_0.addAll(elements);
            }

            @Override
            public void clear() {
                this.$$delegate_0.clear();
            }

            @Override
            public boolean contains(@NotNull Object element) {
                if (element == null) {
                    return false;
                }
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return this.$$delegate_0.contains(element);
            }

            @Override
            public boolean containsAll(@NotNull Collection<? extends Object> elements) {
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                return this.$$delegate_0.containsAll(elements);
            }

            @Override
            @NotNull
            public Object get(int index) {
                Object object = this.$$delegate_0.get(index);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                return object;
            }

            @Override
            public int indexOf(@NotNull Object element) {
                if (element == null) {
                    return -1;
                }
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return this.$$delegate_0.indexOf(element);
            }

            @Override
            public boolean isEmpty() {
                return this.$$delegate_0.isEmpty();
            }

            @Override
            @NotNull
            public Iterator<Object> iterator() {
                Iterator<Object> iterator = this.$$delegate_0.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                return iterator;
            }

            @Override
            public int lastIndexOf(@NotNull Object element) {
                if (element == null) {
                    return -1;
                }
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return this.$$delegate_0.lastIndexOf(element);
            }

            @Override
            @NotNull
            public ListIterator<Object> listIterator() {
                ListIterator<Object> listIterator = this.$$delegate_0.listIterator();
                Intrinsics.checkNotNullExpressionValue(listIterator, (String)"listIterator(...)");
                return listIterator;
            }

            @Override
            @NotNull
            public ListIterator<Object> listIterator(int index) {
                ListIterator<Object> listIterator = this.$$delegate_0.listIterator(index);
                Intrinsics.checkNotNullExpressionValue(listIterator, (String)"listIterator(...)");
                return listIterator;
            }

            @Override
            public boolean remove(@NotNull Object element) {
                if (element == null) {
                    return false;
                }
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return this.$$delegate_0.remove(element);
            }

            @Override
            public boolean removeAll(@NotNull Collection<? extends Object> elements) {
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                return this.$$delegate_0.removeAll(elements);
            }

            @NotNull
            public Object removeAt(int index) {
                Object object = this.$$delegate_0.remove(index);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"removeAt(...)");
                return object;
            }

            @Override
            public boolean retainAll(@NotNull Collection<? extends Object> elements) {
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                return this.$$delegate_0.retainAll(elements);
            }

            @Override
            @NotNull
            public Object set(int index, @NotNull Object element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Object object = this.$$delegate_0.set(index, element);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"set(...)");
                return object;
            }

            @Override
            @NotNull
            public List<Object> subList(int fromIndex, int toIndex) {
                List<Object> list = this.$$delegate_0.subList(fromIndex, toIndex);
                Intrinsics.checkNotNullExpressionValue(list, (String)"subList(...)");
                return list;
            }

            @Override
            public Object[] toArray() {
                return CollectionToArray.toArray((Collection)this);
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                return CollectionToArray.toArray((Collection)this, (Object[])TArray);
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup$HashFunctionBuilder$Companion;", "", "()V", "create", "Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup$HashFunctionBuilder;", "paperweight-userdev"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            @NotNull
            public final HashFunctionBuilder create() {
                return new HashFunctionBuilderImpl(false, 1, null);
            }

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00e2\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup$HashFunction;", "Lkotlin/Function0;", "", "upToDate", "", "hashFile", "Ljava/nio/file/Path;", "writeHash", "", "paperweight-userdev"})
    private static interface HashFunction
    extends Function0<String> {
        default public void writeHash(@NotNull Path hashFile) {
            Intrinsics.checkNotNullParameter((Object)hashFile, (String)"hashFile");
            Path path = hashFile.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"hashFile.parent");
            Path path2 = path;
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
            PathsKt.writeText$default((Path)hashFile, (CharSequence)((CharSequence)this.invoke()), null, (OpenOption[])new OpenOption[0], (int)2, null);
        }

        default public boolean upToDate(@NotNull Path hashFile) {
            Intrinsics.checkNotNullParameter((Object)hashFile, (String)"hashFile");
            Path path = hashFile;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            boolean bl = false;
            return Files.isRegularFile(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && Intrinsics.areEqual((Object)PathsKt.readText$default((Path)hashFile, null, (int)1, null), (Object)((String)this.invoke()));
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/papermc/paperweight/userdev/internal/setup/UserdevSetup$Companion;", "", "()V", "LOGGER", "Lorg/gradle/api/logging/Logger;", "paperweight-userdev"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

