/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.userdev.internal.setup;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.tasks.GenerateDevBundle;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.UtilsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import paper.libs.com.github.salomonbrys.kotson.GsonBuilderKt;
import paper.libs.com.google.gson.Gson;
import paper.libs.com.google.gson.reflect.TypeToken;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\"\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"extractDevBundle", "Lkotlin/Pair;", "", "Lio/papermc/paperweight/tasks/GenerateDevBundle$DevBundleConfig;", "destinationDirectory", "Ljava/nio/file/Path;", "devBundle", "readDevBundleConfig", "extractedDevBundlePath", "paperweight-userdev"})
public final class ExtractDevBundleKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Pair<Boolean, GenerateDevBundle.DevBundleConfig> extractDevBundle(@NotNull Path destinationDirectory, @NotNull Path devBundle) {
        Intrinsics.checkNotNullParameter((Object)destinationDirectory, (String)"destinationDirectory");
        Intrinsics.checkNotNullParameter((Object)devBundle, (String)"devBundle");
        Path hashFile = destinationDirectory.resolve("current.sha256");
        String newDevBundleHash = UtilsKt.toHex(FileKt.hashFile(devBundle, UtilsKt.getDigestSha256()));
        Object object = destinationDirectory;
        Object object2 = new LinkOption[]{};
        boolean bl = false;
        if (Files.exists((Path)object, Arrays.copyOf(object2, ((LinkOption[])object2).length))) {
            Path path = hashFile;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"hashFile");
            object2 = path;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            boolean bl2 = false;
            String currentDevBundleHash = Files.isRegularFile((Path)object2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? PathsKt.readText((Path)hashFile, (Charset)Charsets.UTF_8) : "";
            object2 = currentDevBundleHash;
            bl = false;
            if (!StringsKt.isBlank((CharSequence)object2) && Intrinsics.areEqual((Object)newDevBundleHash, (Object)currentDevBundleHash)) {
                return TuplesKt.to((Object)false, (Object)ExtractDevBundleKt.readDevBundleConfig(destinationDirectory));
            }
            FileKt.deleteRecursively$default(destinationDirectory, null, 1, null);
        }
        object = destinationDirectory;
        object2 = new FileAttribute[]{};
        bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, (FileAttribute[])Arrays.copyOf(object2, ((LinkOption[])object2).length)), (String)"Files.createDirectories(this, *attributes)");
        Path path = hashFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"hashFile");
        PathsKt.writeText((Path)path, (CharSequence)newDevBundleHash, (Charset)Charsets.UTF_8, (OpenOption[])new OpenOption[0]);
        object = FileKt.openZip(devBundle);
        boolean bl3 = false;
        bl = false;
        Throwable throwable = null;
        try {
            FileSystem fs = (FileSystem)object;
            boolean bl4 = false;
            Path path2 = fs.getPath("/", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"fs.getPath(\"/\")");
            FileKt.copyRecursivelyTo(path2, destinationDirectory);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return TuplesKt.to((Object)true, (Object)ExtractDevBundleKt.readDevBundleConfig(destinationDirectory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final GenerateDevBundle.DevBundleConfig readDevBundleConfig(@NotNull Path extractedDevBundlePath) {
        Path configFile;
        Intrinsics.checkNotNullParameter((Object)extractedDevBundlePath, (String)"extractedDevBundlePath");
        Path path = extractedDevBundlePath.resolve("data-version.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"extractedDevBundlePath.resolve(\"data-version.txt\")");
        String string = PathsKt.readText$default((Path)path, null, (int)1, null);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        bl = false;
        int dataVersion = Integer.parseInt(string);
        if (dataVersion != 3) {
            throw (Throwable)new PaperweightException("The paperweight development bundle you are attempting to use is of data version '" + dataVersion + "', but" + " the currently running version of paperweight only supports data version '3'.");
        }
        Path path2 = configFile = extractedDevBundlePath.resolve("config.json");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"configFile");
        Object object = path2;
        Charset charset = Charsets.UTF_8;
        Object object2 = new OpenOption[]{};
        int n = 8192;
        boolean bl2 = false;
        object = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(object2, ((OpenOption[])object2).length)), charset), n);
        boolean bl3 = false;
        n = 0;
        Throwable throwable = null;
        try {
            Type type;
            BufferedReader reader = (BufferedReader)object;
            boolean bl4 = false;
            Gson $receiver$iv = UtilsKt.getGson();
            Reader reader2 = reader;
            Gson gson = $receiver$iv;
            Type type2 = new TypeToken<GenerateDevBundle.DevBundleConfig>(){}.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {} .type");
            Type type$iv$iv = type2;
            if (type$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv)) {
                Type type3 = ((ParameterizedType)type$iv$iv).getRawType();
                type = type3;
                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type.rawType");
            } else {
                type = GsonBuilderKt.removeTypeWildcards(type$iv$iv);
            }
            Type type4 = type;
            Object t = gson.fromJson(reader2, type4);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"fromJson(json, typeToken<T>())");
            object2 = (GenerateDevBundle.DevBundleConfig)t;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        Object config = object2;
        return config;
    }
}

