/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.userdev.internal.setup;

import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.Git;
import io.papermc.paperweight.util.UtilsKt;
import io.papermc.paperweight.util.ZipKt;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003\u00a8\u0006\u0006"}, d2={"applyDevBundlePatches", "", "decompiledJar", "Ljava/nio/file/Path;", "devBundlePatches", "outputJar", "paperweight-userdev"})
public final class ApplyDevBundlePatchesKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void applyDevBundlePatches(@NotNull Path decompiledJar, @NotNull Path devBundlePatches, @NotNull Path outputJar) {
        Intrinsics.checkNotNullParameter((Object)decompiledJar, (String)"decompiledJar");
        Intrinsics.checkNotNullParameter((Object)devBundlePatches, (String)"devBundlePatches");
        Intrinsics.checkNotNullParameter((Object)outputJar, (String)"outputJar");
        Git.Companion.checkForGit();
        Path workDir = UtilsKt.findOutputDir(outputJar);
        try {
            ZipKt.unzip(decompiledJar, workDir);
            Git git = new Git(workDir, null, 2, null);
            AutoCloseable autoCloseable = Files.walk(devBundlePatches, new FileVisitOption[0]);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl3 = false;
                stream.forEach(new Consumer(git, workDir, devBundlePatches){
                    final /* synthetic */ Git $git$inlined;
                    final /* synthetic */ Path $workDir$inlined;
                    final /* synthetic */ Path $devBundlePatches$inlined;
                    {
                        this.$git$inlined = git;
                        this.$workDir$inlined = path;
                        this.$devBundlePatches$inlined = path2;
                    }

                    public final void accept(Path it) {
                        Path path = it;
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                        if (StringsKt.endsWith$default((String)PathsKt.getName((Path)path), (String)".patch", (boolean)false, (int)2, null)) {
                            String[] stringArray = new String[3];
                            stringArray[0] = "apply";
                            stringArray[1] = "--ignore-whitespace";
                            Path path2 = it;
                            boolean bl = false;
                            stringArray[2] = ((Object)path2.toAbsolutePath()).toString();
                            this.$git$inlined.invoke(stringArray).executeOut();
                        } else {
                            Path path3 = it;
                            Object object = new LinkOption[]{};
                            boolean bl = false;
                            if (Files.isRegularFile(path3, Arrays.copyOf(object, ((LinkOption[])object).length))) {
                                Path destination;
                                Path path4 = destination = this.$workDir$inlined.resolve(PathsKt.relativeTo((Path)it, (Path)this.$devBundlePatches$inlined));
                                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"destination");
                                Path path5 = path4.getParent();
                                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"destination.parent");
                                object = path5;
                                Object object2 = new FileAttribute[]{};
                                boolean bl2 = false;
                                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(object2, ((FileAttribute[])object2).length)), (String)"Files.createDirectories(this, *attributes)");
                                object = it;
                                object2 = destination;
                                bl2 = true;
                                boolean bl3 = false;
                                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                                Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object, (Path)object2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.copy(this, target, *options)");
                            }
                        }
                    }
                });
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            UtilsKt.ensureDeleted(outputJar);
            ZipKt.zip(workDir, outputJar);
        }
        finally {
            FileKt.deleteRecursively$default(workDir, null, 1, null);
        }
    }
}

