/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks.patchremap;

import io.papermc.paperweight.tasks.BaseTask;
import io.papermc.paperweight.tasks.patchremap.PatchApplier;
import io.papermc.paperweight.tasks.patchremap.PatchSourceRemapWorker;
import io.papermc.paperweight.tasks.patchremap.RemapPatches;
import io.papermc.paperweight.util.Command;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.Git;
import io.papermc.paperweight.util.MappingFormats;
import io.papermc.paperweight.util.McDev;
import io.papermc.paperweight.util.UtilsKt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Charsets;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.kotlin.dsl.NamedDomainObjectCollectionExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paper.libs.com.github.salomonbrys.kotson.GsonBuilderKt;
import paper.libs.com.google.gson.Gson;
import paper.libs.com.google.gson.reflect.TypeToken;
import paper.libs.org.cadixdev.at.AccessTransformSet;
import paper.libs.org.cadixdev.at.io.AccessTransformFormats;
import paper.libs.org.cadixdev.lorenz.MappingSet;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u000267B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u001b2\n\b\u0002\u00100\u001a\u0004\u0018\u00010.2\b\b\u0002\u00101\u001a\u00020\u0011H\u0002J\"\u00102\u001a\u00020.2\u0006\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020.2\b\b\u0002\u00101\u001a\u00020\u0011H\u0002J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000204H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\nR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0014\u0010\u0018\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0006R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0013R\u0014\u0010\u001d\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\nR\u0014\u0010\u001f\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0006R\u0014\u0010!\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0006R\u0014\u0010#\u001a\u00020$8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0006R\u0014\u0010)\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\nR\u0014\u0010+\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0006\u00a8\u00068"}, d2={"Lio/papermc/paperweight/tasks/patchremap/RemapPatches;", "Lio/papermc/paperweight/tasks/BaseTask;", "()V", "apiPatchDir", "Lorg/gradle/api/file/DirectoryProperty;", "getApiPatchDir", "()Lorg/gradle/api/file/DirectoryProperty;", "ats", "Lorg/gradle/api/file/RegularFileProperty;", "getAts", "()Lorg/gradle/api/file/RegularFileProperty;", "classpathJars", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasspathJars", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "continueRemapping", "Lorg/gradle/api/provider/Property;", "", "getContinueRemapping", "()Lorg/gradle/api/provider/Property;", "devImports", "getDevImports", "ignoreGitIgnore", "getIgnoreGitIgnore", "inputPatchDir", "getInputPatchDir", "limitPatches", "", "getLimitPatches", "mappingsFile", "getMappingsFile", "mcLibrarySourcesDir", "getMcLibrarySourcesDir", "outputPatchDir", "getOutputPatchDir", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "getProviders", "()Lorg/gradle/api/provider/ProviderFactory;", "spigotApiDir", "getSpigotApiDir", "spigotDecompJar", "getSpigotDecompJar", "spigotServerDir", "getSpigotServerDir", "createWorkDir", "Ljava/nio/file/Path;", "name", "source", "recreate", "createWorkDirByCloning", "init", "", "run", "RemapMeta", "RemapStage", "paperweight-lib"})
public abstract class RemapPatches
extends BaseTask {
    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getInputPatchDir();

    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getApiPatchDir();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getMappingsFile();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getAts();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getClasspathJars();

    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getSpigotApiDir();

    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getSpigotServerDir();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getSpigotDecompJar();

    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getMcLibrarySourcesDir();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getDevImports();

    @Input
    @NotNull
    public abstract Property<Boolean> getIgnoreGitIgnore();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputPatchDir();

    @Internal
    @Option(option="continue-remap", description="For resuming, don't recreate remap dir and pick up where last run left off")
    @NotNull
    public abstract Property<Boolean> getContinueRemapping();

    @Internal
    @Option(option="limit-patches", description="For testing, you can limit the # of patches (e.g. --limit-patches=10)")
    @NotNull
    public abstract Property<String> getLimitPatches();

    @Inject
    @NotNull
    public abstract ProviderFactory getProviders();

    @Override
    public void init() {
        this.getContinueRemapping().convention((Object)false);
        this.getIgnoreGitIgnore().convention(Git.Companion.ignoreProperty(this.getProviders())).finalizeValueOnRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void run() {
        OpenOption[] writer2;
        Charset charset;
        Object object;
        void $this$mapTo$iv$iv;
        Path path;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Object element$iv$iv2;
        void $this$flatMapTo$iv$iv2;
        Object element$iv;
        boolean bl;
        boolean $i$f$any;
        Object $this$any$iv;
        List inputElements;
        RemapMeta meta;
        Path metaFile;
        block49: {
            RemapMeta remapMeta;
            Object $receiver$iv$iv;
            Object $receiver$iv$iv2;
            Path path2 = UtilsKt.getCache(this.getLayout());
            Object object2 = "paperweight";
            boolean bl2 = false;
            Path path3 = path2.resolve((String)object2);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"this.resolve(other)");
            path2 = path3;
            object2 = "remap-meta";
            bl2 = false;
            Path path4 = path2.resolve((String)object2);
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"this.resolve(other)");
            metaFile = path4;
            object2 = metaFile;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            boolean bl3 = false;
            if (Files.exists((Path)object2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Object object3 = this.getContinueRemapping().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"continueRemapping.get()");
                if (((Boolean)object3).booleanValue()) {
                    Object object4;
                    Object type$iv$iv$iv;
                    Object object5;
                    Gson $this$fromJson$iv = UtilsKt.getGson();
                    boolean $i$f$fromJson = false;
                    Path path5 = metaFile;
                    if (path5 instanceof String) {
                        Type type;
                        $receiver$iv$iv2 = $this$fromJson$iv;
                        String string = (String)((Object)metaFile);
                        object5 = $receiver$iv$iv2;
                        Type type2 = new TypeToken<RemapMeta>(){}.getType();
                        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {} .type");
                        type$iv$iv$iv = type2;
                        if (type$iv$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv)) {
                            Type type3 = ((ParameterizedType)type$iv$iv$iv).getRawType();
                            type = type3;
                            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type.rawType");
                        } else {
                            type = GsonBuilderKt.removeTypeWildcards((Type)type$iv$iv$iv);
                        }
                        Type type4 = type;
                        Object t = ((Gson)object5).fromJson(string, type4);
                        object4 = t;
                        Intrinsics.checkExpressionValueIsNotNull(t, (String)"fromJson(json, typeToken<T>())");
                    } else {
                        $receiver$iv$iv2 = UtilsKt.convertToPath(metaFile);
                        Charset charset2 = Charsets.UTF_8;
                        type$iv$iv$iv = new OpenOption[]{};
                        int n = 8192;
                        boolean bl4 = false;
                        $receiver$iv$iv2 = new BufferedReader(new InputStreamReader(Files.newInputStream($receiver$iv$iv2, Arrays.copyOf(type$iv$iv$iv, ((OpenOption[])type$iv$iv$iv).length)), charset2), n);
                        boolean bl5 = false;
                        n = 0;
                        object5 = null;
                        try {
                            Type type;
                            BufferedReader it$iv = (BufferedReader)$receiver$iv$iv2;
                            boolean bl6 = false;
                            $receiver$iv$iv = $this$fromJson$iv;
                            Reader $i$f$typeToken = it$iv;
                            Object $i$f$fromJson2 = $receiver$iv$iv;
                            Type type5 = new TypeToken<RemapMeta>(){}.getType();
                            Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"object : TypeToken<T>() {} .type");
                            Type type$iv$iv$iv2 = type5;
                            if (type$iv$iv$iv2 instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv2)) {
                                Type type6 = ((ParameterizedType)type$iv$iv$iv2).getRawType();
                                type = type6;
                                Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"type.rawType");
                            } else {
                                type = GsonBuilderKt.removeTypeWildcards(type$iv$iv$iv2);
                            }
                            Type type7 = type;
                            Object t = ((Gson)$i$f$fromJson2).fromJson($i$f$typeToken, type7);
                            Intrinsics.checkExpressionValueIsNotNull(t, (String)"fromJson(json, typeToken<T>())");
                            it$iv = t;
                            object4 = it$iv;
                        }
                        catch (Throwable it$iv) {
                            object5 = it$iv;
                            throw it$iv;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)$receiver$iv$iv2, (Throwable)object5);
                        }
                    }
                    remapMeta = (RemapMeta)object4;
                } else {
                    FileKt.deleteForcefully(metaFile);
                    remapMeta = null;
                }
            } else {
                remapMeta = null;
            }
            meta = remapMeta;
            inputElements = CollectionsKt.sorted((Iterable)PathsKt.listDirectoryEntries$default((Path)FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputPatchDir())), null, (int)1, null));
            $this$any$iv = inputElements;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                $receiver$iv$iv2 = $this$any$iv.iterator();
                while ($receiver$iv$iv2.hasNext()) {
                    element$iv = $receiver$iv$iv2.next();
                    Path it = (Path)element$iv;
                    boolean bl7 = false;
                    Path bl6 = it;
                    $receiver$iv$iv = new LinkOption[]{};
                    boolean $i$f$typeToken = false;
                    if (!Files.isRegularFile(bl6, Arrays.copyOf($receiver$iv$iv, ((LinkOption[])$receiver$iv$iv).length))) continue;
                    bl = true;
                    break block49;
                }
                bl = false;
            }
        }
        if (bl) {
            $this$any$iv = "Remap patch input directory must only contain directories or patch files, not both";
            $i$f$any = false;
            System.out.println($this$any$iv);
            return;
        }
        if (inputElements.size() == 1) {
            $this$any$iv = "No patches to remap, only 1 patch set found";
            $i$f$any = false;
            System.out.println($this$any$iv);
            return;
        }
        Iterable $this$flatMap$iv = CollectionsKt.dropLast((List)inputElements, (int)1);
        boolean $i$f$flatMap2 = false;
        element$iv = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
            Path it = (Path)element$iv$iv2;
            boolean bl8 = false;
            Iterable list$iv$iv = CollectionsKt.sorted((Iterable)PathsKt.listDirectoryEntries((Path)it, (String)"*.patch"));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List patchesToSkip = (List)destination$iv$iv;
        List patchesToRemap = CollectionsKt.sorted((Iterable)PathsKt.listDirectoryEntries((Path)((Path)CollectionsKt.last((List)inputElements)), (String)"*.patch"));
        if (patchesToRemap.isEmpty()) {
            String $i$f$flatMap2 = "No input patches to remap found";
            boolean $this$flatMapTo$iv$iv2 = false;
            System.out.println((Object)$i$f$flatMap2);
            return;
        }
        Object object6 = this.getLimitPatches().map((Transformer)run.limit.1.INSTANCE).orElse((Object)patchesToRemap.size()).get();
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"limitPatches.map { it.to\u2026atchesToRemap.size).get()");
        int limit2 = ((Number)object6).intValue();
        MappingSet mappings = MappingFormats.INSTANCE.getTINY().read(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getMappingsFile())), "spigot", "mojang+yarn");
        Project project = this.getProject().project(":Paper-Server");
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project.project(\":Paper-Server\")");
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.project(\":Paper-Server\").configurations");
        Set set = ((Configuration)NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer), (String)"runtimeClasspath")).resolve();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"project.project(\":Paper-\u2026timeClasspath\"].resolve()");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        element$iv$iv2 = $this$map$iv;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            File $i$f$gsonTypeToken = (File)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl9 = false;
            path = it.toPath();
            collection.add(path);
        }
        List configFiles = (List)destination$iv$iv2;
        Object $this$map$iv2 = (Iterable)this.getClasspathJars();
        boolean $i$f$map2 = false;
        destination$iv$iv2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File bl9 = (File)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl10 = false;
            path = it.toPath();
            collection.add(path);
        }
        List classpathFiles = CollectionsKt.plus((Collection)((List)destination$iv$iv3), (Iterable)configFiles);
        $this$map$iv2 = "setting up repo";
        $i$f$map2 = false;
        System.out.println($this$map$iv2);
        Path tempApiDir = this.createWorkDir("patch-remap-api", FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getSpigotApiDir())), (Boolean)this.getContinueRemapping().get() == false);
        Path tempInputDir = this.createWorkDirByCloning("patch-remap-input", FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getSpigotServerDir())), (Boolean)this.getContinueRemapping().get() == false);
        Path tempOutputDir = RemapPatches.createWorkDir$default(this, "patch-remap-output", null, false, 6, null);
        Path sourceInputDir = tempInputDir.resolve("src/main/java");
        MappingSet mappingSet = mappings;
        Intrinsics.checkNotNullExpressionValue((Object)mappingSet, (String)"mappings");
        AccessTransformSet accessTransformSet = AccessTransformFormats.FML.read(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getAts())));
        Intrinsics.checkNotNullExpressionValue((Object)accessTransformSet, (String)"AccessTransformFormats.FML.read(ats.path)");
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        Collection $this$toTypedArray$iv = classpathFiles;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Path[] pathArray = thisCollection$iv.toArray(new Path[0]);
        if (pathArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        spreadBuilder.addSpread((Object)pathArray);
        spreadBuilder.add((Object)tempApiDir.resolve("src/main/java"));
        Collection collection2 = CollectionsKt.listOf((Object[])((Path[])spreadBuilder.toArray((Object[])new Path[spreadBuilder.size()])));
        Path path6 = sourceInputDir;
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"sourceInputDir");
        PatchSourceRemapWorker patchSourceRemapWorker = new PatchSourceRemapWorker(mappingSet, accessTransformSet, collection2, path6, tempOutputDir);
        boolean bl11 = false;
        boolean bl12 = false;
        PatchSourceRemapWorker remapper = patchSourceRemapWorker;
        boolean bl13 = false;
        Object object7 = this.getIgnoreGitIgnore().get();
        Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"ignoreGitIgnore.get()");
        PatchApplier patchApplier = new PatchApplier("remapped", "old", (Boolean)object7, tempInputDir);
        if (!((Boolean)this.getContinueRemapping().get()).booleanValue()) {
            patchApplier.createBranches();
            Iterable iterable = CollectionsKt.plus((Collection)patchesToSkip, (Iterable)patchesToRemap);
            Path path7 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getSpigotDecompJar()));
            Path path8 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getDevImports()));
            Path path9 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getMcLibrarySourcesDir()));
            Path path10 = tempInputDir.resolve("src/main/java");
            Intrinsics.checkNotNullExpressionValue((Object)path10, (String)"tempInputDir.resolve(\"src/main/java\")");
            McDev.importMcDev$default(McDev.INSTANCE, iterable, path7, path8, path9, path10, false, 32, null);
            patchApplier.commitPlain("McDev imports");
        }
        if (meta == null || meta.getStage() == RemapStage.PRE_REMAP) {
            Object item$iv;
            boolean foundResume = false;
            Object $this$dropWhile$iv = patchesToSkip;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            object = $this$dropWhile$iv.iterator();
            while (object.hasNext()) {
                boolean bl14;
                item$iv = object.next();
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                Path patch2 = (Path)item$iv;
                boolean bl15 = false;
                if (meta == null) {
                    bl14 = false;
                } else {
                    String string = meta.getPatchSet();
                    Path path11 = patch2.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)path11, (String)"patch.parent");
                    if (Intrinsics.areEqual((Object)string, (Object)PathsKt.getName((Path)path11)) && Intrinsics.areEqual((Object)meta.getPatchName(), (Object)PathsKt.getName((Path)patch2))) {
                        foundResume = true;
                        bl14 = true;
                    } else {
                        bl14 = !foundResume;
                    }
                }
                if (bl14) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            List patchesToApply = list$iv;
            $this$dropWhile$iv = "Applying " + patchesToApply.size() + " patches before remapping";
            boolean bl16 = false;
            System.out.println($this$dropWhile$iv);
            for (Path patch : patchesToApply) {
                FileKt.deleteForcefully(metaFile);
                Object object8 = metaFile;
                item$iv = new OpenOption[]{};
                charset = Charsets.UTF_8;
                int n = 8192;
                boolean patch2 = false;
                Object object9 = item$iv;
                object8 = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object8, (OpenOption[])Arrays.copyOf(object9, ((T)object9).length)), charset), n);
                boolean bl17 = false;
                n = 0;
                object = null;
                try {
                    writer2 = (BufferedWriter)object8;
                    boolean bl18 = false;
                    Gson gson = UtilsKt.getGson();
                    Path path12 = patch.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)path12, (String)"patch.parent");
                    gson.toJson((Object)new RemapMeta(RemapStage.PRE_REMAP, PathsKt.getName((Path)path12), PathsKt.getName((Path)patch)), (Appendable)writer2);
                    writer2 = Unit.INSTANCE;
                }
                catch (Throwable writer2) {
                    object = writer2;
                    throw writer2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object8, (Throwable)object);
                }
                patchApplier.applyPatch(patch);
            }
            patchApplier.checkoutRemapped();
            remapper.remap();
            patchApplier.commitInitialRemappedSource();
            patchApplier.checkoutOld();
        } else if (patchApplier.isUnfinishedPatch()) {
            String foundResume = "===========================";
            boolean patchesToApply = false;
            System.out.println((Object)foundResume);
            foundResume = "Finishing current patch";
            patchesToApply = false;
            System.out.println((Object)foundResume);
            foundResume = "===========================";
            patchesToApply = false;
            System.out.println((Object)foundResume);
            patchApplier.recordCommit();
            patchApplier.checkoutRemapped();
            remapper.remap();
            patchApplier.commitChanges();
            patchApplier.checkoutOld();
            foundResume = "===========================";
            patchesToApply = false;
            System.out.println((Object)foundResume);
            foundResume = "done with current patch";
            patchesToApply = false;
            System.out.println((Object)foundResume);
            foundResume = "===========================";
            patchesToApply = false;
            System.out.println((Object)foundResume);
        }
        int counter = 0;
        boolean remapSkip = meta != null && meta.getStage() == RemapStage.REMAP;
        for (Path patch : patchesToRemap) {
            if (remapSkip && meta != null) {
                String string = meta.getPatchSet();
                Path path13 = patch.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path13, (String)"patch.parent");
                if (!Intrinsics.areEqual((Object)string, (Object)PathsKt.getName((Path)path13)) || !Intrinsics.areEqual((Object)meta.getPatchName(), (Object)PathsKt.getName((Path)patch))) continue;
                remapSkip = false;
                continue;
            }
            FileKt.deleteForcefully(metaFile);
            Object object10 = metaFile;
            writer2 = new OpenOption[]{};
            charset = Charsets.UTF_8;
            int n = 8192;
            boolean bl18 = false;
            object10 = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object10, Arrays.copyOf(writer2, writer2.length)), charset), n);
            boolean bl19 = false;
            n = 0;
            object = null;
            try {
                writer2 = (BufferedWriter)object10;
                boolean bl20 = false;
                Gson gson = UtilsKt.getGson();
                Path path14 = patch.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path14, (String)"patch.parent");
                gson.toJson((Object)new RemapMeta(RemapStage.REMAP, PathsKt.getName((Path)path14), PathsKt.getName((Path)patch)), (Appendable)writer2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object10, (Throwable)object);
            }
            object10 = "===========================";
            bl19 = false;
            System.out.println(object10);
            object10 = "attempting to remap " + patch;
            bl19 = false;
            System.out.println(object10);
            object10 = "===========================";
            bl19 = false;
            System.out.println(object10);
            patchApplier.applyPatch(patch);
            patchApplier.recordCommit();
            patchApplier.checkoutRemapped();
            remapper.remap();
            patchApplier.commitChanges();
            patchApplier.checkoutOld();
            object10 = "===========================";
            bl19 = false;
            System.out.println(object10);
            object10 = "done remapping patch " + patch;
            bl19 = false;
            System.out.println(object10);
            object10 = "===========================";
            bl19 = false;
            System.out.println(object10);
            if (++counter < limit2) continue;
            break;
        }
        patchApplier.generatePatches(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputPatchDir())));
    }

    private final Path createWorkDir(String name2, Path source, boolean recreate) {
        Path path = UtilsKt.getCache(this.getLayout()).resolve("paperweight").resolve(name2);
        boolean bl = false;
        boolean bl2 = false;
        Path $this$apply = path;
        boolean bl3 = false;
        if (recreate) {
            FileKt.deleteRecursively$default($this$apply, null, 1, null);
            Path path2 = $this$apply;
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
            Path path3 = source;
            if (path3 != null) {
                Path path4 = $this$apply;
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"this");
                FileKt.copyRecursivelyTo(path3, path4);
            }
        }
        Path path5 = path;
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"layout.cache.resolve(\"pa\u2026)\n            }\n        }");
        return path5;
    }

    static /* synthetic */ Path createWorkDir$default(RemapPatches remapPatches, String string, Path path, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createWorkDir");
        }
        if ((n & 2) != 0) {
            path = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return remapPatches.createWorkDir(string, path, bl);
    }

    private final Path createWorkDirByCloning(String name2, Path source, boolean recreate) {
        Path workDir = UtilsKt.getCache(this.getLayout()).resolve("paperweight");
        Path path = workDir.resolve(name2);
        boolean bl = false;
        boolean bl2 = false;
        Path $this$apply = path;
        boolean bl3 = false;
        if (recreate) {
            FileKt.deleteRecursively$default($this$apply, null, 1, null);
            Path path2 = $this$apply;
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
            Path path3 = workDir;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"workDir");
            Git git = new Git(path3, null, 2, null);
            String[] stringArray = new String[3];
            stringArray[0] = "clone";
            path2 = source;
            boolean bl5 = false;
            stringArray[1] = ((Object)path2.toAbsolutePath()).toString();
            Path path4 = $this$apply;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"this");
            path2 = path4;
            bl5 = false;
            stringArray[2] = ((Object)path2.toAbsolutePath()).toString();
            Command.executeSilently$default(git.invoke(stringArray), false, false, 3, null);
        }
        Path path5 = path;
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"workDir.resolve(name).ap\u2026)\n            }\n        }");
        return path5;
    }

    static /* synthetic */ Path createWorkDirByCloning$default(RemapPatches remapPatches, String string, Path path, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createWorkDirByCloning");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return remapPatches.createWorkDirByCloning(string, path, bl);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lio/papermc/paperweight/tasks/patchremap/RemapPatches$RemapMeta;", "", "stage", "Lio/papermc/paperweight/tasks/patchremap/RemapPatches$RemapStage;", "patchSet", "", "patchName", "(Lio/papermc/paperweight/tasks/patchremap/RemapPatches$RemapStage;Ljava/lang/String;Ljava/lang/String;)V", "getPatchName", "()Ljava/lang/String;", "getPatchSet", "getStage", "()Lio/papermc/paperweight/tasks/patchremap/RemapPatches$RemapStage;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "paperweight-lib"})
    public static final class RemapMeta {
        @NotNull
        private final RemapStage stage;
        @NotNull
        private final String patchSet;
        @NotNull
        private final String patchName;

        @NotNull
        public final RemapStage getStage() {
            return this.stage;
        }

        @NotNull
        public final String getPatchSet() {
            return this.patchSet;
        }

        @NotNull
        public final String getPatchName() {
            return this.patchName;
        }

        public RemapMeta(@NotNull RemapStage stage, @NotNull String patchSet, @NotNull String patchName) {
            Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
            Intrinsics.checkNotNullParameter((Object)patchSet, (String)"patchSet");
            Intrinsics.checkNotNullParameter((Object)patchName, (String)"patchName");
            this.stage = stage;
            this.patchSet = patchSet;
            this.patchName = patchName;
        }

        @NotNull
        public final RemapStage component1() {
            return this.stage;
        }

        @NotNull
        public final String component2() {
            return this.patchSet;
        }

        @NotNull
        public final String component3() {
            return this.patchName;
        }

        @NotNull
        public final RemapMeta copy(@NotNull RemapStage stage, @NotNull String patchSet, @NotNull String patchName) {
            Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
            Intrinsics.checkNotNullParameter((Object)patchSet, (String)"patchSet");
            Intrinsics.checkNotNullParameter((Object)patchName, (String)"patchName");
            return new RemapMeta(stage, patchSet, patchName);
        }

        public static /* synthetic */ RemapMeta copy$default(RemapMeta remapMeta, RemapStage remapStage, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                remapStage = remapMeta.stage;
            }
            if ((n & 2) != 0) {
                string = remapMeta.patchSet;
            }
            if ((n & 4) != 0) {
                string2 = remapMeta.patchName;
            }
            return remapMeta.copy(remapStage, string, string2);
        }

        @NotNull
        public String toString() {
            return "RemapMeta(stage=" + (Object)((Object)this.stage) + ", patchSet=" + this.patchSet + ", patchName=" + this.patchName + ")";
        }

        public int hashCode() {
            RemapStage remapStage = this.stage;
            String string = this.patchSet;
            String string2 = this.patchName;
            return ((remapStage != null ? ((Object)((Object)remapStage)).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RemapMeta)) break block3;
                    RemapMeta remapMeta = (RemapMeta)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.stage), (Object)((Object)remapMeta.stage)) || !Intrinsics.areEqual((Object)this.patchSet, (Object)remapMeta.patchSet) || !Intrinsics.areEqual((Object)this.patchName, (Object)remapMeta.patchName)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lio/papermc/paperweight/tasks/patchremap/RemapPatches$RemapStage;", "", "(Ljava/lang/String;I)V", "PRE_REMAP", "REMAP", "paperweight-lib"})
    public static final class RemapStage
    extends Enum<RemapStage> {
        public static final /* enum */ RemapStage PRE_REMAP;
        public static final /* enum */ RemapStage REMAP;
        private static final /* synthetic */ RemapStage[] $VALUES;

        static {
            RemapStage[] remapStageArray = new RemapStage[2];
            RemapStage[] remapStageArray2 = remapStageArray;
            remapStageArray[0] = PRE_REMAP = new RemapStage();
            remapStageArray[1] = REMAP = new RemapStage();
            $VALUES = remapStageArray;
        }

        public static RemapStage[] values() {
            return (RemapStage[])$VALUES.clone();
        }

        public static RemapStage valueOf(String string) {
            return Enum.valueOf(RemapStage.class, string);
        }
    }
}

