/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks.patchremap;

import io.papermc.paperweight.util.FileKt;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import paper.libs.org.cadixdev.at.AccessTransformSet;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.mercury.Mercury;
import paper.libs.org.cadixdev.mercury.SourceRewriter;
import paper.libs.org.cadixdev.mercury.at.AccessTransformerRewriter;
import paper.libs.org.cadixdev.mercury.remapper.MercuryRemapper;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\u000fJ\b\u0010\u0011\u001a\u00020\u000fH\u0002R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/papermc/paperweight/tasks/patchremap/PatchSourceRemapWorker;", "", "mappings", "Lpaper/libs/org/cadixdev/lorenz/MappingSet;", "ats", "Lpaper/libs/org/cadixdev/at/AccessTransformSet;", "classpath", "", "Ljava/nio/file/Path;", "inputDir", "outputDir", "(Lorg/cadixdev/lorenz/MappingSet;Lorg/cadixdev/at/AccessTransformSet;Ljava/util/Collection;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "merc", "Lpaper/libs/org/cadixdev/mercury/Mercury;", "cleanup", "", "remap", "setup", "paperweight-lib"})
public final class PatchSourceRemapWorker {
    private final Mercury merc;
    private final Path inputDir;
    private final Path outputDir;

    public final void remap() {
        this.setup();
        String string = "mapping to mojang+yarn";
        boolean bl = false;
        System.out.println((Object)string);
        this.merc.rewrite(this.inputDir, this.outputDir);
        this.cleanup();
    }

    private final void setup() {
        FileKt.deleteRecursively$default(this.outputDir, null, 1, null);
        Path path = this.outputDir;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
    }

    private final void cleanup() {
        FileKt.deleteRecursively$default(this.inputDir, null, 1, null);
        Path path = this.outputDir;
        Path path2 = this.inputDir;
        boolean bl = false;
        boolean bl2 = false;
        CopyOption[] copyOptionArray = new CopyOption[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.move(path, path2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.move(this, target, *options)");
        FileKt.deleteRecursively$default(this.outputDir, null, 1, null);
    }

    public PatchSourceRemapWorker(@NotNull MappingSet mappings, @NotNull AccessTransformSet ats2, @NotNull Collection<? extends Path> classpath, @NotNull Path inputDir, @NotNull Path outputDir) {
        Intrinsics.checkNotNullParameter((Object)mappings, (String)"mappings");
        Intrinsics.checkNotNullParameter((Object)ats2, (String)"ats");
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)inputDir, (String)"inputDir");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        this.inputDir = inputDir;
        this.outputDir = outputDir;
        this.merc = new Mercury();
        this.merc.getClassPath().addAll(classpath);
        this.merc.getProcessors().addAll(CollectionsKt.listOf((Object[])new SourceRewriter[]{MercuryRemapper.create(mappings), AccessTransformerRewriter.create(ats2)}));
        this.merc.setGracefulClasspathChecks(true);
    }
}

