/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.tasks.FixJarTaskKt;
import io.papermc.paperweight.tasks.JavaLauncherTask;
import io.papermc.paperweight.tasks.OverrideAnnotationAdder;
import io.papermc.paperweight.tasks.RecordFieldAccessFixer;
import io.papermc.paperweight.util.AsmUtil;
import io.papermc.paperweight.util.ClassNodeCache;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.FixJar;
import io.papermc.paperweight.util.UtilsKt;
import java.io.Closeable;
import java.nio.file.FileSystem;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import paper.libs.org.objectweb.asm.tree.ClassNode;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006R\u0014\u0010\u000e\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006R\u0014\u0010\u0010\u001a\u00020\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lio/papermc/paperweight/tasks/FixJarTask;", "Lio/papermc/paperweight/tasks/JavaLauncherTask;", "()V", "inputJar", "Lorg/gradle/api/file/RegularFileProperty;", "getInputJar", "()Lorg/gradle/api/file/RegularFileProperty;", "jvmArgs", "Lorg/gradle/api/provider/ListProperty;", "", "getJvmArgs", "()Lorg/gradle/api/provider/ListProperty;", "outputJar", "getOutputJar", "vanillaJar", "getVanillaJar", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "getWorkerExecutor", "()Lorg/gradle/workers/WorkerExecutor;", "init", "", "run", "FixJarAction", "FixJarParams", "paperweight-lib"})
public abstract class FixJarTask
extends JavaLauncherTask {
    @Classpath
    @NotNull
    public abstract RegularFileProperty getInputJar();

    @Classpath
    @NotNull
    public abstract RegularFileProperty getVanillaJar();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputJar();

    @Internal
    @NotNull
    public abstract ListProperty<String> getJvmArgs();

    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    @Override
    public void init() {
        super.init();
        this.getJvmArgs().convention((Iterable)CollectionsKt.listOf((Object)"-Xmx512m"));
        this.getOutputJar().convention((Provider)UtilsKt.defaultOutput(this));
    }

    @TaskAction
    public final void run() {
        WorkerExecutor workerExecutor = this.getWorkerExecutor();
        Object object = this.getJvmArgs().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jvmArgs.get()");
        List list = (List)object;
        Object object2 = this.getLauncher().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"launcher.get()");
        FixJarTaskKt.fixJar(workerExecutor, list, (JavaLauncher)object2, FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getVanillaJar())), FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputJar())), FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputJar())));
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lio/papermc/paperweight/tasks/FixJarTask$FixJarParams;", "Lorg/gradle/workers/WorkParameters;", "inputJar", "Lorg/gradle/api/file/RegularFileProperty;", "getInputJar", "()Lorg/gradle/api/file/RegularFileProperty;", "outputJar", "getOutputJar", "vanillaJar", "getVanillaJar", "paperweight-lib"})
    public static interface FixJarParams
    extends WorkParameters {
        @NotNull
        public RegularFileProperty getInputJar();

        @NotNull
        public RegularFileProperty getVanillaJar();

        @NotNull
        public RegularFileProperty getOutputJar();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0006B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lio/papermc/paperweight/tasks/FixJarTask$FixJarAction;", "Lorg/gradle/workers/WorkAction;", "Lio/papermc/paperweight/tasks/FixJarTask$FixJarParams;", "()V", "execute", "", "FixJarClassProcessor", "paperweight-lib"})
    public static abstract class FixJarAction
    implements WorkAction<FixJarParams> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            Closeable closeable = FileKt.openZip(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((FixJarParams)this.getParameters()).getVanillaJar())));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileSystem vanillaJar = (FileSystem)closeable;
                boolean bl3 = false;
                Closeable closeable2 = FileKt.writeZip(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((FixJarParams)this.getParameters()).getOutputJar())));
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    FileSystem out = (FileSystem)closeable2;
                    boolean bl6 = false;
                    Closeable closeable3 = FileKt.openZip(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((FixJarParams)this.getParameters()).getInputJar())));
                    boolean bl7 = false;
                    boolean bl8 = false;
                    Throwable throwable3 = null;
                    try {
                        FileSystem jarFile = (FileSystem)closeable3;
                        boolean bl9 = false;
                        FixJar.INSTANCE.processJars(jarFile, vanillaJar, out, FixJarClassProcessor.INSTANCE);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lio/papermc/paperweight/tasks/FixJarTask$FixJarAction$FixJarClassProcessor;", "Lio/papermc/paperweight/util/FixJar$ClassProcessor;", "Lio/papermc/paperweight/util/AsmUtil;", "()V", "processClass", "", "node", "Lpaper/libs/org/objectweb/asm/tree/ClassNode;", "classNodeCache", "Lio/papermc/paperweight/util/ClassNodeCache;", "paperweight-lib"})
        private static final class FixJarClassProcessor
        implements FixJar.ClassProcessor,
        AsmUtil {
            @NotNull
            public static final FixJarClassProcessor INSTANCE;

            @Override
            public void processClass(@NotNull ClassNode node, @NotNull ClassNodeCache classNodeCache) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)classNodeCache, (String)"classNodeCache");
                new OverrideAnnotationAdder(node, classNodeCache).visitNode();
                if (this.contains(node.access, 65536)) {
                    new RecordFieldAccessFixer(node).visitNode();
                }
            }

            private FixJarClassProcessor() {
            }

            static {
                FixJarClassProcessor fixJarClassProcessor;
                INSTANCE = fixJarClassProcessor = new FixJarClassProcessor();
            }
        }
    }
}

