/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.tasks.CleanupSourceMappings;
import io.papermc.paperweight.tasks.JavaLauncherTask;
import io.papermc.paperweight.util.ClassNameChange;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.MappingFormats;
import io.papermc.paperweight.util.UtilsKt;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.JavaForkOptions;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paper.libs.dev.denwav.hypo.asm.AsmClassDataProvider;
import paper.libs.dev.denwav.hypo.asm.hydrate.BridgeMethodHydrator;
import paper.libs.dev.denwav.hypo.asm.hydrate.SuperConstructorHydrator;
import paper.libs.dev.denwav.hypo.core.HypoContext;
import paper.libs.dev.denwav.hypo.hydrate.HydrationManager;
import paper.libs.dev.denwav.hypo.mappings.ChangeChain;
import paper.libs.dev.denwav.hypo.mappings.ChangeRegistry;
import paper.libs.dev.denwav.hypo.mappings.ClassMappingsChange;
import paper.libs.dev.denwav.hypo.mappings.LorenzUtil;
import paper.libs.dev.denwav.hypo.mappings.MappingsCompletionManager;
import paper.libs.dev.denwav.hypo.mappings.MergeResult;
import paper.libs.dev.denwav.hypo.mappings.MergeableMappingsChange;
import paper.libs.dev.denwav.hypo.mappings.changes.AbstractMappingsChange;
import paper.libs.dev.denwav.hypo.mappings.changes.MemberReference;
import paper.libs.dev.denwav.hypo.mappings.changes.RemoveMappingChange;
import paper.libs.dev.denwav.hypo.mappings.contributors.ChangeContributor;
import paper.libs.dev.denwav.hypo.model.ClassProviderRoot;
import paper.libs.dev.denwav.hypo.model.data.ClassData;
import paper.libs.dev.denwav.hypo.model.data.MethodData;
import paper.libs.dev.denwav.hypo.model.data.types.JvmType;
import paper.libs.dev.denwav.hypo.model.data.types.PrimitiveType;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;
import paper.libs.org.cadixdev.lorenz.model.FieldMapping;
import paper.libs.org.cadixdev.lorenz.model.InnerClassMapping;
import paper.libs.org.cadixdev.lorenz.model.MethodMapping;
import paper.libs.org.cadixdev.lorenz.model.MethodParameterMapping;
import paper.libs.org.cadixdev.lorenz.model.TopLevelClassMapping;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\b'\u0018\u0000  2\u00020\u0001:\b\u001d\u001e\u001f !\"#$B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0006R\u0014\u0010\u0014\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0006R\u0014\u0010\u0016\u001a\u00020\u00178gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lio/papermc/paperweight/tasks/CleanupSourceMappings;", "Lio/papermc/paperweight/tasks/JavaLauncherTask;", "()V", "caseOnlyNameChanges", "Lorg/gradle/api/file/RegularFileProperty;", "getCaseOnlyNameChanges", "()Lorg/gradle/api/file/RegularFileProperty;", "inputMappings", "getInputMappings", "jvmargs", "Lorg/gradle/api/provider/ListProperty;", "", "getJvmargs", "()Lorg/gradle/api/provider/ListProperty;", "libraries", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getLibraries", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputMappings", "getOutputMappings", "sourceJar", "getSourceJar", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "getWorkerExecutor", "()Lorg/gradle/workers/WorkerExecutor;", "init", "", "run", "ChangeObfClassName", "CleanupAfterRemoveAnonymousClassRenames", "CleanupSourceMappingsAction", "Companion", "FindCaseOnlyClassNameChanges", "ParamIndexesForSource", "RemoveAnonymousClassRenames", "RemoveLambdaMappings", "paperweight-lib"})
public abstract class CleanupSourceMappings
extends JavaLauncherTask {
    @NotNull
    public static final String TEMP_SUFFIX = "paperweight-remove-anon-renames-temp-suffix";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Classpath
    @NotNull
    public abstract RegularFileProperty getSourceJar();

    @CompileClasspath
    @NotNull
    public abstract ConfigurableFileCollection getLibraries();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getInputMappings();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputMappings();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getCaseOnlyNameChanges();

    @Internal
    @NotNull
    public abstract ListProperty<String> getJvmargs();

    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    @Override
    public void init() {
        super.init();
        this.getJvmargs().convention((Iterable)CollectionsKt.listOf((Object)"-Xmx1G"));
        this.getCaseOnlyNameChanges().convention((Provider)UtilsKt.defaultOutput(this, "caseOnlyClassNameChanges", "json"));
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void run() {
        void workActionClass$iv;
        void $this$submit$iv;
        WorkQueue queue2;
        WorkQueue workQueue = queue2 = this.getWorkerExecutor().processIsolation(new Action(this){
            final /* synthetic */ CleanupSourceMappings this$0;

            public final void execute(@NotNull ProcessWorkerSpec $this$processIsolation) {
                Intrinsics.checkNotNullParameter((Object)$this$processIsolation, (String)"$receiver");
                $this$processIsolation.getForkOptions().jvmArgs((Iterable)this.this$0.getJvmargs().get());
                JavaForkOptions javaForkOptions = $this$processIsolation.getForkOptions();
                Object object = this.this$0.getLauncher().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"launcher.get()");
                RegularFile regularFile = ((JavaLauncher)object).getExecutablePath();
                Intrinsics.checkNotNullExpressionValue((Object)regularFile, (String)"launcher.get().executablePath");
                Path path = FileKt.getPath((FileSystemLocation)regularFile);
                boolean bl = false;
                javaForkOptions.executable((Object)((Object)path.toAbsolutePath()).toString());
            }
            {
                this.this$0 = cleanupSourceMappings;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)workQueue, (String)"queue");
        WorkQueue workQueue2 = workQueue;
        Class<CleanupSourceMappingsAction> clazz = CleanupSourceMappingsAction.class;
        Action parameterAction$iv = new Action(this){
            final /* synthetic */ CleanupSourceMappings this$0;

            public final void execute(@NotNull CleanupSourceMappingsAction.Parameters $this$submit) {
                Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$receiver");
                FileKt.set((FileSystemLocationProperty)$this$submit.getInputMappings(), FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.this$0.getInputMappings())));
                $this$submit.getLibraries().from(new Object[]{this.this$0.getLibraries().getFiles()});
                FileKt.set((FileSystemLocationProperty)$this$submit.getSourceJar(), FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.this$0.getSourceJar())));
                FileKt.set((FileSystemLocationProperty)$this$submit.getOutputMappings(), FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.this$0.getOutputMappings())));
                FileKt.set((FileSystemLocationProperty)$this$submit.getCaseOnlyNameChanges(), FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.this$0.getCaseOnlyNameChanges())));
            }
            {
                this.this$0 = cleanupSourceMappings;
            }
        };
        boolean $i$f$submit = false;
        $this$submit$iv.submit((Class)workActionClass$iv, parameterAction$iv);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0010\u0010\u0007\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lio/papermc/paperweight/tasks/CleanupSourceMappings$ParamIndexesForSource;", "Lpaper/libs/dev/denwav/hypo/mappings/contributors/ChangeContributor;", "()V", "contribute", "", "currentClass", "Lpaper/libs/dev/denwav/hypo/model/data/ClassData;", "classMapping", "Lpaper/libs/org/cadixdev/lorenz/model/ClassMapping;", "context", "Lpaper/libs/dev/denwav/hypo/core/HypoContext;", "registry", "Lpaper/libs/dev/denwav/hypo/mappings/ChangeRegistry;", "name", "", "ParamIndexChange", "paperweight-lib"})
    public static final class ParamIndexesForSource
    implements ChangeContributor {
        @NotNull
        public static final ParamIndexesForSource INSTANCE;

        /*
         * WARNING - void declaration
         */
        @Override
        public void contribute(@Nullable ClassData currentClass, @Nullable ClassMapping<?, ?> classMapping, @NotNull HypoContext context, @NotNull ChangeRegistry registry) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            if (currentClass == null || classMapping == null) {
                return;
            }
            for (MethodMapping methodMapping : classMapping.getMethodMappings()) {
                int lvtIndex;
                MethodData method;
                if (LorenzUtil.findMethod(currentClass, methodMapping) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)method, (String)"LorenzUtil.findMethod(cu\u2026ethodMapping) ?: continue");
                MemberReference methodRef = null;
                int n = lvtIndex = method.isStatic() ? 0 : 1;
                if (method.isConstructor() && currentClass.outerClass() != null && !currentClass.isStaticInnerClass()) {
                    ++lvtIndex;
                }
                boolean bl = false;
                List<JvmType> list = method.params();
                Intrinsics.checkNotNullExpressionValue(list, (String)"method.params()");
                for (JvmType param : (Iterable)list) {
                    void sourceIndex;
                    if (methodMapping.hasParameterMapping(lvtIndex)) {
                        if (methodRef == null) {
                            methodRef = MemberReference.of(methodMapping);
                        }
                        registry.submitChange(new ParamIndexChange(methodRef, lvtIndex, (int)sourceIndex));
                    }
                    ++lvtIndex;
                    if (param == PrimitiveType.LONG || param == PrimitiveType.DOUBLE) {
                        ++lvtIndex;
                    }
                    ++sourceIndex;
                }
            }
        }

        @Override
        @NotNull
        public String name() {
            return "ParamIndexesForSource";
        }

        private ParamIndexesForSource() {
        }

        static {
            ParamIndexesForSource paramIndexesForSource;
            INSTANCE = paramIndexesForSource = new ParamIndexesForSource();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00000\u00112\u0006\u0010\u0012\u001a\u00020\u0000H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/papermc/paperweight/tasks/CleanupSourceMappings$ParamIndexesForSource$ParamIndexChange;", "Lpaper/libs/dev/denwav/hypo/mappings/changes/AbstractMappingsChange;", "Lpaper/libs/dev/denwav/hypo/mappings/MergeableMappingsChange;", "target", "Lpaper/libs/dev/denwav/hypo/mappings/changes/MemberReference;", "fromIndex", "", "toIndex", "(Ldev/denwav/hypo/mappings/changes/MemberReference;II)V", "indexMap", "", "applyChange", "", "input", "Lpaper/libs/org/cadixdev/lorenz/MappingSet;", "ref", "mergeWith", "Lpaper/libs/dev/denwav/hypo/mappings/MergeResult;", "that", "toString", "", "paperweight-lib"})
        public static final class ParamIndexChange
        extends AbstractMappingsChange
        implements MergeableMappingsChange<ParamIndexChange> {
            private final Map<Integer, Integer> indexMap;

            @Override
            public void applyChange(@NotNull MappingSet input, @NotNull MemberReference ref) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                ClassMapping<?, ?> classMapping = input.getOrCreateClassMapping(ref.className());
                MethodMapping methodMapping = classMapping.getOrCreateMethodMapping(ref.name(), ref.desc());
                Map<Integer, MethodParameterMapping> map2 = LorenzUtil.getParamsMap(methodMapping);
                Intrinsics.checkNotNullExpressionValue(map2, (String)"LorenzUtil.getParamsMap(methodMapping)");
                Map<Integer, MethodParameterMapping> paramsMap = map2;
                List params = CollectionsKt.toList((Iterable)paramsMap.values());
                paramsMap.clear();
                Iterator iterator = params.iterator();
                while (iterator.hasNext()) {
                    MethodParameterMapping param;
                    MethodParameterMapping methodParameterMapping = param = (MethodParameterMapping)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)methodParameterMapping, (String)"param");
                    Integer n = this.indexMap.get(methodParameterMapping.getIndex());
                    methodMapping.createParameterMapping(n != null ? n.intValue() : param.getIndex(), param.getDeobfuscatedName());
                }
            }

            @Override
            @NotNull
            public MergeResult<ParamIndexChange> mergeWith(@NotNull ParamIndexChange that) {
                Intrinsics.checkNotNullParameter((Object)that, (String)"that");
                Object object = this.indexMap.keySet().iterator();
                while (object.hasNext()) {
                    int fromIndex = ((Number)object.next()).intValue();
                    if (!that.indexMap.containsKey(fromIndex)) continue;
                    MergeResult<ParamIndexChange> mergeResult = MergeResult.failure("Cannot merge 2 param mappings changes with matching fromIndexes");
                    Intrinsics.checkNotNullExpressionValue(mergeResult, (String)"MergeResult.failure(\"Can\u2026th matching fromIndexes\")");
                    return mergeResult;
                }
                object = this.indexMap.values().iterator();
                while (object.hasNext()) {
                    int toIndex = ((Number)object.next()).intValue();
                    if (!that.indexMap.containsValue(toIndex)) continue;
                    MergeResult<ParamIndexChange> mergeResult = MergeResult.failure("Cannot merge 2 param mappings changes with matching toIndex");
                    Intrinsics.checkNotNullExpressionValue(mergeResult, (String)"MergeResult.failure(\"Can\u2026s with matching toIndex\")");
                    return mergeResult;
                }
                Map<Integer, Integer> map2 = this.indexMap;
                object = that.indexMap;
                boolean bl = false;
                map2.putAll((Map<Integer, Integer>)object);
                MergeResult<MergeableMappingsChange> mergeResult = MergeResult.success((MergeableMappingsChange)this);
                Intrinsics.checkNotNullExpressionValue(mergeResult, (String)"MergeResult.success(this)");
                return mergeResult;
            }

            @NotNull
            public String toString() {
                return "Move param mappings for " + this.target() + " for index pairs [" + CollectionsKt.joinToString$default((Iterable)this.indexMap.entrySet(), (CharSequence)", ", null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)30, null) + ']';
            }

            public ParamIndexChange(@NotNull MemberReference target, int fromIndex, int toIndex) {
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                super(target);
                this.indexMap = new HashMap();
                this.indexMap.put(fromIndex, toIndex);
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0010\u0010\u0007\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lio/papermc/paperweight/tasks/CleanupSourceMappings$RemoveLambdaMappings;", "Lpaper/libs/dev/denwav/hypo/mappings/contributors/ChangeContributor;", "()V", "contribute", "", "currentClass", "Lpaper/libs/dev/denwav/hypo/model/data/ClassData;", "classMapping", "Lpaper/libs/org/cadixdev/lorenz/model/ClassMapping;", "context", "Lpaper/libs/dev/denwav/hypo/core/HypoContext;", "registry", "Lpaper/libs/dev/denwav/hypo/mappings/ChangeRegistry;", "name", "", "paperweight-lib"})
    public static final class RemoveLambdaMappings
    implements ChangeContributor {
        @NotNull
        public static final RemoveLambdaMappings INSTANCE;

        @Override
        public void contribute(@Nullable ClassData currentClass, @Nullable ClassMapping<?, ?> classMapping, @NotNull HypoContext context, @NotNull ChangeRegistry registry) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            if (currentClass == null || classMapping == null) {
                return;
            }
            Iterator<MethodMapping> iterator = classMapping.getMethodMappings().iterator();
            while (iterator.hasNext()) {
                MethodMapping methodMapping;
                MethodMapping methodMapping2 = methodMapping = iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)methodMapping2, (String)"methodMapping");
                String string = methodMapping2.getDeobfuscatedName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"methodMapping.deobfuscatedName");
                if (!StringsKt.startsWith$default((String)string, (String)"lambda$", (boolean)false, (int)2, null)) continue;
                registry.submitChange(RemoveMappingChange.of(MemberReference.of(methodMapping)));
            }
        }

        @Override
        @NotNull
        public String name() {
            return "RemoveLambdaMappings";
        }

        private RemoveLambdaMappings() {
        }

        static {
            RemoveLambdaMappings removeLambdaMappings;
            INSTANCE = removeLambdaMappings = new RemoveLambdaMappings();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J4\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0010\u0010\n\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/papermc/paperweight/tasks/CleanupSourceMappings$FindCaseOnlyClassNameChanges;", "Lpaper/libs/dev/denwav/hypo/mappings/contributors/ChangeContributor;", "changes", "", "Lio/papermc/paperweight/util/ClassNameChange;", "(Ljava/util/List;)V", "contribute", "", "currentClass", "Lpaper/libs/dev/denwav/hypo/model/data/ClassData;", "classMapping", "Lpaper/libs/org/cadixdev/lorenz/model/ClassMapping;", "context", "Lpaper/libs/dev/denwav/hypo/core/HypoContext;", "registry", "Lpaper/libs/dev/denwav/hypo/mappings/ChangeRegistry;", "name", "", "paperweight-lib"})
    public static final class FindCaseOnlyClassNameChanges
    implements ChangeContributor {
        private final List<ClassNameChange> changes;

        @Override
        public void contribute(@Nullable ClassData currentClass, @Nullable ClassMapping<?, ?> classMapping, @NotNull HypoContext context, @NotNull ChangeRegistry registry) {
            String deobfName;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            if (!(classMapping instanceof TopLevelClassMapping)) {
                return;
            }
            String obfName = ((TopLevelClassMapping)classMapping).getObfuscatedName();
            if (Intrinsics.areEqual((Object)obfName, (Object)(deobfName = ((TopLevelClassMapping)classMapping).getDeobfuscatedName())) ^ true && StringsKt.equals((String)obfName, (String)deobfName, (boolean)true)) {
                Collection collection = this.changes;
                String string = obfName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"obfName");
                String string2 = deobfName;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"deobfName");
                ClassNameChange classNameChange = new ClassNameChange(string, string2);
                boolean bl = false;
                collection.add(classNameChange);
            }
        }

        @Override
        @NotNull
        public String name() {
            return "FindCaseOnlyClassNameChanges";
        }

        public FindCaseOnlyClassNameChanges(@NotNull List<ClassNameChange> changes) {
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            this.changes = changes;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\n\u001a\u00020\u00072\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f2\u000e\u0010\r\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\fH\u0002J\b\u0010\u0002\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/papermc/paperweight/tasks/CleanupSourceMappings$ChangeObfClassName;", "Lpaper/libs/dev/denwav/hypo/mappings/ClassMappingsChange;", "targetClass", "", "newFullObfuscatedName", "(Ljava/lang/String;Ljava/lang/String;)V", "applyChange", "", "input", "Lpaper/libs/org/cadixdev/lorenz/MappingSet;", "copyMapping", "from", "Lpaper/libs/org/cadixdev/lorenz/model/ClassMapping;", "to", "paperweight-lib"})
    public static final class ChangeObfClassName
    implements ClassMappingsChange {
        private final String targetClass;
        private final String newFullObfuscatedName;

        @Override
        @NotNull
        public String targetClass() {
            return this.targetClass;
        }

        @Override
        public void applyChange(@NotNull MappingSet input) {
            ClassMapping<?, ?> newMap;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            ClassMapping<?, ?> classMapping = LorenzUtil.getClassMapping(input, this.targetClass);
            if (classMapping == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue(classMapping, (String)"LorenzUtil.getClassMappi\u2026t, targetClass) ?: return");
            ClassMapping<?, ?> classMapping2 = classMapping;
            LorenzUtil.removeClassMapping(classMapping2);
            ClassMapping<?, ?> classMapping3 = newMap = input.getOrCreateClassMapping(this.newFullObfuscatedName);
            Intrinsics.checkNotNullExpressionValue(classMapping3, (String)"newMap");
            this.copyMapping(classMapping2, classMapping3);
        }

        private final void copyMapping(ClassMapping<?, ?> from, ClassMapping<?, ?> to) {
            to.setDeobfuscatedName(from.getDeobfuscatedName());
            for (MethodMapping methodMapping : from.getMethodMappings()) {
                methodMapping.copy(to);
            }
            for (FieldMapping fieldMapping : from.getFieldMappings()) {
                fieldMapping.copy(to);
            }
            for (InnerClassMapping innerClassMapping : from.getInnerClassMappings()) {
                innerClassMapping.copy(to);
            }
        }

        public ChangeObfClassName(@NotNull String targetClass, @NotNull String newFullObfuscatedName) {
            Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
            Intrinsics.checkNotNullParameter((Object)newFullObfuscatedName, (String)"newFullObfuscatedName");
            this.targetClass = targetClass;
            this.newFullObfuscatedName = newFullObfuscatedName;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0010\u0010\u0007\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lio/papermc/paperweight/tasks/CleanupSourceMappings$RemoveAnonymousClassRenames;", "Lpaper/libs/dev/denwav/hypo/mappings/contributors/ChangeContributor;", "()V", "contribute", "", "currentClass", "Lpaper/libs/dev/denwav/hypo/model/data/ClassData;", "classMapping", "Lpaper/libs/org/cadixdev/lorenz/model/ClassMapping;", "context", "Lpaper/libs/dev/denwav/hypo/core/HypoContext;", "registry", "Lpaper/libs/dev/denwav/hypo/mappings/ChangeRegistry;", "name", "", "paperweight-lib"})
    public static final class RemoveAnonymousClassRenames
    implements ChangeContributor {
        @NotNull
        public static final RemoveAnonymousClassRenames INSTANCE;

        @Override
        public void contribute(@Nullable ClassData currentClass, @Nullable ClassMapping<?, ?> classMapping, @NotNull HypoContext context, @NotNull ChangeRegistry registry) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            if (classMapping == null) {
                return;
            }
            String string = classMapping.getObfuscatedName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classMapping.obfuscatedName");
            Integer obf = StringsKt.toIntOrNull((String)string);
            String string2 = classMapping.getDeobfuscatedName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classMapping.deobfuscatedName");
            Integer deobf = StringsKt.toIntOrNull((String)string2);
            if (obf != null && deobf != null && Intrinsics.areEqual((Object)obf, (Object)deobf) ^ true) {
                StringBuilder stringBuilder = new StringBuilder();
                String string3 = classMapping.getFullObfuscatedName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"classMapping.fullObfuscatedName");
                String newName = stringBuilder.append(StringsKt.substringBeforeLast$default((String)string3, (char)'$', null, (int)2, null)).append('$').append(classMapping.getDeobfuscatedName()).append(CleanupSourceMappings.TEMP_SUFFIX).toString();
                String string4 = classMapping.getFullObfuscatedName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"classMapping.fullObfuscatedName");
                registry.submitChange(new ChangeObfClassName(string4, newName));
            }
        }

        @Override
        @NotNull
        public String name() {
            return "RemoveAnonymousClassRenames";
        }

        private RemoveAnonymousClassRenames() {
        }

        static {
            RemoveAnonymousClassRenames removeAnonymousClassRenames;
            INSTANCE = removeAnonymousClassRenames = new RemoveAnonymousClassRenames();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0010\u0010\u0007\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lio/papermc/paperweight/tasks/CleanupSourceMappings$CleanupAfterRemoveAnonymousClassRenames;", "Lpaper/libs/dev/denwav/hypo/mappings/contributors/ChangeContributor;", "()V", "contribute", "", "currentClass", "Lpaper/libs/dev/denwav/hypo/model/data/ClassData;", "classMapping", "Lpaper/libs/org/cadixdev/lorenz/model/ClassMapping;", "context", "Lpaper/libs/dev/denwav/hypo/core/HypoContext;", "registry", "Lpaper/libs/dev/denwav/hypo/mappings/ChangeRegistry;", "name", "", "paperweight-lib"})
    public static final class CleanupAfterRemoveAnonymousClassRenames
    implements ChangeContributor {
        @NotNull
        public static final CleanupAfterRemoveAnonymousClassRenames INSTANCE;

        @Override
        public void contribute(@Nullable ClassData currentClass, @Nullable ClassMapping<?, ?> classMapping, @NotNull HypoContext context, @NotNull ChangeRegistry registry) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            if (classMapping == null) {
                return;
            }
            String string = classMapping.getFullObfuscatedName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classMapping.fullObfuscatedName");
            if (StringsKt.endsWith$default((String)string, (String)CleanupSourceMappings.TEMP_SUFFIX, (boolean)false, (int)2, null)) {
                String string2 = classMapping.getFullObfuscatedName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classMapping.fullObfuscatedName");
                String newName = StringsKt.substringBefore$default((String)string2, (String)CleanupSourceMappings.TEMP_SUFFIX, null, (int)2, null);
                String string3 = classMapping.getFullObfuscatedName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"classMapping.fullObfuscatedName");
                registry.submitChange(new ChangeObfClassName(string3, newName));
            }
        }

        @Override
        @NotNull
        public String name() {
            return "CleanupAfterRemoveAnonymousClassRenames";
        }

        private CleanupAfterRemoveAnonymousClassRenames() {
        }

        static {
            CleanupAfterRemoveAnonymousClassRenames cleanupAfterRemoveAnonymousClassRenames;
            INSTANCE = cleanupAfterRemoveAnonymousClassRenames = new CleanupAfterRemoveAnonymousClassRenames();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0006B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lio/papermc/paperweight/tasks/CleanupSourceMappings$CleanupSourceMappingsAction;", "Lorg/gradle/workers/WorkAction;", "Lio/papermc/paperweight/tasks/CleanupSourceMappings$CleanupSourceMappingsAction$Parameters;", "()V", "execute", "", "Parameters", "paperweight-lib"})
    public static abstract class CleanupSourceMappingsAction
    implements WorkAction<Parameters> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            boolean bl;
            OpenOption[] hypoContext2;
            MappingSet mappings = MappingFormats.INSTANCE.getTINY().read(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((Parameters)this.getParameters()).getInputMappings())), "spigot", "mojang+yarn");
            boolean bl2 = false;
            List<ClassNameChange> caseOnlyChanges = Collections.synchronizedList(new ArrayList());
            Object object = HypoContext.builder().withProvider(AsmClassDataProvider.of(ClassProviderRoot.fromJar(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((Parameters)this.getParameters()).getSourceJar()))))).withContextProvider(AsmClassDataProvider.of(UtilsKt.toJarClassProviderRoots((FileCollection)((Parameters)this.getParameters()).getLibraries()))).withContextProvider(AsmClassDataProvider.of(ClassProviderRoot.ofJdk())).build();
            boolean bl3 = false;
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                hypoContext2 = (HypoContext)object;
                bl = false;
                HydrationManager.createDefault().register(BridgeMethodHydrator.create()).register(SuperConstructorHydrator.create()).hydrate((HypoContext)hypoContext2);
                ChangeChain changeChain = ChangeChain.create().addLink((ChangeContributor)RemoveLambdaMappings.INSTANCE).addLink((ChangeContributor)ParamIndexesForSource.INSTANCE);
                List<ClassNameChange> list = caseOnlyChanges;
                Intrinsics.checkNotNullExpressionValue(list, (String)"caseOnlyChanges");
                hypoContext2 = changeChain.addLink((ChangeContributor)new FindCaseOnlyClassNameChanges(list)).addLink((ChangeContributor)RemoveAnonymousClassRenames.INSTANCE).addLink((ChangeContributor)CleanupAfterRemoveAnonymousClassRenames.INSTANCE).applyChain(mappings, MappingsCompletionManager.create((HypoContext)hypoContext2));
            }
            catch (Throwable hypoContext2) {
                throwable = hypoContext2;
                throw hypoContext2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            Intrinsics.checkNotNullExpressionValue((Object)hypoContext2, (String)"HypoContext.builder()\n  \u2026ntext))\n                }");
            OpenOption[] cleanedMappings = hypoContext2;
            MappingFormats.INSTANCE.getTINY().write((MappingSet)cleanedMappings, FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((Parameters)this.getParameters()).getOutputMappings())), "spigot", "mojang+yarn");
            object = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((Parameters)this.getParameters()).getCaseOnlyNameChanges()));
            Charset charset = Charsets.UTF_8;
            hypoContext2 = new OpenOption[]{};
            int n = 8192;
            bl = false;
            object = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(hypoContext2, hypoContext2.length)), charset), n);
            boolean bl5 = false;
            n = 0;
            Throwable throwable2 = null;
            try {
                BufferedWriter writer = (BufferedWriter)object;
                boolean bl6 = false;
                UtilsKt.getGson().toJson(caseOnlyChanges, (Appendable)writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0005R\u0012\u0010\u000e\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lio/papermc/paperweight/tasks/CleanupSourceMappings$CleanupSourceMappingsAction$Parameters;", "Lorg/gradle/workers/WorkParameters;", "caseOnlyNameChanges", "Lorg/gradle/api/file/RegularFileProperty;", "getCaseOnlyNameChanges", "()Lorg/gradle/api/file/RegularFileProperty;", "inputMappings", "getInputMappings", "libraries", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getLibraries", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputMappings", "getOutputMappings", "sourceJar", "getSourceJar", "paperweight-lib"})
        public static interface Parameters
        extends WorkParameters {
            @NotNull
            public RegularFileProperty getInputMappings();

            @NotNull
            public ConfigurableFileCollection getLibraries();

            @NotNull
            public RegularFileProperty getSourceJar();

            @NotNull
            public RegularFileProperty getOutputMappings();

            @NotNull
            public RegularFileProperty getCaseOnlyNameChanges();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/papermc/paperweight/tasks/CleanupSourceMappings$Companion;", "", "()V", "TEMP_SUFFIX", "", "paperweight-lib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

