/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.tasks.ApplyCraftBukkitPatches;
import io.papermc.paperweight.tasks.ControllableOutputTask;
import io.papermc.paperweight.util.Command;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.Git;
import io.papermc.paperweight.util.UselessOutputStream;
import io.papermc.paperweight.util.UtilsKt;
import io.papermc.paperweight.util.ZipKt;
import java.io.Closeable;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.stream.Stream;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J\b\u0010%\u001a\u00020 H\u0007J\f\u0010&\u001a\u00020'*\u00020'H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u0014\u0010\u0011\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\rR\u0014\u0010\u0013\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\rR\u0014\u0010\u0015\u001a\u00020\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0018\u00a8\u0006("}, d2={"Lio/papermc/paperweight/tasks/ApplyCraftBukkitPatches;", "Lio/papermc/paperweight/tasks/ControllableOutputTask;", "()V", "branch", "Lorg/gradle/api/provider/Property;", "", "getBranch", "()Lorg/gradle/api/provider/Property;", "cleanDirPath", "getCleanDirPath", "craftBukkitDir", "Lorg/gradle/api/file/DirectoryProperty;", "getCraftBukkitDir", "()Lorg/gradle/api/file/DirectoryProperty;", "ignoreGitIgnore", "", "getIgnoreGitIgnore", "outputDir", "getOutputDir", "patchDir", "getPatchDir", "patchZip", "Lorg/gradle/api/file/RegularFileProperty;", "getPatchZip", "()Lorg/gradle/api/file/RegularFileProperty;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "getProviders", "()Lorg/gradle/api/provider/ProviderFactory;", "sourceJar", "getSourceJar", "init", "", "javaFileName", "rootDir", "Ljava/nio/file/Path;", "file", "run", "setupOut", "Lio/papermc/paperweight/util/Command;", "paperweight-lib"})
public abstract class ApplyCraftBukkitPatches
extends ControllableOutputTask {
    @InputFile
    @NotNull
    public abstract RegularFileProperty getSourceJar();

    @Input
    @NotNull
    public abstract Property<String> getCleanDirPath();

    @Optional
    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getPatchDir();

    @Optional
    @InputFile
    @NotNull
    public abstract RegularFileProperty getPatchZip();

    @Input
    @NotNull
    public abstract Property<String> getBranch();

    @Input
    @NotNull
    public abstract Property<Boolean> getIgnoreGitIgnore();

    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getCraftBukkitDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @Inject
    @NotNull
    public abstract ProviderFactory getProviders();

    @Override
    public void init() {
        this.getPrintOutput().convention((Object)false);
        this.getIgnoreGitIgnore().convention(Git.Companion.ignoreProperty(this.getProviders())).finalizeValueOnRead();
        DirectoryProperty directoryProperty = this.getOutputDir();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        FileKt.convention(directoryProperty, project, FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)UtilsKt.defaultOutput(this, "repo"))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void run() {
        Path path;
        Path patchSource;
        Git.Companion.checkForGit();
        FileKt.deleteRecursively$default(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputDir())), null, 1, null);
        Path path2 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputDir())).getParent();
        boolean bl = false;
        boolean bl2 = false;
        Path it = path2;
        boolean bl32 = false;
        Path path3 = it;
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"it");
        Path path4 = path3;
        Object object = new FileAttribute[]{};
        boolean bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path4, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"Files.createDirectories(this, *attributes)");
        Git git3 = new Git(it, null, 2, null);
        String[] stringArray = new String[4];
        stringArray[0] = "clone";
        stringArray[1] = "--no-hardlinks";
        object = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getCraftBukkitDir()));
        bl4 = false;
        stringArray[2] = ((Object)object.toAbsolutePath()).toString();
        object = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputDir()));
        bl4 = false;
        stringArray[3] = ((Object)object.toAbsolutePath()).toString();
        this.setupOut(git3.invoke(stringArray)).execute();
        Git git2 = new Git(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputDir())), null, 2, null);
        Path basePatchDirFile = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputDir())).resolve("src/main/java");
        Path path5 = basePatchDirFile.resolve((String)this.getCleanDirPath().get());
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"basePatchDirFile.resolve(cleanDirPath.get())");
        FileKt.deleteRecursively$default(path5, null, 1, null);
        Path path6 = FileKt.getPathOrNull((Provider<? extends FileSystemLocation>)((Provider)this.getPatchDir()));
        if (path6 == null) {
            path6 = patchSource = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getPatchZip()));
        }
        if ((path = FileKt.getPathOrNull((Provider<? extends FileSystemLocation>)((Provider)this.getPatchDir()))) == null) {
            Path bl32 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getPatchZip()));
            boolean git3 = false;
            boolean bl5 = false;
            Path it4222 = bl32;
            boolean bl6 = false;
            path = ZipKt.unzip(it4222, UtilsKt.findOutputDir(it4222));
        }
        Path rootPatchDir = path;
        try {
            Object fs2;
            Path bl32 = rootPatchDir;
            Object git3 = new LinkOption[]{};
            boolean bl7 = false;
            if (!Files.isDirectory(bl32, Arrays.copyOf(git3, ((LinkOption[])git3).length))) {
                throw (Throwable)new PaperweightException("Patch directory does not exist " + patchSource);
            }
            git3 = Files.walk(rootPatchDir, new FileVisitOption[0]);
            bl7 = false;
            boolean it4222 = false;
            Throwable it4222 = null;
            try {
                Object it2 = (Stream)git3;
                boolean bl8 = false;
                Stream stream = it2;
                Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"it");
                it2 = SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)stream), (Function1)run.patchList.1.1.INSTANCE));
            }
            catch (Throwable it2) {
                it4222 = it2;
                throw it2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)git3, (Throwable)it4222);
            }
            Object patchList2 = it2;
            if (patchList2.isEmpty()) {
                throw (Throwable)new PaperweightException("No patch files found in " + patchSource);
            }
            git3 = FileKt.openZip(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getSourceJar())));
            bl7 = false;
            boolean it4222 = false;
            Throwable it4222 = null;
            try {
                fs2 = (FileSystem)git3;
                boolean bl9 = false;
                Iterator iterator = patchList2.iterator();
                while (iterator.hasNext()) {
                    Path file;
                    Path path7 = file = (Path)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"file");
                    String javaName = this.javaFileName(rootPatchDir, path7);
                    Path out = basePatchDirFile.resolve(javaName);
                    Path sourcePath = ((FileSystem)fs2).getPath(javaName, new String[0]);
                    Path path8 = out;
                    Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"out");
                    Path path9 = path8.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"out.parent");
                    Path path10 = path9;
                    Object object2 = new FileAttribute[]{};
                    boolean bl10 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path10, Arrays.copyOf(object2, ((FileAttribute[])object2).length)), (String)"Files.createDirectories(this, *attributes)");
                    Path path11 = sourcePath;
                    Intrinsics.checkNotNullExpressionValue((Object)path11, (String)"sourcePath");
                    path10 = path11;
                    object2 = out;
                    bl10 = false;
                    boolean bl11 = false;
                    CopyOption[] copyOptionArray = new CopyOption[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path10, (Path)object2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.copy(this, target, *options)");
                }
                fs2 = Unit.INSTANCE;
            }
            catch (Throwable fs2) {
                it4222 = fs2;
                throw fs2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)git3, (Throwable)it4222);
            }
            String[] stringArray2 = Git.Companion.add((Provider<Boolean>)((Provider)this.getIgnoreGitIgnore()), "src");
            this.setupOut(git2.invoke(Arrays.copyOf(stringArray2, stringArray2.length))).execute();
            this.setupOut(git2.invoke("commit", "-m", "Vanilla $ " + new Date(), "--author=Vanilla <auto@mated.null>")).execute();
            Iterator iterator = patchList2.iterator();
            while (iterator.hasNext()) {
                Path file;
                Path path12 = file = (Path)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)path12, (String)"file");
                String javaName = this.javaFileName(rootPatchDir, path12);
                Object object3 = this.getPrintOutput().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"printOutput.get()");
                if (((Boolean)object3).booleanValue()) {
                    fs2 = "Patching " + StringsKt.removeSuffix((String)javaName, (CharSequence)".java");
                    boolean bl12 = false;
                    System.out.println(fs2);
                }
                Path path13 = basePatchDirFile;
                Intrinsics.checkNotNullExpressionValue((Object)path13, (String)"basePatchDirFile");
                String dirPrefix = PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)path13, (Path)FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputDir()))));
                String[] stringArray3 = new String[4];
                stringArray3[0] = "apply";
                stringArray3[1] = "--ignore-whitespace";
                stringArray3[2] = "--directory=" + dirPrefix;
                Path path14 = file;
                boolean bl13 = false;
                stringArray3[3] = ((Object)path14.toAbsolutePath()).toString();
                this.setupOut(git2.invoke(stringArray3)).execute();
            }
            String[] stringArray4 = Git.Companion.add((Provider<Boolean>)((Provider)this.getIgnoreGitIgnore()), "src");
            this.setupOut(git2.invoke(Arrays.copyOf(stringArray4, stringArray4.length))).execute();
            this.setupOut(git2.invoke("commit", "-m", "CraftBukkit $ " + new Date(), "--author=CraftBukkit <auto@mated.null>")).execute();
        }
        finally {
            if (Intrinsics.areEqual((Object)rootPatchDir, (Object)FileKt.getPathOrNull((Provider<? extends FileSystemLocation>)((Provider)this.getPatchDir()))) ^ true) {
                FileKt.deleteRecursively$default(rootPatchDir, null, 1, null);
            }
        }
    }

    private final String javaFileName(Path rootDir, Path file) {
        return StringsKt.replaceAfterLast$default((String)((Object)PathsKt.relativeTo((Path)file, (Path)rootDir)).toString(), (char)'.', (String)"java", null, (int)4, null);
    }

    private final Command setupOut(Command $this$setupOut) {
        Command command = $this$setupOut;
        boolean bl = false;
        boolean bl2 = false;
        Command $this$apply = command;
        boolean bl3 = false;
        Object object = this.getPrintOutput().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"printOutput.get()");
        if (((Boolean)object).booleanValue()) {
            $this$apply.setup(System.out, System.err);
        } else {
            $this$apply.setup(UselessOutputStream.INSTANCE, UselessOutputStream.INSTANCE);
        }
        return command;
    }
}

