/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperclipmavenplugin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jbsdiff.Diff;
import org.jbsdiff.InvalidHeaderException;

@Mojo(name="generate-data", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateDataMojo
extends AbstractMojo {
    private static final String PROTOCOL_FILE = "io.papermc.paper.daemon.protocol";
    @Parameter(required=true)
    private Path vanillaMinecraft;
    @Parameter(required=true)
    private Path paperMinecraft;
    @Parameter(defaultValue="target/generated-resources")
    private Path generatedResourceLocation;
    @Parameter(required=true)
    private String mcVersion;

    public void execute() throws MojoExecutionException {
        MessageDigest digestSha1;
        MessageDigest digest;
        byte[] paperMinecraftBytes;
        byte[] vanillaMinecraftBytes;
        URI zipUri;
        Path patch = this.generatedResourceLocation.resolve("paperMC.patch");
        Path propFile = this.generatedResourceLocation.resolve("patch.properties");
        Path protocol = this.generatedResourceLocation.resolve("META-INF/io.papermc.paper.daemon.protocol");
        if (Files.notExists(this.generatedResourceLocation, new LinkOption[0])) {
            try {
                Files.createDirectories(this.generatedResourceLocation, new FileAttribute[0]);
                Files.deleteIfExists(patch);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not create source directory", (Exception)e);
            }
        }
        if (Files.notExists(this.vanillaMinecraft, new LinkOption[0])) {
            throw new MojoExecutionException("vanillaMinecraft jar does not exist!");
        }
        if (Files.notExists(this.paperMinecraft, new LinkOption[0])) {
            throw new MojoExecutionException("paperMinecraft jar does not exist!");
        }
        try {
            URI jarUri = this.paperMinecraft.toUri();
            zipUri = new URI("jar:" + jarUri.getScheme(), jarUri.getPath(), null);
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("Failed to create jar URI for " + this.paperMinecraft);
        }
        try (FileSystem zipFs = FileSystems.newFileSystem(zipUri, new HashMap());){
            Path protocolPath = zipFs.getPath("META-INF", PROTOCOL_FILE);
            if (Files.notExists(protocolPath, new LinkOption[0])) {
                Files.deleteIfExists(protocol);
            } else {
                Files.createDirectories(protocol.getParent(), new FileAttribute[0]);
                Files.copy(protocolPath, protocol, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read " + this.paperMinecraft + " contents", (Exception)e);
        }
        this.getLog().info((CharSequence)"Reading jars into memory");
        try {
            vanillaMinecraftBytes = Files.readAllBytes(this.vanillaMinecraft);
            paperMinecraftBytes = Files.readAllBytes(this.paperMinecraft);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading jars", (Exception)e);
        }
        this.getLog().info((CharSequence)"Creating patch");
        try (OutputStream paperMinecraftPatch = Files.newOutputStream(patch, new OpenOption[0]);){
            Diff.diff((byte[])vanillaMinecraftBytes, (byte[])paperMinecraftBytes, (OutputStream)paperMinecraftPatch);
        }
        catch (IOException | CompressorException | InvalidHeaderException e) {
            throw new MojoExecutionException("Error creating patches", (Exception)e);
        }
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new MojoExecutionException("Could not create SHA-256 hasher.", (Exception)e);
        }
        try {
            digestSha1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new MojoExecutionException("Could not create SHA1 hasher.", (Exception)e);
        }
        this.getLog().info((CharSequence)"Hashing files");
        byte[] vanillaSha1 = digestSha1.digest(vanillaMinecraftBytes);
        byte[] vanillaMinecraftHash = digest.digest(vanillaMinecraftBytes);
        byte[] paperMinecraftHash = digest.digest(paperMinecraftBytes);
        Properties prop = new Properties();
        prop.setProperty("originalHash", this.toHex(vanillaMinecraftHash));
        prop.setProperty("patchedHash", this.toHex(paperMinecraftHash));
        prop.setProperty("patch", "paperMC.patch");
        prop.setProperty("sourceUrl", "https://launcher.mojang.com/v1/objects/" + this.toHex(vanillaSha1).toLowerCase() + "/server.jar");
        prop.setProperty("version", this.mcVersion);
        this.getLog().info((CharSequence)"Writing properties file");
        try (BufferedWriter writer = Files.newBufferedWriter(propFile, new OpenOption[0]);){
            prop.store(writer, "Default Paperclip launch values. Can be overridden by placing a paperclip.properties file in the server directory.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String toHex(byte[] hash) {
        StringBuilder sb = new StringBuilder(hash.length * 2);
        for (byte aHash : hash) {
            sb.append(String.format("%02X", aHash & 0xFF));
        }
        return sb.toString();
    }

    public void setVanillaMinecraft(File vanillaMinecraft) {
        this.vanillaMinecraft = vanillaMinecraft.toPath();
    }

    public void setPaperMinecraft(File paperMinecraft) {
        this.paperMinecraft = paperMinecraft.toPath();
    }

    public void setGeneratedResourceLocation(File generatedResourceLocation) {
        this.generatedResourceLocation = generatedResourceLocation.toPath();
    }
}

