/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.player;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerBucketEvent
extends PlayerEvent
implements Cancellable {
    private final Block block;
    private final Block blockClicked;
    private final BlockFace blockFace;
    private final Material bucket;
    private final EquipmentSlot hand;
    private ItemStack itemStack;
    private boolean cancelled;

    @Deprecated(since="1.14.4", forRemoval=true)
    @ApiStatus.Internal
    public PlayerBucketEvent(@NotNull Player player, @NotNull Block blockClicked, @NotNull BlockFace blockFace, @NotNull Material bucket, @NotNull ItemStack itemInHand) {
        this(player, null, blockClicked.getRelative(blockFace), blockFace, bucket, itemInHand, EquipmentSlot.HAND);
    }

    @Deprecated(since="1.19.2", forRemoval=true)
    @ApiStatus.Internal
    public PlayerBucketEvent(@NotNull Player player, @NotNull Block block, @NotNull Block blockClicked, @NotNull BlockFace blockFace, @NotNull Material bucket, @NotNull ItemStack itemInHand) {
        this(player, block, blockClicked, blockFace, bucket, itemInHand, EquipmentSlot.HAND);
    }

    @ApiStatus.Internal
    public PlayerBucketEvent(@NotNull Player player, @NotNull Block block, @NotNull Block blockClicked, @NotNull BlockFace blockFace, @NotNull Material bucket, @NotNull ItemStack itemInHand, @NotNull EquipmentSlot hand) {
        super(player);
        this.block = block;
        this.blockClicked = blockClicked;
        this.blockFace = blockFace;
        this.itemStack = itemInHand;
        this.bucket = bucket != null && bucket.isLegacy() ? Bukkit.getUnsafe().fromLegacy(new MaterialData(bucket), true) : bucket;
        this.hand = hand;
    }

    @NotNull
    public final Block getBlock() {
        return this.block;
    }

    @NotNull
    public Block getBlockClicked() {
        return this.blockClicked;
    }

    @NotNull
    public BlockFace getBlockFace() {
        return this.blockFace;
    }

    @NotNull
    public Material getBucket() {
        return this.bucket;
    }

    @NotNull
    public EquipmentSlot getHand() {
        return this.hand;
    }

    @Nullable
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(@Nullable ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }
}

