/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.item.ItemComponentTypesBridge;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.object.PlayerHeadObjectContents;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@ApiStatus.Experimental
@ApiStatus.NonExtendable
public interface ResolvableProfile
extends PlayerHeadObjectContents.SkinSource {
    @Contract(value="_ -> new", pure=true)
    public static ResolvableProfile resolvableProfile(PlayerProfile profile) {
        return ItemComponentTypesBridge.bridge().resolvableProfile(profile);
    }

    @Contract(value="-> new", pure=true)
    public static Builder resolvableProfile() {
        return ItemComponentTypesBridge.bridge().resolvableProfile();
    }

    @Contract(pure=true)
    public @Nullable UUID uuid();

    @Contract(pure=true)
    public @Nullable String name();

    @Contract(pure=true)
    public @Unmodifiable Collection<ProfileProperty> properties();

    @Contract(pure=true)
    public boolean dynamic();

    @Contract(pure=true)
    public CompletableFuture<PlayerProfile> resolve();

    @Contract(pure=true)
    public SkinPatch skinPatch();

    @ApiStatus.Experimental
    @ApiStatus.NonExtendable
    public static interface Builder
    extends DataComponentBuilder<ResolvableProfile> {
        @Contract(value="_ -> this", mutates="this")
        public Builder name(@Pattern(value="^[!-~]{0,16}$") @Nullable String var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder uuid(@Nullable UUID var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder addProperty(ProfileProperty var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder addProperties(Collection<ProfileProperty> var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder skinPatch(SkinPatch var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder skinPatch(Consumer<SkinPatchBuilder> var1);
    }

    @ApiStatus.Experimental
    @ApiStatus.NonExtendable
    public static interface SkinPatchBuilder
    extends DataComponentBuilder<SkinPatch> {
        @Contract(value="_ -> this", mutates="this")
        public SkinPatchBuilder body(@Nullable Key var1);

        @Contract(value="_ -> this", mutates="this")
        public SkinPatchBuilder cape(@Nullable Key var1);

        @Contract(value="_ -> this", mutates="this")
        public SkinPatchBuilder elytra(@Nullable Key var1);

        @Contract(value="_ -> this", mutates="this")
        public SkinPatchBuilder model( @Nullable PlayerTextures.SkinModel var1);
    }

    @ApiStatus.Experimental
    @ApiStatus.NonExtendable
    public static interface SkinPatch {
        public static SkinPatch empty() {
            final class Holder {
                static final SkinPatch INSTANCE = (SkinPatch)ItemComponentTypesBridge.bridge().skinPatch().build();

                Holder() {
                }
            }
            return Holder.INSTANCE;
        }

        @Contract(value="-> new", pure=true)
        public static SkinPatchBuilder skinPatch() {
            return ItemComponentTypesBridge.bridge().skinPatch();
        }

        public @Nullable Key body();

        public @Nullable Key cape();

        public @Nullable Key elytra();

        public  @Nullable PlayerTextures.SkinModel model();

        default public boolean isEmpty() {
            return this.body() == null && this.cape() == null && this.elytra() == null && this.model() == null;
        }
    }
}

