package io.papermc.paper.registry.keys.tags;

import static net.kyori.adventure.key.Key.key;

import io.papermc.paper.annotation.GeneratedClass;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.tag.TagKey;
import net.kyori.adventure.key.Key;
import org.bukkit.Art;
import org.jspecify.annotations.NullMarked;

/**
 * Vanilla tag keys for {@link RegistryKey#PAINTING_VARIANT}.
 *
 * @apiNote The fields provided here are a direct representation of
 * what is available from the vanilla game source. They may be
 * changed (including removals) on any Minecraft version
 * bump, so cross-version compatibility is not provided on the
 * same level as it is on most of the other API.
 */
@SuppressWarnings({
        "unused",
        "SpellCheckingInspection"
})
@NullMarked
@GeneratedClass
public final class PaintingVariantTagKeys {
    /**
     * {@code #minecraft:placeable}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TagKey<Art> PLACEABLE = create(key("placeable"));

    private PaintingVariantTagKeys() {
    }

    /**
     * Creates a tag key for {@link Art} in the registry {@code minecraft:painting_variant}.
     *
     * @param key the tag key's key
     * @return a new tag key
     */
    public static TagKey<Art> create(final Key key) {
        return TagKey.create(RegistryKey.PAINTING_VARIANT, key);
    }
}
