/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.dialog;

import io.papermc.paper.registry.data.dialog.DialogInstancesProvider;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.Nullable;

@ApiStatus.NonExtendable
public interface ActionButton {
    @Contract(value="_, _, _, _ -> new", pure=true)
    public static ActionButton create(Component label, @Nullable Component tooltip, @Range(from=1L, to=1024L) int width, @Nullable DialogAction action) {
        return ActionButton.builder(label).tooltip(tooltip).width(width).action(action).build();
    }

    @Contract(pure=true, value="_ -> new")
    public static Builder builder(Component label) {
        return DialogInstancesProvider.instance().actionButtonBuilder(label);
    }

    @Contract(pure=true)
    public Component label();

    @Contract(pure=true)
    public @Nullable Component tooltip();

    @Contract(pure=true)
    public @Range(from=1L, to=1024L) int width();

    @Contract(pure=true)
    public @Nullable DialogAction action();

    @ApiStatus.NonExtendable
    public static interface Builder {
        @Contract(value="_ -> this", mutates="this")
        public Builder tooltip(@Nullable Component var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder width(@Range(from=1L, to=1024L) int var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder action(@Nullable DialogAction var1);

        @Contract(value="-> new", pure=true)
        public ActionButton build();
    }
}

